/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.visitor;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.garden.visitor.VisitorConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.model.TabWidget;
import at.hannibal2.skyhanni.events.CheckRenderEntityEvent;
import at.hannibal2.skyhanni.events.GuiKeyPressEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.events.WidgetUpdateEvent;
import at.hannibal2.skyhanni.events.garden.visitor.VisitorOpenEvent;
import at.hannibal2.skyhanni.events.garden.visitor.VisitorRenderEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.events.minecraft.ToolTipEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketSentEvent;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.features.garden.visitor.GardenVisitorFeatures;
import at.hannibal2.skyhanni.features.garden.visitor.VisitorApi;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzLogger;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2824;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001d\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010!R\u001b\u0010'\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u0014\u0010+\u001a\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010-\u001a\u00020,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lat/hannibal2/skyhanni/features/garden/visitor/VisitorListener;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "event", "", "onProfileJoin", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketSentEvent;", "onSendEvent", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketSentEvent;)V", "Lat/hannibal2/skyhanni/events/WidgetUpdateEvent;", "onWidgetUpdate", "(Lat/hannibal2/skyhanni/events/WidgetUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryFullyOpened", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/GuiKeyPressEvent;", "onKeybind", "(Lat/hannibal2/skyhanni/events/GuiKeyPressEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;", "onTooltip", "(Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;)V", "Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;", "Lnet/minecraft/class_1531;", "onCheckRender", "(Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Ljava/util/regex/Pattern;", "offersAcceptedPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getOffersAcceptedPattern", "()Ljava/util/regex/Pattern;", "offersAcceptedPattern", "Lat/hannibal2/skyhanni/config/features/garden/visitor/VisitorConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/visitor/VisitorConfig;", "config", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "logger", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nVisitorListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisitorListener.kt\nat/hannibal2/skyhanni/features/garden/visitor/VisitorListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1761#2,3:171\n8#3:174\n1#4:175\n*S KotlinDebug\n*F\n+ 1 VisitorListener.kt\nat/hannibal2/skyhanni/features/garden/visitor/VisitorListener\n*L\n79#1:171,3\n120#1:174\n120#1:175\n*E\n"})
public final class VisitorListener {
    @NotNull
    public static final VisitorListener INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern offersAcceptedPattern$delegate;
    @NotNull
    private static final LorenzLogger logger;

    private VisitorListener() {
    }

    private final Pattern getOffersAcceptedPattern() {
        return (Pattern)offersAcceptedPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final VisitorConfig getConfig() {
        return VisitorApi.INSTANCE.getConfig();
    }

    @HandleEvent
    public final void onProfileJoin(@NotNull ProfileJoinEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VisitorApi.INSTANCE.reset();
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onSendEvent(@NotNull PacketSentEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        class_2596<?> packet = event2.getPacket();
        if (!(packet instanceof class_2824)) {
            return;
        }
        class_1297 class_12972 = MinecraftCompat.INSTANCE.getLocalWorld().method_8469(((class_2824)packet).field_12870);
        if (class_12972 == null) {
            return;
        }
        class_1297 entity = class_12972;
        int entityId = entity.method_5628();
        VisitorApi.INSTANCE.setLastClickedNpc(entityId);
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onWidgetUpdate(@NotNull WidgetUpdateEvent event2) {
        boolean hasVisitorInfo;
        block8: {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            if (!event2.isWidget(TabWidget.VISITORS)) {
                return;
            }
            Iterable $this$any$iv = event2.getLines();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!RegexUtils.INSTANCE.matches(VisitorApi.INSTANCE.getVisitorCountPattern(), it)) continue;
                    v0 = true;
                    break block8;
                }
                v0 = hasVisitorInfo = false;
            }
        }
        if (!hasVisitorInfo) {
            return;
        }
        List<String> visitorsInTab = VisitorApi.INSTANCE.visitorsInTabList(event2.getLines());
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(SkyBlockUtils.INSTANCE.getLastWorldSwitch-uFjCsEo()), (long)DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS)) > 0) {
            for (VisitorApi.Visitor visitor : VisitorApi.INSTANCE.getVisitors()) {
                String name2 = visitor.getVisitorName();
                boolean removed = !visitorsInTab.contains(name2);
                if (!removed) continue;
                logger.log("Removed old visitor: '" + name2 + "'");
                VisitorApi.INSTANCE.removeVisitor(name2);
            }
        }
        for (String name3 : visitorsInTab) {
            VisitorApi.INSTANCE.addVisitor(name3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onInventoryFullyOpened(@NotNull InventoryFullyOpenedEvent event2) {
        Integer n;
        void $this$matchMatcher$iv;
        VisitorApi.Visitor visitor;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        class_1799 class_17992 = event2.getInventoryItems().get(13);
        if (class_17992 == null) {
            return;
        }
        class_1799 npcItem = class_17992;
        List<String> lore = ItemUtils.INSTANCE.getLore(npcItem);
        if (!VisitorApi.INSTANCE.isVisitorInfo(lore)) {
            return;
        }
        class_1799 class_17993 = event2.getInventoryItems().get(29);
        if (class_17993 == null) {
            return;
        }
        class_1799 offerItem = class_17993;
        if (!Intrinsics.areEqual((Object)TextCompatKt.formattedTextCompatLeadingWhiteLessResets(offerItem.method_7964()), (Object)"\u00a7aAccept Offer")) {
            return;
        }
        VisitorApi.INSTANCE.setInInventory(true);
        VisitorApi.VisitorOffer visitorOffer = new VisitorApi.VisitorOffer(offerItem);
        String name2 = TextCompatKt.formattedTextCompatLeadingWhiteLessResets(npcItem.method_7964());
        if (name2.length() == StringUtils.removeColor$default(StringUtils.INSTANCE, name2, false, 1, null).length() + 4) {
            String string = name2.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            name2 = string;
        }
        VisitorApi.Visitor visitor2 = VisitorApi.INSTANCE.getOrCreateVisitor(name2);
        if (visitor2 == null) {
            return;
        }
        VisitorApi.Visitor visitor3 = visitor = visitor2;
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getOffersAcceptedPattern();
        String text$iv = lore.get(3);
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            void $this$onInventoryFullyOpened_u24lambda_u241;
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher matcher = it$iv;
            VisitorApi.Visitor visitor4 = visitor3;
            boolean bl2 = false;
            String string = $this$onInventoryFullyOpened_u24lambda_u241.group("offersAccepted");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            n = Integer.parseInt(string);
            visitor3 = visitor4;
        } else {
            n = null;
        }
        visitor3.setOffersAccepted(n);
        visitor.setEntityId(VisitorApi.INSTANCE.getLastClickedNpc());
        visitor.setOffer(visitorOffer);
        new VisitorOpenEvent(visitor).post();
    }

    @HandleEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VisitorApi.INSTANCE.setInInventory(false);
    }

    @HandleEvent
    public final void onKeybind(@NotNull GuiKeyPressEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!VisitorApi.INSTANCE.getInInventory()) {
            return;
        }
        if (!KeyboardManager.INSTANCE.isKeyHeld(this.getConfig().getAcceptHotkey())) {
            return;
        }
        InventoryUtils.mouseClickSlot$default(InventoryUtils.INSTANCE, 29, 0, null, 6, null);
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onTooltip(@NotNull ToolTipEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!GardenApi.INSTANCE.getOnBarnPlot()) {
            return;
        }
        if (!VisitorApi.INSTANCE.getInInventory()) {
            return;
        }
        VisitorApi.Visitor visitor = VisitorApi.INSTANCE.getVisitor(VisitorApi.INSTANCE.getLastClickedNpc());
        if (visitor == null) {
            return;
        }
        VisitorApi.Visitor visitor2 = visitor;
        GardenVisitorFeatures.INSTANCE.onTooltip(visitor2, event2.getItemStack(), event2.getToolTip());
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onCheckRender(@NotNull CheckRenderEntityEvent<class_1531> event2) {
        Intrinsics.checkNotNullParameter(event2, (String)"event");
        if (!GardenApi.INSTANCE.getOnBarnPlot()) {
            return;
        }
        if (this.getConfig().getHighlightStatus() != VisitorConfig.HighlightMode.NAME && this.getConfig().getHighlightStatus() != VisitorConfig.HighlightMode.BOTH) {
            return;
        }
        class_1531 entity = event2.getEntity();
        if (Intrinsics.areEqual((Object)TextCompatKt.formattedTextCompatLessResets(entity.method_5477()), (Object)"\u00a7e\u00a7lCLICK")) {
            event2.cancel();
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!GardenApi.INSTANCE.getOnBarnPlot()) {
            return;
        }
        if (this.getConfig().getHighlightStatus() != VisitorConfig.HighlightMode.NAME && this.getConfig().getHighlightStatus() != VisitorConfig.HighlightMode.BOTH) {
            return;
        }
        for (VisitorApi.Visitor visitor : VisitorApi.INSTANCE.getVisitors()) {
            class_1297 it;
            if (visitor.getNameTagEntity() == null) continue;
            boolean bl = false;
            if (LocationUtils.INSTANCE.distanceToPlayer(it) > 15.0) continue;
            new VisitorRenderEvent(visitor, WorldRenderUtils.INSTANCE.exactLocation(event2, it), event2).post();
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(VisitorListener.class, "offersAcceptedPattern", "getOffersAcceptedPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new VisitorListener();
        offersAcceptedPattern$delegate = RepoPattern.Companion.pattern("garden.visitor.offersaccepted", "\u00a77Offers Accepted: \u00a7a(?<offersAccepted>\\d+)");
        logger = new LorenzLogger("garden/visitors/listener");
    }
}

