/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.gifting;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.events.IslandChangeEvent;
import at.hannibal2.skyhanni.features.gifting.GiftApi;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\fR\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0012\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lat/hannibal2/skyhanni/features/gifting/IsGiftingDetection;", "", "<init>", "()V", "", "markLocation", "Lat/hannibal2/skyhanni/events/IslandChangeEvent;", "event", "onIslandChange", "(Lat/hannibal2/skyhanni/events/IslandChangeEvent;)V", "", "isCurrentlyGifting", "()Z", "hasPreviouslyGiftedHere", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "lastGiftLocation", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastGiftTime", "J", "1.21.5"})
public final class IsGiftingDetection {
    @NotNull
    public static final IsGiftingDetection INSTANCE = new IsGiftingDetection();
    @Nullable
    private static LorenzVec lastGiftLocation;
    private static long lastGiftTime;

    private IsGiftingDetection() {
    }

    public final void markLocation() {
        lastGiftLocation = LocationUtils.INSTANCE.playerLocation();
        lastGiftTime = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @HandleEvent
    public final void onIslandChange(@NotNull IslandChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        lastGiftLocation = null;
        lastGiftTime = SimpleTimeMark.Companion.farPast();
    }

    public final boolean isCurrentlyGifting() {
        return GiftApi.INSTANCE.isHoldingGift() || this.hasPreviouslyGiftedHere();
    }

    private final boolean hasPreviouslyGiftedHere() {
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastGiftTime), (long)DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.MINUTES)) > 0) {
            return false;
        }
        LorenzVec lorenzVec = lastGiftLocation;
        if (lorenzVec == null) {
            return false;
        }
        LorenzVec lastGiftLocation = lorenzVec;
        return !(LocationUtils.INSTANCE.distanceToPlayer(lastGiftLocation) > 10.0);
    }

    static {
        lastGiftTime = SimpleTimeMark.Companion.farPast();
    }
}

