/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.chocolatefactory;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.event.hoppity.HoppityChatConfig;
import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.CFConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityApi;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityCollectionData;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityCollectionStats;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityEggsManager;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.CFApi;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.CFTimeTowerManager;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.data.ChocolateAmount;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.chat.TextHelper;
import at.hannibal2.skyhanni.utils.collection.TimeLimitedCache;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u0012\u001a\u00020\t*\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0003J\u0015\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001d\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010!\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0016\u0010%\u001a\u0004\u0018\u00010\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R \u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020'0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u001b\u0010/\u001a\u00020*8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u0016\u00100\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00102\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103\u00a8\u00064"}, d2={"Lat/hannibal2/skyhanni/features/inventory/chocolatefactory/CFBarnManager;", "", "<init>", "()V", "", "isBarnFull", "()Z", "Lat/hannibal2/skyhanni/features/event/hoppity/HoppityApi$HoppityStateDataSet;", "dataSet", "", "processDataSet", "(Lat/hannibal2/skyhanni/features/event/hoppity/HoppityApi$HoppityStateDataSet;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "event", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "", "rawAmount", "duplicateFoundMessage", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;Ljava/lang/String;)V", "onInventoryClose", "inventory", "trySendBarnFullMessage", "(Z)V", "barnStatus", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/CFConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/CFConfig;", "config", "Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityChatConfig;", "getHoppityChatConfig", "()Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityChatConfig;", "hoppityChatConfig", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CFStorage;", "getProfileStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CFStorage;", "profileStorage", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedCache;", "", "virtualCountHolder", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedCache;", "Ljava/util/regex/Pattern;", "rabbitCrashedPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getRabbitCrashedPattern", "()Ljava/util/regex/Pattern;", "rabbitCrashedPattern", "sentBarnFullWarning", "Z", "lastRabbit", "Ljava/lang/String;", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nCFBarnManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CFBarnManager.kt\nat/hannibal2/skyhanni/features/inventory/chocolatefactory/CFBarnManager\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n8#2:166\n8#2:168\n8#2:170\n1#3:167\n1#3:169\n1#3:171\n1#3:172\n*S KotlinDebug\n*F\n+ 1 CFBarnManager.kt\nat/hannibal2/skyhanni/features/inventory/chocolatefactory/CFBarnManager\n*L\n58#1:166\n65#1:168\n70#1:170\n58#1:167\n65#1:169\n70#1:171\n*E\n"})
public final class CFBarnManager {
    @NotNull
    public static final CFBarnManager INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final TimeLimitedCache<String, Integer> virtualCountHolder;
    @NotNull
    private static final RepoPattern rabbitCrashedPattern$delegate;
    private static boolean sentBarnFullWarning;
    @NotNull
    private static String lastRabbit;

    private CFBarnManager() {
    }

    private final CFConfig getConfig() {
        return CFApi.INSTANCE.getConfig();
    }

    private final HoppityChatConfig getHoppityChatConfig() {
        return HoppityEggsManager.INSTANCE.getConfig().getChat();
    }

    private final ProfileSpecificStorage.CFStorage getProfileStorage() {
        return CFApi.INSTANCE.getProfileStorage();
    }

    private final Pattern getRabbitCrashedPattern() {
        return (Pattern)rabbitCrashedPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    public final boolean isBarnFull() {
        ProfileSpecificStorage.CFStorage cFStorage = this.getProfileStorage();
        if (cFStorage == null) {
            return false;
        }
        ProfileSpecificStorage.CFStorage profileStorage = cFStorage;
        boolean alreadyBigEnough = profileStorage.getMaxRabbits() >= HoppityCollectionData.INSTANCE.getKnownRabbitCount();
        int remainingSpace = profileStorage.getMaxRabbits() - profileStorage.getCurrentRabbits();
        return remainingSpace <= this.getConfig().getBarnCapacityThreshold() && !alreadyBigEnough;
    }

    public final void processDataSet(@NotNull HoppityApi.HoppityStateDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        lastRabbit = dataSet.getLastName();
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onChat(@NotNull SkyHanniChatEvent event2) {
        Pattern $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = HoppityEggsManager.INSTANCE.getNewRabbitFound();
        String text$iv = event2.getMessage();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$onChat_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            ProfileSpecificStorage.CFStorage cFStorage = INSTANCE.getProfileStorage();
            if (cFStorage != null) {
                ProfileSpecificStorage.CFStorage profileStorage = cFStorage;
                profileStorage.setCurrentRabbits(profileStorage.getCurrentRabbits() + 1);
                INSTANCE.trySendBarnFullMessage(false);
                HoppityEggsManager.INSTANCE.shareWaypointPrompt();
            }
        }
        RegexUtils this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = HoppityEggsManager.INSTANCE.getDuplicateRabbitFound();
        text$iv = event2.getMessage();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(text$iv);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$onChat_u24lambda_u241 = it$iv;
            boolean bl3 = false;
            HoppityEggsManager.INSTANCE.shareWaypointPrompt();
            String string = $this$onChat_u24lambda_u241.group("amount");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            INSTANCE.duplicateFoundMessage(event2, string);
        }
        this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getRabbitCrashedPattern();
        text$iv = event2.getMessage();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(text$iv);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$onChat_u24lambda_u242 = it$iv;
            boolean bl4 = false;
            HoppityEggsManager.INSTANCE.shareWaypointPrompt();
            String string = $this$onChat_u24lambda_u242.group("amount");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            ChocolateAmount.Companion.addToAll(NumberUtil.INSTANCE.formatLong(string));
        }
    }

    private final void duplicateFoundMessage(SkyHanniChatEvent $this$duplicateFoundMessage, String rawAmount) {
        long amount = NumberUtil.INSTANCE.formatLong(rawAmount);
        if (this.getConfig().getShowDuplicateTime() && !this.getHoppityChatConfig().getCompact()) {
            String format = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, CFApi.INSTANCE.timeUntilNeed-5sfh64U(amount), null, false, false, 2, false, false, 55, null);
            DelayedRun.INSTANCE.runNextTick((Function0<Unit>)((Function0)() -> CFBarnManager.duplicateFoundMessage$lambda$3(format)));
        }
        ChocolateAmount.Companion.addToAll(amount);
        HoppityApi.INSTANCE.attemptFireRabbitFound($this$duplicateFoundMessage, amount);
        String changedMessage = null;
        changedMessage = $this$duplicateFoundMessage.getMessage();
        if (this.getHoppityChatConfig().getShowDuplicateNumber() && !this.getHoppityChatConfig().getCompact()) {
            Integer dupeNumber;
            Integer n;
            if (virtualCountHolder.get(lastRabbit) != null) {
                Integer n2 = (Integer)virtualCountHolder.get(lastRabbit);
                n = (n2 != null ? n2 : 0) + 1;
            } else {
                Integer n3 = HoppityCollectionStats.INSTANCE.getRabbitCount(lastRabbit);
                int it = ((Number)n3).intValue();
                boolean bl = false;
                Integer n4 = it > 0 ? n3 : null;
                if (n4 != null) {
                    n3 = n4;
                    it = ((Number)n3).intValue();
                    boolean bl2 = false;
                    virtualCountHolder.set(lastRabbit, it);
                    n = n3;
                } else {
                    n = null;
                }
            }
            Integer n5 = dupeNumber = n;
            if (n5 != null) {
                int it = ((Number)n5).intValue();
                boolean bl = false;
                changedMessage = StringsKt.replace$default((String)changedMessage, (String)"\u00a77\u00a7lDUPLICATE RABBIT!", (String)("\u00a77\u00a7lDUPLICATE RABBIT! \u00a77(Duplicate \u00a7b#" + it + "\u00a77)\u00a7r"), (boolean)false, (int)4, null);
            }
        }
        if (this.getHoppityChatConfig().getRecolorTTChocolate() && CFTimeTowerManager.INSTANCE.timeTowerActive()) {
            changedMessage = StringsKt.replace$default((String)changedMessage, (String)"\u00a76\\+(?<amount>[\\d,]+) Chocolate", (String)("\u00a76\\+\u00a7d" + rawAmount + " \u00a76Chocolate"), (boolean)false, (int)4, null);
        }
        if (!Intrinsics.areEqual((Object)$this$duplicateFoundMessage.getMessage(), (Object)changedMessage)) {
            $this$duplicateFoundMessage.setChatComponent((class_2561)TextHelper.asComponent$default(TextHelper.INSTANCE, changedMessage, null, 1, null));
        }
    }

    @HandleEvent(eventType=InventoryCloseEvent.class)
    public final void onInventoryClose() {
        sentBarnFullWarning = false;
    }

    public final void trySendBarnFullMessage(boolean inventory) {
        if (!CFApi.INSTANCE.isEnabled()) {
            return;
        }
        if (this.getConfig().getBarnCapacityThreshold() <= 0) {
            return;
        }
        ProfileSpecificStorage.CFStorage cFStorage = this.getProfileStorage();
        if (cFStorage == null) {
            return;
        }
        ProfileSpecificStorage.CFStorage profileStorage = cFStorage;
        if (profileStorage.getMaxRabbits() >= CFApi.INSTANCE.getMaxRabbits()) {
            return;
        }
        if (!this.isBarnFull()) {
            return;
        }
        if (inventory && sentBarnFullWarning) {
            return;
        }
        sentBarnFullWarning = true;
        if (profileStorage.getMaxRabbits() == -1) {
            ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "Open your chocolate factory to see your barn's capacity status!", CFBarnManager::trySendBarnFullMessage$lambda$7, "\u00a7eClick to run /cf!", 0L, false, null, false, false, 248, null);
            return;
        }
        if (this.getConfig().getRabbitCrushOnlyDuringHoppity() && !HoppityApi.INSTANCE.isHoppityEvent()) {
            return;
        }
        String fullLevel = profileStorage.getCurrentRabbits() == profileStorage.getMaxRabbits() ? "full" : "almost full";
        ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "\u00a7cYour barn is " + fullLevel + " \u00a77(" + this.barnStatus() + "). \u00a7cUpgrade it so they don't get crushed!", CFBarnManager::trySendBarnFullMessage$lambda$8, "\u00a7eClick to run /cf!", 0L, false, null, false, false, 248, null);
        SoundUtils.playBeepSound$default(SoundUtils.INSTANCE, 0.0f, 1, null);
    }

    @NotNull
    public final String barnStatus() {
        ProfileSpecificStorage.CFStorage cFStorage = this.getProfileStorage();
        if (cFStorage == null) {
            return "Unknown";
        }
        ProfileSpecificStorage.CFStorage profileStorage = cFStorage;
        return profileStorage.getCurrentRabbits() + "/" + profileStorage.getMaxRabbits() + " Rabbits";
    }

    private static final Unit duplicateFoundMessage$lambda$3(String $format) {
        Intrinsics.checkNotNullParameter((Object)$format, (String)"$format");
        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77(\u00a7a+\u00a7b" + $format + " \u00a7aof production\u00a77)", false, null, false, false, null, 62, null);
        return Unit.INSTANCE;
    }

    private static final Unit trySendBarnFullMessage$lambda$7() {
        HypixelCommands.INSTANCE.chocolateFactory();
        return Unit.INSTANCE;
    }

    private static final Unit trySendBarnFullMessage$lambda$8() {
        HypixelCommands.INSTANCE.chocolateFactory();
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CFBarnManager.class, "rabbitCrashedPattern", "getRabbitCrashedPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new CFBarnManager();
        virtualCountHolder = new TimeLimitedCache(DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS), null, 2, null);
        rabbitCrashedPattern$delegate = CFApi.INSTANCE.getPatternGroup().pattern("rabbit.crushed", "\u00a7c\u00a7lBARN FULL! \u00a7f\\D+ \u00a77got \u00a7ccrushed\u00a77! \u00a76\\+(?<amount>[\\d,]+) Chocolate");
        lastRabbit = "";
    }
}

