package at.hannibal2.skyhanni.data

import at.hannibal2.skyhanni.api.event.HandleEvent
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent
import at.hannibal2.skyhanni.events.player.PlayerDeathEvent
import at.hannibal2.skyhanni.skyhannimodule.SkyHanniModule
import at.hannibal2.skyhanni.utils.RegexUtils.matchMatcher
import at.hannibal2.skyhanni.utils.StringUtils.removeColor
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern

@SkyHanniModule
object PlayerDeathManager {

    /**
     * REGEX-TEST: §c ☠ §r§7§r§bZeroHazel§r§7 was killed by §r§8§lAshfang§r§7§r§7.
     */
    private val deathMessagePattern by RepoPattern.pattern(
        "chat.player.death",
        "§c ☠ §r§7§r§.(?<name>.+)§r§7 (?<reason>.+)",
    )

    private val selfDeathMessagePattern by RepoPattern.pattern(
        "chat.player.selfdeath",
        "§c ☠ §r§7You (?<reason>.+)",
    )

    @HandleEvent
    fun onChat(event: SkyHanniChatEvent) {
        val message = event.message
        deathMessagePattern.matchMatcher(message) {
            val name = group("name")
            val reason = group("reason").removeColor()
            PlayerDeathEvent(name, reason, event).post()
        }
        selfDeathMessagePattern.matchMatcher(message) {
            val reason = group("reason").removeColor()
            PlayerDeathEvent(reason, event).post()
        }
    }
}
