package at.hannibal2.skyhanni.mixins.transformers;

import at.hannibal2.skyhanni.events.minecraft.packet.PacketReceivedEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketSentEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
//#if MC < 1.21.6
//$$ import net.minecraft.network.PacketCallbacks;
//#else
import io.netty.channel.ChannelFutureListener;
//#endif
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2596;

@Mixin(class_2535.class)
public class MixinClientConnection {

    @Inject(method = "handlePacket", at = @At(value = "HEAD"), cancellable = true)
    private static void handlePacket$Inject$HEAD(class_2596<?> packet, class_2547 listener, CallbackInfo ci) {
        if (new PacketReceivedEvent(packet).post()) {
            ci.cancel();
        }
    }

    //#if MC < 1.21.6
    //$$ @Inject(method = "send(Lnet/minecraft/network/packet/Packet;Lnet/minecraft/network/PacketCallbacks;Z)V", at = @At(value = "HEAD"), cancellable = true)
    //$$ private void sendPacketNew(Packet<?> packet, PacketCallbacks callbacks, boolean flush, CallbackInfo ci) {
        //#else
        @Inject(method = "send(Lnet/minecraft/network/packet/Packet;Lio/netty/channel/ChannelFutureListener;Z)V", at = @At(value = "HEAD"), cancellable = true)
        private void sendPacketNew(class_2596<?> packet, ChannelFutureListener channelFutureListener, boolean flush, CallbackInfo ci) {
        //#endif
        if (new PacketSentEvent(packet).post()) {
            ci.cancel();
        }
    }
}
