package at.hannibal2.skyhanni.mixins.transformers.renderer;

import at.hannibal2.skyhanni.data.entity.EntityOpacityManager;
import at.hannibal2.skyhanni.mixins.hooks.EntityRenderDispatcherHookKt;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_4722;
import net.minecraft.class_918;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(class_918.class)
public class MixinItemRenderer {

    @ModifyArg(method = "renderBakedItemQuads", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/VertexConsumer;quad(Lnet/minecraft/client/util/math/MatrixStack$Entry;Lnet/minecraft/client/render/model/BakedQuad;FFFFII)V"), index = 5)
    private static float modifyAlpha(float originalAlpha) {
        if (EntityRenderDispatcherHookKt.getEntity() instanceof class_1309 livingEntity) {
            Integer entityAlpha = EntityOpacityManager.getEntityOpacity(livingEntity);
            if (entityAlpha == null) return originalAlpha;
            float alphaFloat = entityAlpha / 255.0F;

            return Math.min(originalAlpha, alphaFloat);
        }
        return originalAlpha;
    }

    @ModifyArg(method = "renderItem(Lnet/minecraft/item/ItemDisplayContext;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;II[ILjava/util/List;Lnet/minecraft/client/render/RenderLayer;Lnet/minecraft/client/render/item/ItemRenderState$Glint;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/item/ItemRenderer;getItemGlintConsumer(Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/client/render/RenderLayer;ZZ)Lnet/minecraft/client/render/VertexConsumer;"), index = 1)
    private static class_1921 modifyRenderLayer(class_1921 layer) {
        if (EntityRenderDispatcherHookKt.getEntity() instanceof class_1309 livingEntity) {
            if (EntityOpacityManager.getEntityOpacity(livingEntity) == null) return layer;
            return class_4722.method_29382();
        }
        return layer;
    }
}
