/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.InventoryUpdatedEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketReceivedEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketSentEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.compat.InventoryCompat;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2645;
import net.minecraft.class_2653;
import net.minecraft.class_2815;
import net.minecraft.class_3917;
import net.minecraft.class_3944;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001+B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0003J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0011\u0010#\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"RH\u0010)\u001a6\u0012,\u0012*\u0012\u000e\b\u0001\u0012\n '*\u0004\u0018\u00010&0& '*\u0014\u0012\u000e\b\u0001\u0012\n '*\u0004\u0018\u00010&0&\u0018\u00010%0%\u0012\u0004\u0012\u00020(0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006,"}, d2={"Lat/hannibal2/skyhanni/data/OtherInventoryData;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$CloseWindowEvent;", "event", "", "onCloseWindow", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$CloseWindowEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketSentEvent;", "onPacketSent", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketSentEvent;)V", "", "title", "", "reopenSameName", "close", "(Ljava/lang/String;Z)V", "onTick", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;", "onInventoryDataReceiveEvent", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;)V", "Lat/hannibal2/skyhanni/data/OtherInventoryData$Inventory;", "inventory", "done", "(Lat/hannibal2/skyhanni/data/OtherInventoryData$Inventory;)V", "currentInventory", "Lat/hannibal2/skyhanni/data/OtherInventoryData$Inventory;", "acceptItems", "Z", "Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;", "lateEvent", "Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;", "getCurrentInventoryName", "()Ljava/lang/String;", "currentInventoryName", "", "Lnet/minecraft/class_3917;", "Lnet/minecraft/class_1703;", "kotlin.jvm.PlatformType", "", "slotCountMap", "Ljava/util/Map;", "Inventory", "1.21.10"})
public final class OtherInventoryData {
    @NotNull
    public static final OtherInventoryData INSTANCE = new OtherInventoryData();
    @Nullable
    private static Inventory currentInventory;
    private static boolean acceptItems;
    @Nullable
    private static InventoryUpdatedEvent lateEvent;
    @NotNull
    private static final Map<class_3917<? extends class_1703>, Integer> slotCountMap;

    private OtherInventoryData() {
    }

    @NotNull
    public final String getCurrentInventoryName() {
        Inventory inventory = currentInventory;
        String string = inventory != null ? inventory.getTitle() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @HandleEvent
    public final void onCloseWindow(@NotNull GuiContainerEvent.CloseWindowEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        OtherInventoryData.close$default(this, null, false, 3, null);
    }

    @HandleEvent
    public final void onPacketSent(@NotNull PacketSentEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getPacket() instanceof class_2815) {
            OtherInventoryData.close$default(this, null, false, 3, null);
        }
    }

    public final void close(@NotNull String title, boolean reopenSameName) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        new InventoryCloseEvent(title, reopenSameName).post();
        currentInventory = null;
    }

    public static /* synthetic */ void close$default(OtherInventoryData otherInventoryData, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = otherInventoryData.getCurrentInventoryName();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        otherInventoryData.close(string, bl);
    }

    @HandleEvent
    public final void onTick() {
        block0: {
            InventoryUpdatedEvent inventoryUpdatedEvent = lateEvent;
            if (inventoryUpdatedEvent == null) break block0;
            InventoryUpdatedEvent it = inventoryUpdatedEvent;
            boolean bl = false;
            it.post();
            lateEvent = null;
        }
    }

    @HandleEvent
    public final void onInventoryDataReceiveEvent(@NotNull PacketReceivedEvent event2) {
        block13: {
            Inventory it;
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            class_2596<?> packet = event2.getPacket();
            if (packet instanceof class_2645) {
                OtherInventoryData.close$default(this, null, false, 3, null);
            }
            if (packet instanceof class_3944) {
                class_2561 class_25612 = ((class_3944)packet).method_17594();
                Intrinsics.checkNotNullExpressionValue((Object)class_25612, (String)"getName(...)");
                String title = TextCompatKt.unformattedTextCompat(class_25612);
                int windowId = ((class_3944)packet).method_17592();
                class_3917 handlerType = ((class_3944)packet).method_17593();
                Integer n = slotCountMap.get(handlerType);
                if (n == null) {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"screenName", (Object)title)};
                    ErrorManager.INSTANCE.skyHanniError("Unknown screen handler type!", pairArray);
                    throw new KotlinNothingValueException();
                }
                int slotCount = n;
                Inventory inventory = currentInventory;
                OtherInventoryData.close$default(this, null, Intrinsics.areEqual((Object)title, (Object)(inventory != null ? inventory.getTitle() : null)), 1, null);
                currentInventory = new Inventory(windowId, title, slotCount, null, false, 24, null);
                acceptItems = true;
            }
            if (!(packet instanceof class_2653)) break block13;
            if (!acceptItems) {
                Inventory inventory = currentInventory;
                if (inventory != null) {
                    class_1799 itemStack;
                    it = inventory;
                    boolean bl = false;
                    if (it.getWindowId() != ((class_2653)packet).method_11452()) {
                        return;
                    }
                    int slot = ((class_2653)packet).method_11450();
                    if (slot < it.getSlotCount() && InventoryCompat.INSTANCE.isNotEmpty(itemStack = ((class_2653)packet).method_11449())) {
                        Integer n = slot;
                        it.getItems().put(n, itemStack);
                        lateEvent = new InventoryUpdatedEvent(it);
                    }
                }
                return;
            }
            Inventory inventory = currentInventory;
            if (inventory != null) {
                it = inventory;
                boolean bl = false;
                if (it.getWindowId() != ((class_2653)packet).method_11452()) {
                    return;
                }
                int slot = ((class_2653)packet).method_11450();
                if (slot < it.getSlotCount()) {
                    class_1799 itemStack = ((class_2653)packet).method_11449();
                    if (InventoryCompat.INSTANCE.isNotEmpty(itemStack)) {
                        Integer n = slot;
                        it.getItems().put(n, itemStack);
                    }
                } else {
                    INSTANCE.done(it);
                    return;
                }
                if (it.getItems().size() == it.getSlotCount()) {
                    INSTANCE.done(it);
                }
            }
        }
    }

    private final void done(Inventory inventory) {
        new InventoryFullyOpenedEvent(inventory).post();
        inventory.setFullyOpenedOnce(true);
        new InventoryUpdatedEvent(inventory).post();
        acceptItems = false;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)class_3917.field_17329, (Object)3), TuplesKt.to((Object)class_3917.field_17330, (Object)1), TuplesKt.to((Object)class_3917.field_17331, (Object)3), TuplesKt.to((Object)class_3917.field_17332, (Object)5), TuplesKt.to((Object)class_3917.field_17343, (Object)2), TuplesKt.to((Object)class_3917.field_17333, (Object)9), TuplesKt.to((Object)class_3917.field_17334, (Object)2), TuplesKt.to((Object)class_3917.field_17335, (Object)3), TuplesKt.to((Object)class_3917.field_17328, (Object)9), TuplesKt.to((Object)class_3917.field_18664, (Object)9), TuplesKt.to((Object)class_3917.field_18665, (Object)18), TuplesKt.to((Object)class_3917.field_17326, (Object)27), TuplesKt.to((Object)class_3917.field_18666, (Object)36), TuplesKt.to((Object)class_3917.field_18667, (Object)45), TuplesKt.to((Object)class_3917.field_17327, (Object)54), TuplesKt.to((Object)class_3917.field_17336, (Object)3), TuplesKt.to((Object)class_3917.field_17337, (Object)5), TuplesKt.to((Object)class_3917.field_17338, (Object)1), TuplesKt.to((Object)class_3917.field_17339, (Object)3), TuplesKt.to((Object)class_3917.field_17340, (Object)3), TuplesKt.to((Object)class_3917.field_17341, (Object)27), TuplesKt.to((Object)class_3917.field_22484, (Object)3), TuplesKt.to((Object)class_3917.field_17342, (Object)3), TuplesKt.to((Object)class_3917.field_17625, (Object)1)};
        slotCountMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000e\u001a\u0004\b\u0014\u0010\u0010R#\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lat/hannibal2/skyhanni/data/OtherInventoryData$Inventory;", "", "", "windowId", "", "title", "slotCount", "", "Lnet/minecraft/class_1799;", "items", "", "fullyOpenedOnce", "<init>", "(ILjava/lang/String;ILjava/util/Map;Z)V", "I", "getWindowId", "()I", "Ljava/lang/String;", "getTitle", "()Ljava/lang/String;", "getSlotCount", "Ljava/util/Map;", "getItems", "()Ljava/util/Map;", "Z", "getFullyOpenedOnce", "()Z", "setFullyOpenedOnce", "(Z)V", "1.21.10"})
    public static final class Inventory {
        private final int windowId;
        @NotNull
        private final String title;
        private final int slotCount;
        @NotNull
        private final Map<Integer, class_1799> items;
        private boolean fullyOpenedOnce;

        public Inventory(int windowId, @NotNull String title, int slotCount, @NotNull Map<Integer, class_1799> items, boolean fullyOpenedOnce) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.windowId = windowId;
            this.title = title;
            this.slotCount = slotCount;
            this.items = items;
            this.fullyOpenedOnce = fullyOpenedOnce;
        }

        public /* synthetic */ Inventory(int n, String string, int n2, Map map, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 8) != 0) {
                map = new LinkedHashMap();
            }
            if ((n3 & 0x10) != 0) {
                bl = false;
            }
            this(n, string, n2, map, bl);
        }

        public final int getWindowId() {
            return this.windowId;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        public final int getSlotCount() {
            return this.slotCount;
        }

        @NotNull
        public final Map<Integer, class_1799> getItems() {
            return this.items;
        }

        public final boolean getFullyOpenedOnce() {
            return this.fullyOpenedOnce;
        }

        public final void setFullyOpenedOnce(boolean bl) {
            this.fullyOpenedOnce = bl;
        }
    }
}

