/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui;

import at.hannibal2.skyhanni.deps.moulconfig.Config;
import at.hannibal2.skyhanni.deps.moulconfig.GuiTextures;
import at.hannibal2.skyhanni.deps.moulconfig.Social;
import at.hannibal2.skyhanni.deps.moulconfig.common.IFontRenderer;
import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.common.Layer;
import at.hannibal2.skyhanni.deps.moulconfig.common.RenderContext;
import at.hannibal2.skyhanni.deps.moulconfig.common.text.StructuredText;
import at.hannibal2.skyhanni.deps.moulconfig.gui.ClassResizableTextField;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiElement;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiOptionEditor;
import at.hannibal2.skyhanni.deps.moulconfig.gui.HorizontalAlign;
import at.hannibal2.skyhanni.deps.moulconfig.gui.KeyboardEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.SearchFunction;
import at.hannibal2.skyhanni.deps.moulconfig.gui.component.MetaComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.editors.GuiOptionEditorAccordion;
import at.hannibal2.skyhanni.deps.moulconfig.internal.ContextAware;
import at.hannibal2.skyhanni.deps.moulconfig.internal.InitUtil;
import at.hannibal2.skyhanni.deps.moulconfig.internal.LerpUtils;
import at.hannibal2.skyhanni.deps.moulconfig.internal.LerpingInteger;
import at.hannibal2.skyhanni.deps.moulconfig.observer.GetSetter;
import at.hannibal2.skyhanni.deps.moulconfig.processor.MoulConfigProcessor;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedCategory;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedOption;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class MoulConfigEditor<T extends Config>
extends GuiElement {
    private final long openedMillis;
    private final LerpingInteger optionsScroll = new LerpingInteger(0, 150);
    private final LerpingInteger categoryScroll = new LerpingInteger(0, 150);
    private final LerpingInteger minimumSearchSize = new LerpingInteger(0, 150);
    private final GetSetter<String> searchFieldContent = GetSetter.floating("");
    private final ClassResizableTextField searchField = new ClassResizableTextField(this.searchFieldContent);
    private String selectedCategory = null;
    private float optionsBarStart;
    private float optionsBarend;
    private int lastMouseX = 0;
    private int keyboardScrollXCutoff = 0;
    private boolean showSubcategories = true;
    private SearchFunction searchFunction = GuiOptionEditor::fulfillsSearch;
    public Boolean wide = false;
    private LinkedHashMap<String, ? extends ProcessedCategory> currentlyVisibleCategories;
    private Set<ProcessedOption> currentlyVisibleOptions;
    private Map<String, Set<String>> childCategoryLookup = new HashMap<String, Set<String>>();
    private List<ProcessedOption> allOptions = new ArrayList<ProcessedOption>();
    private final @Unmodifiable LinkedHashMap<String, ? extends ProcessedCategory> allCategories;
    private final @Unmodifiable T configObject;
    private Map<Field, ProcessedOption> optionLookup = new HashMap<Field, ProcessedOption>();
    private GuiContext guiContext = new GuiContext(new MetaComponent());

    public MoulConfigEditor(MoulConfigProcessor<T> processedConfig) {
        this(InitUtil.run(processedConfig.getAllCategories(), processedConfig::requireFinalized), processedConfig.getConfigObject());
    }

    public MoulConfigEditor(@Unmodifiable LinkedHashMap<String, ? extends ProcessedCategory> allCategories, T configObject) {
        this.openedMillis = System.currentTimeMillis();
        this.allCategories = allCategories;
        this.configObject = configObject;
        for (Map.Entry<String, ? extends ProcessedCategory> category : allCategories.entrySet()) {
            this.allOptions.addAll(category.getValue().getOptions());
            if (category.getValue().getParentCategoryId() == null) continue;
            this.childCategoryLookup.computeIfAbsent(category.getValue().getParentCategoryId(), ignored -> new HashSet()).add(category.getKey());
        }
        for (ProcessedOption option : this.allOptions) {
            option.getEditor().activeConfigGUI = this;
            if (!(option instanceof ProcessedOption.HasField)) continue;
            this.optionLookup.put(((ProcessedOption.HasField)((Object)option)).getField(), option);
        }
        this.updateSearchResults();
        this.searchField.setContext(this.guiContext);
    }

    private List<ProcessedOption> getOptionsInCategory(ProcessedCategory cat) {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>(cat.getOptions());
        options.removeIf(it -> !this.currentlyVisibleOptions.contains(it));
        return options;
    }

    @Nullable
    public ProcessedOption getOptionFromField(Field field) {
        return this.optionLookup.get(field);
    }

    public boolean scrollOptionIntoView(ProcessedOption searchedOption, int timeToReachTargetMs) {
        ProcessedCategory processedCategory = this.getCurrentlySearchedCategories().get(this.getSelectedCategory());
        if (processedCategory != searchedOption.getCategory()) {
            return false;
        }
        ProcessedOption accordionP = searchedOption;
        while (accordionP.getAccordionId() >= 0) {
            accordionP = processedCategory.getAccordionAnchors().get(accordionP.getAccordionId());
            ((GuiOptionEditorAccordion)accordionP.getEditor()).setToggled(true);
        }
        if (searchedOption.getEditor() instanceof GuiOptionEditorAccordion) {
            ((GuiOptionEditorAccordion)searchedOption.getEditor()).setToggled(true);
        }
        HashSet<Integer> activeAccordions = new HashSet<Integer>();
        int optionY = 0;
        for (ProcessedOption processedOption : this.getOptionsInCategory(processedCategory)) {
            GuiOptionEditorAccordion accordion;
            GuiOptionEditor editor = processedOption.getEditor();
            if (editor == null || processedOption.getAccordionId() >= 0 && !activeAccordions.contains(processedOption.getAccordionId())) continue;
            if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                activeAccordions.add(accordion.getAccordionId());
            }
            if (processedOption == searchedOption) {
                this.optionsScroll.setTimeToReachTarget(timeToReachTargetMs);
                this.optionsScroll.resetTimer();
                this.optionsScroll.setTarget(optionY);
                return true;
            }
            optionY += ContextAware.wrapErrorWithContext(editor, editor::getHeight) + 5;
        }
        return false;
    }

    public boolean setSelectedCategory(ProcessedCategory category) {
        if (!this.getCurrentlySearchedCategories().containsKey(category.getIdentifier())) {
            return false;
        }
        this.setSelectedCategory(category.getIdentifier());
        return true;
    }

    private void setSelectedCategory(String category) {
        this.selectedCategory = category;
        this.optionsScroll.setValue(0);
    }

    public void search(String searchText) {
        this.searchFieldContent.set(searchText);
        this.updateSearchResults();
    }

    private void propagateSearchinessForAccordions(Set<ProcessedOption> options, Set<ProcessedOption> lastRound, boolean upwards) {
        if (lastRound.isEmpty()) {
            return;
        }
        options.addAll(lastRound);
        HashSet<ProcessedOption> nextRound = new HashSet<ProcessedOption>();
        for (ProcessedOption option : lastRound) {
            if (option.getAccordionId() >= 0 && upwards) {
                for (ProcessedOption processedOption : option.getCategory().getOptions()) {
                    if (processedOption == option || !(processedOption.getEditor() instanceof GuiOptionEditorAccordion) || ((GuiOptionEditorAccordion)processedOption.getEditor()).getAccordionId() != option.getAccordionId()) continue;
                    nextRound.add(processedOption);
                }
            }
            if (!(option.getEditor() instanceof GuiOptionEditorAccordion) || upwards) continue;
            int parentId = ((GuiOptionEditorAccordion)option.getEditor()).getAccordionId();
            for (ProcessedOption processedOption : option.getCategory().getOptions()) {
                if (processedOption.getAccordionId() != parentId) continue;
                nextRound.add(processedOption);
            }
        }
        nextRound.removeAll(options);
        this.propagateSearchinessForAccordions(options, nextRound, upwards);
    }

    public void updateSearchResults() {
        this.updateSearchResults(false);
    }

    public void updateSearchResults(boolean recalculateOptionUniverse) {
        String toSearch;
        this.showSubcategories = true;
        if (recalculateOptionUniverse) {
            this.allOptions.clear();
            for (ProcessedCategory category : this.getAllCategories().values()) {
                this.allOptions.addAll(category.getOptions());
            }
        }
        if (!(toSearch = this.searchFieldContent.get().trim().toLowerCase(Locale.ROOT)).isEmpty()) {
            HashSet<ProcessedOption> matchingOptions = new HashSet<ProcessedOption>(this.allOptions);
            for (String word : toSearch.split(" +")) {
                matchingOptions.removeIf(it -> ContextAware.wrapErrorWithContext(it.getEditor(), () -> !this.searchFunction.fulfillsSearch(it.getEditor(), word)));
            }
            HashSet<ProcessedCategory> directlyMatchedCategories = new HashSet<ProcessedCategory>(this.getAllCategories().values());
            if (!((Config)this.getConfigObject()).shouldSearchCategoryNames()) {
                directlyMatchedCategories.clear();
            }
            for (String word : toSearch.split(" +")) {
                directlyMatchedCategories.removeIf(it -> ContextAware.wrapErrorWithContext(it, () -> !it.getDisplayName().getText().toLowerCase(Locale.ROOT).contains(word) && !it.getDescription().getText().toLowerCase(Locale.ROOT).contains(word)));
            }
            HashSet<ProcessedOption> matchingOptionsAndDependencies = new HashSet<ProcessedOption>();
            List childCategoriesOfDirectlyMatched = directlyMatchedCategories.stream().flatMap(it -> this.childCategoryLookup.getOrDefault(it.getIdentifier(), Collections.emptySet()).stream()).map(this.getAllCategories()::get).filter(Objects::nonNull).collect(Collectors.toList());
            directlyMatchedCategories.addAll(childCategoriesOfDirectlyMatched);
            for (ProcessedCategory directCategory : directlyMatchedCategories) {
                matchingOptionsAndDependencies.addAll(directCategory.getOptions());
                directCategory.getOptions().forEach(matchingOptions::remove);
            }
            this.propagateSearchinessForAccordions(matchingOptionsAndDependencies, matchingOptions, true);
            this.propagateSearchinessForAccordions(matchingOptionsAndDependencies, matchingOptions, false);
            this.currentlyVisibleOptions = matchingOptionsAndDependencies;
            Set visibleCategories = matchingOptionsAndDependencies.stream().map(ProcessedOption::getCategory).collect(Collectors.toSet());
            Set parentCategories = visibleCategories.stream().filter(it -> it.getParentCategoryId() != null).map(it -> this.getAllCategories().get(it.getParentCategoryId())).filter(Objects::nonNull).collect(Collectors.toSet());
            visibleCategories.addAll(parentCategories);
            LinkedHashMap<String, ProcessedCategory> matchingCategories = new LinkedHashMap<String, ProcessedCategory>(this.getAllCategories());
            matchingCategories.entrySet().removeIf(stringProcessedCategoryEntry -> !visibleCategories.contains(stringProcessedCategoryEntry.getValue()));
            this.currentlyVisibleCategories = matchingCategories;
        } else {
            this.currentlyVisibleCategories = this.getAllCategories();
            this.currentlyVisibleOptions = new HashSet<ProcessedOption>(this.allOptions);
        }
    }

    public LinkedHashMap<String, ProcessedCategory> getCurrentlyVisibleCategories() {
        LinkedHashMap<String, ProcessedCategory> newHashes = new LinkedHashMap<String, ProcessedCategory>(this.currentlyVisibleCategories);
        newHashes.entrySet().removeIf(it -> {
            if (((ProcessedCategory)it.getValue()).getParentCategoryId() == null) {
                return false;
            }
            if (!this.showSubcategories) {
                return true;
            }
            if (((ProcessedCategory)it.getValue()).getParentCategoryId().equals(this.getSelectedCategory())) {
                return false;
            }
            ProcessedCategory processedCategory = this.currentlyVisibleCategories.get(this.getSelectedCategory());
            if (processedCategory == null) {
                return true;
            }
            return !((ProcessedCategory)it.getValue()).getParentCategoryId().equals(processedCategory.getParentCategoryId());
        });
        return newHashes;
    }

    public LinkedHashMap<String, ? extends ProcessedCategory> getCurrentlySearchedCategories() {
        return this.currentlyVisibleCategories;
    }

    @Override
    public void render() {
        int finalOptionWidth;
        int finalY;
        int finalX;
        int optionHeight;
        int accordionDepth;
        int accordionDepth2;
        int optionWidth;
        boolean shouldShow;
        int xSize;
        this.optionsScroll.tick();
        this.categoryScroll.tick();
        this.handleKeyboardPresses();
        List<StructuredText> tooltipToDisplay = null;
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.openedMillis;
        IMinecraft iMinecraft = IMinecraft.INSTANCE;
        RenderContext context2 = IMinecraft.INSTANCE.provideTopLevelRenderContext();
        int width = iMinecraft.getScaledWidth();
        int height = iMinecraft.getScaledHeight();
        int scaleFactor = iMinecraft.getScaleFactor();
        int mouseX = iMinecraft.getMouseX();
        int mouseY = iMinecraft.getMouseY();
        int baseXSize = Math.min(width - 100 / scaleFactor, 500);
        if (this.wide.booleanValue()) {
            int raw = (int)Math.floor((float)baseXSize * 1.5f);
            xSize = Math.min(raw, width - 100 / scaleFactor);
        } else {
            xSize = baseXSize;
        }
        int ySize = Math.min(height - 100 / scaleFactor, 400);
        float leftPanelScalar = 1.0f;
        if (this.wide.booleanValue()) {
            leftPanelScalar = 1.25f;
        }
        int leftPanelWidth = (int)(140.0f * leftPanelScalar);
        int x = (width - xSize) / 2;
        int y = (height - ySize) / 2;
        int adjScaleFactor = Math.max(2, scaleFactor);
        float opacityFactor = LerpUtils.sigmoidZeroOne((float)delta / 500.0f);
        context2.drawGradientRect(0, 0, width, height, (int)(128.0f * opacityFactor) << 24 | 0x101010, (int)(144.0f * opacityFactor) << 24 | 0x101010);
        int openingXSize = xSize;
        int openingYSize = ySize;
        if (delta < 150L) {
            openingXSize = (int)(delta * (long)xSize / 150L);
            openingYSize = 5;
        } else if (delta < 300L) {
            openingYSize = 5 + (int)(delta - 150L) * (ySize - 5) / 150;
        }
        context2.drawDarkRect((width - openingXSize) / 2, (height - openingYSize) / 2, openingXSize, openingYSize);
        context2.assertNoScissors();
        context2.pushScissor((width - openingXSize) / 2, (height - openingYSize) / 2, (width + openingXSize) / 2, (height + openingYSize) / 2);
        context2.drawDarkRect(x + 4, y + 5, xSize - 9, 20, false);
        IFontRenderer ifr = iMinecraft.getDefaultFontRenderer();
        context2.drawStringCenteredScaledMaxWidth(((Config)this.getConfigObject()).getTitle(), ifr, (float)x + (float)xSize / 2.0f, y + 15, false, xSize - ((Config)this.getConfigObject()).getSocials().size() * 18 * 2 - 25, 0xA0A0A0);
        context2.drawDarkRect(x + 4, y + 49 - 20, leftPanelWidth, ySize - 54 + 20, false);
        int innerPadding = 20 / adjScaleFactor;
        int innerLeft = x + 4 + innerPadding;
        int innerRight = x + (leftPanelWidth + 4) - innerPadding;
        int innerTop = y + 49 + innerPadding;
        int innerBottom = y + ySize - 5 - innerPadding;
        int catInnerW = innerRight - innerLeft;
        int catCenterX = innerLeft + catInnerW / 2;
        context2.drawColoredRect(innerLeft, innerTop, innerLeft + 1, innerBottom, -16250866);
        context2.drawColoredRect(innerLeft + 1, innerTop, innerRight, innerTop + 1, -16250866);
        context2.drawColoredRect(innerRight - 1, innerTop + 1, innerRight, innerBottom, -14145490);
        context2.drawColoredRect(innerLeft + 1, innerBottom - 1, innerRight - 1, innerBottom, -14145490);
        context2.drawColoredRect(innerLeft + 1, innerTop + 1, innerRight - 1, innerBottom - 1, 1611139086);
        context2.pushScissor(0, innerTop + 1, width, innerBottom - 1);
        float catBarSize = 1.0f;
        int catY = -this.categoryScroll.getValue();
        LinkedHashMap<String, ProcessedCategory> currentConfigEditing = this.getCurrentlyVisibleCategories();
        for (Map.Entry<String, ProcessedCategory> entry : currentConfigEditing.entrySet()) {
            String selectedCategory = this.getSelectedCategory();
            if (selectedCategory == null || !currentConfigEditing.containsKey(selectedCategory)) {
                this.setSelectedCategory(entry.getKey());
            }
            boolean isSelected = entry.getKey().equals(this.getSelectedCategory());
            Set<String> childCategories = this.childCategoryLookup.get(entry.getKey());
            StructuredText catName = ((Config)this.getConfigObject()).formatCategoryName(entry.getValue(), isSelected);
            HorizontalAlign align = ((Config)this.getConfigObject()).alignCategory(entry.getValue(), isSelected);
            int textLength = ifr.getStringWidth(catName);
            boolean isIndented = childCategories != null || entry.getValue().getParentCategoryId() != null;
            int maxTextLength = (int)((float)(isIndented ? 90 : 100) * leftPanelScalar);
            int centerMark = x + (int)(75.0f * leftPanelScalar);
            if (textLength > maxTextLength) {
                context2.drawStringCenteredScaledMaxWidth(catName, ifr, centerMark + (isIndented ? 5 : 0), y + 70 + catY, false, maxTextLength, -1);
            } else if (align == HorizontalAlign.CENTER) {
                context2.drawStringCenteredScaledMaxWidth(catName, ifr, centerMark, y + 70 + catY, false, maxTextLength, -1);
            } else if (align == HorizontalAlign.RIGHT) {
                context2.drawString(ifr, catName, centerMark + 50 - textLength, y + 70 + catY - ifr.getHeight() / 2, -1, false);
            } else {
                context2.drawString(ifr, catName, centerMark - 50 + (isIndented ? 10 : 0), y + 70 + catY - ifr.getHeight() / 2, -1, false);
            }
            if (childCategories != null) {
                boolean isExpanded = this.showSubcategories && (isSelected || childCategories.contains(this.getSelectedCategory()));
                context2.drawOpenCloseTriangle(isExpanded, (float)x + 24.5f, y + 67 + catY, 6.0f, 6.0f, -1);
                if (isExpanded) {
                    context2.drawVerticalLine(x + 27, y + catY + 76, y + catY + 76 + (int)childCategories.stream().filter(currentConfigEditing::containsKey).count() * 15, -12303292);
                }
            }
            if ((catY += 15) <= 0) continue;
            catBarSize = LerpUtils.clampZeroOne((float)(innerBottom - innerTop - 2) / (float)(catY + 5 + this.categoryScroll.getValue()));
        }
        float catBarStart = (float)this.categoryScroll.getValue() / (float)(catY + this.categoryScroll.getValue());
        float catBarEnd = catBarStart + catBarSize;
        if (catBarEnd > 1.0f) {
            catBarEnd = 1.0f;
            if ((float)this.categoryScroll.getTarget() / (float)(catY + this.categoryScroll.getValue()) + catBarSize < 1.0f) {
                int target = this.optionsScroll.getTarget();
                this.categoryScroll.setValue((int)Math.ceil((float)(catY + 5 + this.categoryScroll.getValue()) - catBarSize * (float)(catY + 5 + this.categoryScroll.getValue())));
                this.categoryScroll.setTarget(target);
            } else {
                this.categoryScroll.setValue((int)Math.ceil((float)(catY + 5 + this.categoryScroll.getValue()) - catBarSize * (float)(catY + 5 + this.categoryScroll.getValue())));
            }
        }
        int catDist = innerBottom - innerTop - 12;
        context2.drawColoredRect(innerLeft + 2, innerTop + 5, innerLeft + 7, innerBottom - 5, -15724528);
        context2.drawColoredRect(innerLeft + 3, innerTop + 6 + (int)((float)catDist * catBarStart), innerLeft + 6, innerTop + 6 + (int)((float)catDist * catBarEnd), -13619152);
        context2.popScissor();
        context2.drawStringCenteredScaledMaxWidth(StructuredText.of("Categories"), ifr, (float)(x + 4) + (float)leftPanelWidth / 2.0f, y + 44, false, 120, 10709231);
        context2.drawDarkRect(x + (leftPanelWidth + 9), y + 29, xSize - (leftPanelWidth + 14), ySize - 34, false);
        innerLeft = x + (leftPanelWidth + 9) + innerPadding;
        innerRight = x + xSize - 5 - innerPadding;
        innerBottom = y + ySize - 5 - innerPadding;
        context2.drawTexturedRect(GuiTextures.SEARCH, innerRight - 20, innerTop - (20 + innerPadding) / 2 - 9, 18.0f, 18.0f);
        this.minimumSearchSize.tick();
        boolean bl = shouldShow = !this.searchFieldContent.get().trim().isEmpty() || this.searchField.isFocused();
        if (shouldShow && this.minimumSearchSize.getTarget() < 30) {
            this.minimumSearchSize.setTarget(30);
            this.minimumSearchSize.resetTimer();
        } else if (!shouldShow && this.minimumSearchSize.getTarget() > 0) {
            this.minimumSearchSize.setTarget(0);
            this.minimumSearchSize.resetTimer();
        }
        int rightStuffLen = 20;
        if (this.minimumSearchSize.getValue() > 1) {
            int strLen = ifr.getStringWidth(this.searchFieldContent.get()) + 10;
            if (!shouldShow) {
                strLen = 0;
            }
            int len = Math.max(strLen, this.minimumSearchSize.getValue());
            this.searchField.setWidth(len);
            context2.pushMatrix();
            context2.translate(innerRight - 25 - len, innerTop - (20 + innerPadding) / 2 - 9);
            this.searchField.render(new GuiImmediateContext(context2, 0, 0, 0, 0, mouseX, mouseY, mouseX, mouseY, 0.0f, 0.0f).translated(innerRight - 25 - len, innerTop - (20 + innerPadding) / 2 - 9, 0, 0));
            context2.popMatrix();
            rightStuffLen += 5 + len;
        }
        if (this.getSelectedCategory() != null && currentConfigEditing.containsKey(this.getSelectedCategory())) {
            ProcessedCategory cat = currentConfigEditing.get(this.getSelectedCategory());
            context2.drawStringScaledMaxWidth(cat.getDescription(), ifr, innerLeft + 1, y + 40, true, innerRight - innerLeft - rightStuffLen - 10, 0xB0B0B0);
        }
        context2.drawColoredRect(innerLeft, innerTop, innerLeft + 1, innerBottom, -16250866);
        context2.drawColoredRect(innerLeft + 1, innerTop, innerRight, innerTop + 1, -16250866);
        context2.drawColoredRect(innerRight - 1, innerTop + 1, innerRight, innerBottom, -13619146);
        context2.drawColoredRect(innerLeft + 1, innerBottom - 1, innerRight - 1, innerBottom, -13619146);
        context2.drawColoredRect(innerLeft + 1, innerTop + 1, innerRight - 1, innerBottom - 1, 1611139086);
        context2.pushScissor(innerLeft + 1, innerTop + 1, innerRight - 1, innerBottom - 1);
        float barSize = 1.0f;
        int optionY = -this.optionsScroll.getValue();
        if (this.getSelectedCategory() != null && currentConfigEditing.containsKey(this.getSelectedCategory())) {
            ProcessedCategory cat = currentConfigEditing.get(this.getSelectedCategory());
            int optionWidthDefault = innerRight - innerLeft - 20;
            HashMap<Integer, Integer> activeAccordions = new HashMap<Integer, Integer>();
            List<ProcessedOption> options = this.getOptionsInCategory(cat);
            if (options.isEmpty()) {
                int titlePositionX = (innerLeft + innerRight) / 2;
                int titlePositionY = (innerTop + innerBottom) / 3;
                int innerSize = innerRight - innerLeft - 40;
                int titleScale = 2;
                context2.pushMatrix();
                context2.translate(titlePositionX, titlePositionY);
                context2.drawStringCenteredScaledMaxWidth(StructuredText.of("Seems like your search is found in a subcategory.").grey(), ifr, 0.0f, titleScale * ifr.getHeight(), true, innerSize, -1);
                context2.drawStringCenteredScaledMaxWidth(StructuredText.of("Check out the subcategories on the left.").grey(), ifr, 0.0f, (titleScale + 1) * ifr.getHeight(), true, innerSize, -1);
                context2.scale(titleScale, titleScale);
                context2.drawStringCenteredScaledMaxWidth(StructuredText.of("No options found.").grey(), ifr, 0.0f, 0.0f, true, innerSize / titleScale, -1);
                context2.popMatrix();
            }
            for (ProcessedOption option : options) {
                GuiOptionEditorAccordion accordion;
                GuiOptionEditor editor;
                optionWidth = optionWidthDefault;
                if (option.getAccordionId() >= 0) {
                    if (!activeAccordions.containsKey(option.getAccordionId())) continue;
                    accordionDepth2 = (Integer)activeAccordions.get(option.getAccordionId());
                    optionWidth = optionWidthDefault - 2 * innerPadding * (accordionDepth2 + 1);
                }
                if ((editor = option.getEditor()) == null) continue;
                editor.setGuiContext(this.guiContext);
                if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                    accordionDepth = 0;
                    if (option.getAccordionId() >= 0) {
                        accordionDepth = (Integer)activeAccordions.get(option.getAccordionId()) + 1;
                    }
                    activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                }
                optionHeight = ContextAware.wrapErrorWithContext(editor, editor::getHeight);
                if (innerTop + 5 + optionY + optionHeight > innerTop + 1 && innerTop + 5 + optionY < innerBottom - 1) {
                    finalX = (innerLeft + innerRight - optionWidth) / 2 - 5;
                    finalY = innerTop + 5 + optionY;
                    finalOptionWidth = optionWidth;
                    ContextAware.wrapErrorWithContext(editor, () -> {
                        editor.render(context2, finalX, finalY, finalOptionWidth);
                        return null;
                    });
                }
                optionY += optionHeight + 5;
            }
            if (optionY > 0) {
                barSize = LerpUtils.clampZeroOne((float)(innerBottom - innerTop - 2) / (float)(optionY + 5 + this.optionsScroll.getValue()));
            }
        }
        context2.popScissor();
        if (this.getSelectedCategory() != null && currentConfigEditing.containsKey(this.getSelectedCategory())) {
            int optionYOverlay = -this.optionsScroll.getValue();
            ProcessedCategory cat = currentConfigEditing.get(this.getSelectedCategory());
            int optionWidthDefault = innerRight - innerLeft - 20;
            context2.pushMatrix();
            HashMap<Integer, Integer> activeAccordions = new HashMap<Integer, Integer>();
            for (ProcessedOption option : this.getOptionsInCategory(cat)) {
                GuiOptionEditorAccordion accordion;
                GuiOptionEditor editor;
                optionWidth = optionWidthDefault;
                if (option.getAccordionId() >= 0) {
                    if (!activeAccordions.containsKey(option.getAccordionId())) continue;
                    accordionDepth2 = (Integer)activeAccordions.get(option.getAccordionId());
                    optionWidth = optionWidthDefault - 2 * innerPadding * (accordionDepth2 + 1);
                }
                if ((editor = option.getEditor()) == null) continue;
                editor.setGuiContext(this.guiContext);
                if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                    accordionDepth = 0;
                    if (option.getAccordionId() >= 0) {
                        accordionDepth = (Integer)activeAccordions.get(option.getAccordionId()) + 1;
                    }
                    activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                }
                optionHeight = ContextAware.wrapErrorWithContext(editor, editor::getHeight);
                if (innerTop + 5 + optionYOverlay + optionHeight > innerTop + 1 && innerTop + 5 + optionYOverlay < innerBottom - 1) {
                    finalX = (innerLeft + innerRight - optionWidth) / 2 - 5;
                    finalY = innerTop + 5 + optionYOverlay;
                    finalOptionWidth = optionWidth;
                    context2.drawOnTop(Layer.OVERLAY, RenderContext.ScissorBehaviour.ESCAPE, ctx -> ContextAware.wrapErrorWithContext(editor, () -> {
                        editor.renderOverlay((RenderContext)ctx, finalX, finalY, finalOptionWidth);
                        return null;
                    }));
                }
                optionYOverlay += optionHeight + 5;
            }
            context2.popMatrix();
        }
        this.optionsBarStart = (float)this.optionsScroll.getValue() / (float)(optionY + this.optionsScroll.getValue());
        this.optionsBarend = this.optionsBarStart + barSize;
        if (this.optionsBarend > 1.0f) {
            this.optionsBarend = 1.0f;
            if ((float)this.optionsScroll.getTarget() / (float)(optionY + this.optionsScroll.getValue()) + barSize < 1.0f) {
                int target = this.optionsScroll.getTarget();
                this.optionsScroll.setValue((int)Math.ceil((float)(optionY + 5 + this.optionsScroll.getValue()) - barSize * (float)(optionY + 5 + this.optionsScroll.getValue())));
                this.optionsScroll.setTarget(target);
            } else {
                this.optionsScroll.setValue((int)Math.ceil((float)(optionY + 5 + this.optionsScroll.getValue()) - barSize * (float)(optionY + 5 + this.optionsScroll.getValue())));
            }
        }
        int dist = innerBottom - innerTop - 12;
        context2.drawColoredRect(innerRight - 10, innerTop + 5, innerRight - 5, innerBottom - 5, -15724528);
        context2.drawColoredRect(innerRight - 9, innerTop + 6 + (int)((float)dist * this.optionsBarStart), innerRight - 6, innerTop + 6 + (int)((float)dist * this.optionsBarend), -13619152);
        List<Social> socials = ((Config)this.getConfigObject()).getSocials();
        for (int socialIndex = 0; socialIndex < socials.size(); ++socialIndex) {
            Social social = socials.get(socialIndex);
            int socialLeft = x + xSize - 23 - 18 * socialIndex;
            context2.drawTexturedRect(social.getIcon(), socialLeft, y + 7, 16.0f, 16.0f);
            if (mouseX < socialLeft || mouseX > socialLeft + 16 || mouseY < y + 6 || mouseY > y + 23) continue;
            tooltipToDisplay = social.getTooltip();
        }
        context2.popScissor();
        context2.assertNoScissors();
        if (tooltipToDisplay != null) {
            context2.scheduleDrawTooltip(iMinecraft.getMouseX(), iMinecraft.getMouseY(), tooltipToDisplay);
        }
        context2.renderExtraLayers();
    }

    @Override
    public boolean mouseInput(int mouseX, int mouseY, MouseEvent mouseEvent) {
        int accordionDepth;
        GuiOptionEditor editor;
        HashMap<Integer, Integer> activeAccordions;
        int dWheel;
        boolean mouseState;
        int xSize;
        this.lastMouseX = mouseX;
        IMinecraft iMinecraft = IMinecraft.INSTANCE;
        int width = iMinecraft.getScaledWidth();
        int height = iMinecraft.getScaledHeight();
        int scaleFactor = iMinecraft.getScaleFactor();
        int adjScaleFactor = Math.max(2, scaleFactor);
        int baseXSize = Math.min(width - 100 / scaleFactor, 500);
        if (this.wide.booleanValue()) {
            int raw = (int)Math.floor((float)baseXSize * 1.5f);
            xSize = Math.min(raw, width - 100 / scaleFactor);
        } else {
            xSize = baseXSize;
        }
        int ySize = Math.min(height - 100 / scaleFactor, 400);
        int x = (width - xSize) / 2;
        int y = (height - ySize) / 2;
        int innerPadding = 20 / adjScaleFactor;
        float leftPanelScalar = this.wide != false ? 1.25f : 1.0f;
        int leftPanelWidth = (int)(140.0f * leftPanelScalar);
        int catsInnerLeft = x + 4 + innerPadding;
        int optsInnerLeft = x + (leftPanelWidth + 9) + innerPadding;
        int optsInnerRight = x + xSize - 5 - innerPadding;
        int innerTop = y + 49 + innerPadding;
        int innerBottom = y + ySize - 5 - innerPadding;
        int dist = innerBottom - innerTop - 12;
        int optionsBarStartY = innerTop + 6 + (int)((float)dist * this.optionsBarStart);
        int optionsBarEndY = innerTop + 6 + (int)((float)dist * this.optionsBarend);
        int optionsBarStartX = optsInnerRight - 12;
        int optionsBarEndX = optsInnerRight - 3;
        int categoryY = -this.categoryScroll.getValue();
        int catDist = innerBottom - innerTop - 12;
        float catBarStart = (float)this.categoryScroll.getValue() / (float)((categoryY += 15 * this.getCurrentlyVisibleCategories().size()) + this.categoryScroll.getValue());
        float categoryBarSize = LerpUtils.clampZeroOne((float)(innerBottom - innerTop - 2) / (float)(categoryY + 5 + this.categoryScroll.getValue()));
        float catBarEnd = catBarStart + categoryBarSize;
        int categoryBarStartY = innerTop + 6 + (int)((float)catDist * catBarStart);
        int categoryBarEndY = innerTop + 6 + (int)((float)catDist * catBarEnd);
        int categoryBarStartX = catsInnerLeft + 3;
        int categoryBarEndX = catsInnerLeft + 8;
        this.keyboardScrollXCutoff = catsInnerLeft - 10;
        int mouseButton = mouseEvent instanceof MouseEvent.Click ? ((MouseEvent.Click)mouseEvent).getMouseButton() : -1;
        boolean bl = mouseState = mouseEvent instanceof MouseEvent.Click && ((MouseEvent.Click)mouseEvent).getMouseState();
        if (mouseState) {
            int strLen;
            int len;
            if ((mouseY < optionsBarStartY || mouseY > optionsBarEndY) && mouseX >= optionsBarStartX && mouseX <= optionsBarEndX && mouseY > innerTop + 6 && mouseY < innerBottom - 6) {
                this.optionsScroll.setTimeToReachTarget(200);
                this.optionsScroll.resetTimer();
                this.optionsScroll.setTarget(mouseY - innerTop);
                return true;
            }
            if ((mouseY < categoryBarStartY || mouseY > categoryBarEndY) && mouseX >= categoryBarStartX && mouseX <= categoryBarEndX && mouseY > innerTop + 6 && mouseY < innerBottom - 6) {
                this.categoryScroll.setTimeToReachTarget(200);
                this.categoryScroll.resetTimer();
                this.categoryScroll.setTarget(mouseY - innerTop);
                return true;
            }
            boolean searchIconFocus = mouseX >= optsInnerRight - 20 && mouseX <= optsInnerRight - 2 && mouseY >= innerTop - (20 + innerPadding) / 2 - 9 && mouseY <= innerTop - (20 + innerPadding) / 2 + 9;
            this.searchField.setFocus(searchIconFocus);
            if (searchIconFocus && mouseButton == 1) {
                this.searchField.getText().set("");
                this.updateSearchResults();
            }
            if (this.minimumSearchSize.getValue() > 1 && mouseX >= optsInnerRight - 25 - (len = Math.max(strLen = iMinecraft.getDefaultFontRenderer().getStringWidth(this.searchFieldContent.get()) + 10, this.minimumSearchSize.getValue())) && mouseX <= optsInnerRight - 25 && mouseY >= innerTop - (20 + innerPadding) / 2 - 9 && mouseY <= innerTop - (20 + innerPadding) / 2 + 9) {
                if (mouseButton == 1) {
                    this.searchField.getText().set("");
                    this.updateSearchResults();
                }
                String old = this.searchFieldContent.get();
                this.searchField.mouseEvent(mouseEvent, new GuiImmediateContext(iMinecraft.provideTopLevelRenderContext(), 0, 0, 0, 0, mouseX, mouseY, mouseX, mouseY, 0.0f, 0.0f).translated(optsInnerRight - 25 - len, innerTop - (20 + innerPadding) / 2 - 9, 0, 0));
                if (!this.searchFieldContent.get().equals(old)) {
                    this.updateSearchResults();
                }
            }
        }
        int n = dWheel = mouseEvent instanceof MouseEvent.Scroll ? (int)((MouseEvent.Scroll)mouseEvent).getDWheel() : 0;
        if (mouseY > innerTop && mouseY < innerBottom && dWheel != 0) {
            int barMax;
            int newTarget;
            if (dWheel < 0) {
                dWheel = -1;
            }
            if (dWheel > 0) {
                dWheel = 1;
            }
            if (mouseX < optsInnerLeft) {
                newTarget = this.categoryScroll.getTarget() - dWheel * 30;
                if (newTarget < 0) {
                    newTarget = 0;
                }
                float catBarSize = 1.0f;
                int catY = -newTarget;
                for (Map.Entry<String, ProcessedCategory> entry : this.getCurrentlyVisibleCategories().entrySet()) {
                    if (this.getSelectedCategory() == null) {
                        this.setSelectedCategory(entry.getKey());
                    }
                    if ((catY += 15) <= 0) continue;
                    catBarSize = LerpUtils.clampZeroOne((float)(innerBottom - innerTop - 2) / (float)(catY + 5 + newTarget));
                }
                barMax = (int)Math.floor((float)(catY + 5 + newTarget) - catBarSize * (float)(catY + 5 + newTarget));
                if (newTarget > barMax) {
                    newTarget = barMax;
                }
                this.categoryScroll.resetTimer();
                this.categoryScroll.setTarget(newTarget);
            } else {
                newTarget = this.optionsScroll.getTarget() - dWheel * 30;
                if (newTarget < 0) {
                    newTarget = 0;
                }
                float barSize = 1.0f;
                int optionY = -newTarget;
                if (this.getSelectedCategory() != null && this.getCurrentlyVisibleCategories() != null && this.getCurrentlyVisibleCategories().containsKey(this.getSelectedCategory())) {
                    ProcessedCategory cat = this.getCurrentlyVisibleCategories().get(this.getSelectedCategory());
                    activeAccordions = new HashMap<Integer, Integer>();
                    for (ProcessedOption option : this.getOptionsInCategory(cat)) {
                        GuiOptionEditorAccordion accordion;
                        if (option.getAccordionId() >= 0 && !activeAccordions.containsKey(option.getAccordionId()) || (editor = option.getEditor()) == null) continue;
                        ContextAware.wrapErrorWithContext(editor, () -> {
                            editor.setGuiContext(this.guiContext);
                            return null;
                        });
                        if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                            accordionDepth = 0;
                            if (option.getAccordionId() >= 0) {
                                accordionDepth = (Integer)activeAccordions.get(option.getAccordionId()) + 1;
                            }
                            activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                        }
                        if ((optionY += ContextAware.wrapErrorWithContext(editor, editor::getHeight) + 5) <= 0) continue;
                        barSize = LerpUtils.clampZeroOne((float)(innerBottom - innerTop - 2) / (float)(optionY + 5 + newTarget));
                    }
                }
                if (newTarget > (barMax = (int)Math.floor((float)(optionY + 5 + newTarget) - barSize * (float)(optionY + 5 + newTarget)))) {
                    newTarget = barMax;
                }
                this.optionsScroll.setTimeToReachTarget(Math.min(leftPanelWidth + 10, Math.max(10, 5 * Math.abs(newTarget - this.optionsScroll.getValue()))));
                this.optionsScroll.resetTimer();
                this.optionsScroll.setTarget(newTarget);
            }
        } else if (mouseState && ((MouseEvent.Click)mouseEvent).getMouseButton() == 0) {
            if (this.getCurrentlyVisibleCategories() != null) {
                int catY = -this.categoryScroll.getValue();
                for (Map.Entry<String, ProcessedCategory> entry : this.getCurrentlyVisibleCategories().entrySet()) {
                    if (this.getSelectedCategory() == null) {
                        this.setSelectedCategory(entry.getKey());
                    }
                    if (mouseX >= x + 5 && mouseX <= x + (leftPanelWidth + 5) && mouseY >= y + 70 + catY - 7 && mouseY <= y + 70 + catY + 7) {
                        if (entry.getKey().equals(this.getSelectedCategory())) {
                            if (entry.getValue().getParentCategoryId() == null) {
                                this.showSubcategories = !this.showSubcategories;
                            }
                        } else {
                            this.showSubcategories = true;
                            this.setSelectedCategory(entry.getKey());
                        }
                        return true;
                    }
                    catY += 15;
                }
            }
            List<Social> socials = ((Config)this.getConfigObject()).getSocials();
            for (int socialIndex = 0; socialIndex < socials.size(); ++socialIndex) {
                int socialLeft = x + xSize - 23 - 18 * socialIndex;
                if (mouseX < socialLeft || mouseX > socialLeft + 16 || mouseY < y + 6 || mouseY > y + 23) continue;
                socials.get(socialIndex).onClick();
                return true;
            }
        }
        int optionY = -this.optionsScroll.getValue();
        if (this.getSelectedCategory() != null && this.getCurrentlyVisibleCategories() != null && this.getCurrentlyVisibleCategories().containsKey(this.getSelectedCategory())) {
            int optionWidthDefault = optsInnerRight - optsInnerLeft - 20;
            ProcessedCategory cat = this.getCurrentlyVisibleCategories().get(this.getSelectedCategory());
            HashMap<Integer, Integer> activeAccordions2 = new HashMap<Integer, Integer>();
            for (ProcessedOption option : this.getOptionsInCategory(cat)) {
                int finalWidth;
                int finalY;
                int finalX;
                GuiOptionEditorAccordion accordion;
                int optionWidth = optionWidthDefault;
                if (option.getAccordionId() >= 0) {
                    if (!activeAccordions2.containsKey(option.getAccordionId())) continue;
                    int accordionDepth2 = (Integer)activeAccordions2.get(option.getAccordionId());
                    optionWidth = optionWidthDefault - 2 * innerPadding * (accordionDepth2 + 1);
                }
                if ((editor = option.getEditor()) == null) continue;
                editor.setGuiContext(this.guiContext);
                if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                    accordionDepth = 0;
                    if (option.getAccordionId() >= 0) {
                        accordionDepth = (Integer)activeAccordions2.get(option.getAccordionId()) + 1;
                    }
                    activeAccordions2.put(accordion.getAccordionId(), accordionDepth);
                }
                if (ContextAware.wrapErrorWithContext(editor, () -> MoulConfigEditor.lambda$mouseInput$15(editor, finalX = (optsInnerLeft + optsInnerRight - optionWidth) / 2 - 5, finalY = innerTop + 5 + optionY, finalWidth = optionWidth, mouseX, mouseY, mouseEvent)).booleanValue()) {
                    return true;
                }
                optionY += ContextAware.wrapErrorWithContext(editor, editor::getHeight) + 5;
            }
        }
        boolean handled = false;
        optionY = -this.optionsScroll.getValue();
        if (this.getSelectedCategory() != null && this.getCurrentlyVisibleCategories() != null && this.getCurrentlyVisibleCategories().containsKey(this.getSelectedCategory())) {
            int optionWidthDefault = optsInnerRight - optsInnerLeft - 20;
            ProcessedCategory cat = this.getCurrentlyVisibleCategories().get(this.getSelectedCategory());
            activeAccordions = new HashMap();
            for (ProcessedOption option : this.getOptionsInCategory(cat)) {
                int finalWidth;
                int finalY;
                int finalX;
                GuiOptionEditorAccordion accordion;
                GuiOptionEditor editor2;
                int optionWidth = optionWidthDefault;
                if (option.getAccordionId() >= 0) {
                    if (!activeAccordions.containsKey(option.getAccordionId())) continue;
                    int accordionDepth3 = (Integer)activeAccordions.get(option.getAccordionId());
                    optionWidth = optionWidthDefault - 2 * innerPadding * (accordionDepth3 + 1);
                }
                if ((editor2 = option.getEditor()) == null) continue;
                editor2.setGuiContext(this.guiContext);
                if (editor2 instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor2).getToggled()) {
                    int accordionDepth4 = 0;
                    if (option.getAccordionId() >= 0) {
                        accordionDepth4 = (Integer)activeAccordions.get(option.getAccordionId()) + 1;
                    }
                    activeAccordions.put(accordion.getAccordionId(), accordionDepth4);
                }
                if (ContextAware.wrapErrorWithContext(editor2, () -> MoulConfigEditor.lambda$mouseInput$16(editor2, finalX = (optsInnerLeft + optsInnerRight - optionWidth) / 2 - 5, finalY = innerTop + 5 + optionY, finalWidth = optionWidth, mouseX, mouseY, mouseEvent)).booleanValue()) {
                    handled = true;
                }
                optionY += ContextAware.wrapErrorWithContext(editor2, editor2::getHeight) + 5;
            }
        }
        return handled;
    }

    @Override
    public boolean keyboardInput(KeyboardEvent event2) {
        int xSize;
        IMinecraft iMinecraft = IMinecraft.INSTANCE;
        int width = iMinecraft.getScaledWidth();
        int height = iMinecraft.getScaledHeight();
        int scaleFactor = iMinecraft.getScaleFactor();
        int baseXSize = Math.min(width - 100 / scaleFactor, 500);
        if (this.wide.booleanValue()) {
            int raw = (int)Math.floor((float)baseXSize * 1.5f);
            xSize = Math.min(raw, width - 100 / scaleFactor);
        } else {
            xSize = baseXSize;
        }
        float leftPanelScalar = this.wide != false ? 1.25f : 1.0f;
        int leftPanelWidth = (int)(140.0f * leftPanelScalar);
        int adjScaleFactor = Math.max(2, scaleFactor);
        int innerPadding = 20 / adjScaleFactor;
        int innerWidth = xSize - (leftPanelWidth + 14) - innerPadding * 2;
        if (this.getSelectedCategory() != null && this.getCurrentlyVisibleCategories() != null && this.getCurrentlyVisibleCategories().containsKey(this.getSelectedCategory())) {
            ProcessedCategory cat = this.getCurrentlyVisibleCategories().get(this.getSelectedCategory());
            HashMap<Integer, Integer> activeAccordions = new HashMap<Integer, Integer>();
            for (ProcessedOption option : this.getOptionsInCategory(cat)) {
                GuiOptionEditorAccordion accordion;
                GuiOptionEditor editor;
                if (option.getAccordionId() >= 0 && !activeAccordions.containsKey(option.getAccordionId()) || (editor = option.getEditor()) == null) continue;
                editor.setGuiContext(this.guiContext);
                if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                    int accordionDepth = 0;
                    if (option.getAccordionId() >= 0) {
                        accordionDepth = (Integer)activeAccordions.get(option.getAccordionId()) + 1;
                    }
                    activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                }
                if (!ContextAware.wrapErrorWithContext(editor, () -> editor.keyboardInput(event2)).booleanValue()) continue;
                return true;
            }
        }
        if (event2 instanceof KeyboardEvent.KeyPressed && ((KeyboardEvent.KeyPressed)event2).getPressed() && IMinecraft.INSTANCE.isKeyboardKeyDown(IMinecraft.INSTANCE.getKeyboardConstants().getCtrlLeft()) && IMinecraft.INSTANCE.isKeyboardKeyDown(IMinecraft.INSTANCE.getKeyboardConstants().getKeyF())) {
            this.searchField.setFocus(!this.searchField.isFocused());
            return true;
        }
        if (event2 instanceof KeyboardEvent.CharTyped && !this.searchField.isFocused() && !((Config)this.getConfigObject()).shouldAutoFocusSearchbar()) {
            this.searchField.setFocus(true);
        }
        String old = this.searchFieldContent.get();
        this.searchField.keyboardEvent(event2, new GuiImmediateContext(iMinecraft.provideTopLevelRenderContext(), 0, 0, 0, 0, 0, 0, 0, 0, 0.0f, 0.0f));
        if (!this.searchFieldContent.get().equals(old)) {
            this.searchFieldContent.set(IMinecraft.INSTANCE.getDefaultFontRenderer().trimStringToWidth(this.searchFieldContent.get(), innerWidth / 2 - 20));
            this.updateSearchResults();
            return true;
        }
        return false;
    }

    private void handleKeyboardPresses() {
        LerpingInteger target;
        LerpingInteger lerpingInteger = target = this.lastMouseX < this.keyboardScrollXCutoff ? this.categoryScroll : this.optionsScroll;
        if (IMinecraft.INSTANCE.isKeyboardKeyDown(IMinecraft.INSTANCE.getKeyboardConstants().getDown())) {
            target.setTimeToReachTarget(50);
            target.resetTimer();
            target.setTarget(target.getTarget() + 5);
        } else if (IMinecraft.INSTANCE.isKeyboardKeyDown(IMinecraft.INSTANCE.getKeyboardConstants().getUp())) {
            target.setTimeToReachTarget(50);
            target.resetTimer();
            if (target.getTarget() >= 0) {
                target.setTarget(Math.max(0, target.getTarget() - 5));
            }
        } else if (IMinecraft.INSTANCE.isKeyboardKeyDown(IMinecraft.INSTANCE.getKeyboardConstants().getEscape())) {
            ((Config)this.getConfigObject()).saveNow();
        }
    }

    public boolean goToOption(@NotNull ProcessedOption option) {
        if (!this.setSelectedCategory(option.getCategory())) {
            this.search("");
            if (!this.setSelectedCategory(option.getCategory())) {
                return false;
            }
        }
        if (!this.scrollOptionIntoView(option, 200)) {
            this.search("");
            if (!this.scrollOptionIntoView(option, 200)) {
                return false;
            }
        }
        return true;
    }

    public String getSelectedCategory() {
        return this.selectedCategory;
    }

    public void setSearchFunction(SearchFunction searchFunction) {
        this.searchFunction = searchFunction;
    }

    public void setWide(Boolean wide) {
        this.wide = wide;
    }

    public List<ProcessedOption> getAllOptions() {
        return this.allOptions;
    }

    public LinkedHashMap<String, ? extends ProcessedCategory> getAllCategories() {
        return this.allCategories;
    }

    public T getConfigObject() {
        return this.configObject;
    }

    private static /* synthetic */ Boolean lambda$mouseInput$16(GuiOptionEditor editor, int finalX, int finalY, int finalWidth, int mouseX, int mouseY, MouseEvent mouseEvent) throws Exception {
        return editor.mouseInput(finalX, finalY, finalWidth, mouseX, mouseY, mouseEvent);
    }

    private static /* synthetic */ Boolean lambda$mouseInput$15(GuiOptionEditor editor, int finalX, int finalY, int finalWidth, int mouseX, int mouseY, MouseEvent mouseEvent) throws Exception {
        return editor.mouseInputOverlay(finalX, finalY, finalWidth, mouseX, mouseY, mouseEvent);
    }
}

