/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.combat.mobs;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.combat.MobsConfig;
import at.hannibal2.skyhanni.data.SlayerApi;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u0011\u001a\u00020\u0010*\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0003R\u0014\u0010\u0017\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001aR\u001d\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\u00a8\u0006&"}, d2={"Lat/hannibal2/skyhanni/features/combat/mobs/AreaMiniBossFeatures;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;", "event", "", "onMobSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;", "onMobDespawn", "(Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/features/combat/mobs/AreaMiniBossFeatures$AreaMiniBossType;", "", "getTime", "(Lat/hannibal2/skyhanni/features/combat/mobs/AreaMiniBossFeatures$AreaMiniBossType;)Ljava/lang/String;", "onWorldChange", "Lat/hannibal2/skyhanni/config/features/combat/MobsConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/combat/MobsConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastSpawnTime", "J", "miniBossType", "Lat/hannibal2/skyhanni/features/combat/mobs/AreaMiniBossFeatures$AreaMiniBossType;", "Lkotlin/time/Duration;", "respawnCooldown", "", "Lat/hannibal2/skyhanni/data/mob/Mob;", "currentMobs", "Ljava/util/Set;", "getCurrentMobs", "()Ljava/util/Set;", "AreaMiniBossType", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nAreaMiniBossFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AreaMiniBossFeatures.kt\nat/hannibal2/skyhanni/features/combat/mobs/AreaMiniBossFeatures\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1#2:121\n3829#3:122\n4344#3,2:123\n1869#4,2:125\n*S KotlinDebug\n*F\n+ 1 AreaMiniBossFeatures.kt\nat/hannibal2/skyhanni/features/combat/mobs/AreaMiniBossFeatures\n*L\n57#1:122\n57#1:123,2\n58#1:125,2\n*E\n"})
public final class AreaMiniBossFeatures {
    @NotNull
    public static final AreaMiniBossFeatures INSTANCE = new AreaMiniBossFeatures();
    private static long lastSpawnTime = SimpleTimeMark.Companion.farPast();
    @Nullable
    private static AreaMiniBossType miniBossType;
    private static long respawnCooldown;
    @NotNull
    private static final Set<Mob> currentMobs;

    private AreaMiniBossFeatures() {
    }

    private final MobsConfig getConfig() {
        return SkyHanniMod.feature.getCombat().getMobs();
    }

    @NotNull
    public final Set<Mob> getCurrentMobs() {
        return currentMobs;
    }

    @HandleEvent
    public final void onMobSpawn(@NotNull MobEvent.Spawn.SkyblockMob event2) {
        AreaMiniBossType type2;
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            Iterable iterable = (Iterable)AreaMiniBossType.getEntries();
            for (Object t : iterable) {
                AreaMiniBossType it = (AreaMiniBossType)((Object)t);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)event2.getMob().getName())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        AreaMiniBossType areaMiniBossType = v0;
        if (areaMiniBossType == null) {
            return;
        }
        miniBossType = type2 = areaMiniBossType;
        long time = SimpleTimeMark.Companion.now-uFjCsEo();
        long diff = SimpleTimeMark.minus-I5LXd8s(time, lastSpawnTime);
        long l = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS);
        boolean bl = ((Comparable)Duration.box-impl((long)diff)).compareTo(Duration.box-impl((long)DurationKt.toDuration((int)20, (DurationUnit)DurationUnit.SECONDS))) <= 0 ? 0 <= ((Comparable)Duration.box-impl((long)diff)).compareTo(Duration.box-impl((long)l)) : false;
        if (bl) {
            respawnCooldown = diff;
        }
        lastSpawnTime = time;
        if (this.getConfig().getAreaBossHighlight()) {
            event2.getMob().highlight(ColorUtils.toChromaColor$default(type2.getColor().addOpacity(type2.getColorOpacity()), 0, 0, 3, null));
        }
        currentMobs.add(event2.getMob());
    }

    @HandleEvent
    public final void onMobDespawn(@NotNull MobEvent.DeSpawn.SkyblockMob event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        currentMobs.remove(event2.getMob());
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event2) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!SlayerApi.INSTANCE.isInAnyArea()) {
            return;
        }
        if (!this.getConfig().getAreaBossRespawnTimer()) {
            return;
        }
        AreaMiniBossType areaMiniBossType = miniBossType;
        if (areaMiniBossType == null) {
            return;
        }
        AreaMiniBossType miniBoss = areaMiniBossType;
        String time = this.getTime(miniBoss);
        Object $this$filter$iv = miniBoss.getSpawnLocations();
        boolean $i$f$filter = false;
        LorenzVec[] lorenzVecArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            if (!(LocationUtils.INSTANCE.distanceToPlayer((LorenzVec)it) < 15.0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LorenzVec it = (LorenzVec)element$iv;
            boolean bl = false;
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event2, it, time, 1.2, 0.0f, 0.0, 0.0, false, false, null, 440, null);
        }
    }

    private final String getTime(AreaMiniBossType $this$getTime) {
        long spawnedSince = SimpleTimeMark.passedSince-UwyO8pc(lastSpawnTime);
        if (Duration.compareTo-LRDsOJo((long)respawnCooldown, (long)spawnedSince) <= 0) {
            return "\u00a7c?";
        }
        long estimatedTime = Duration.minus-LRDsOJo((long)respawnCooldown, (long)spawnedSince);
        String format = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, estimatedTime, null, true, false, 0, false, false, 61, null);
        return $this$getTime.getColor().getChatColor() + format;
    }

    @HandleEvent
    public final void onWorldChange() {
        miniBossType = null;
    }

    static {
        respawnCooldown = DurationKt.toDuration((int)11, (DurationUnit)DurationUnit.SECONDS);
        currentMobs = new LinkedHashSet();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B5\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001f\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001d\u00a8\u0006\u001e"}, d2={"Lat/hannibal2/skyhanni/features/combat/mobs/AreaMiniBossFeatures$AreaMiniBossType;", "", "", "displayName", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "color", "", "colorOpacity", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "spawnLocations", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lat/hannibal2/skyhanni/utils/LorenzColor;I[Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "Ljava/lang/String;", "getDisplayName", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "getColor", "()Lat/hannibal2/skyhanni/utils/LorenzColor;", "I", "getColorOpacity", "()I", "[Lat/hannibal2/skyhanni/utils/LorenzVec;", "getSpawnLocations", "()[Lat/hannibal2/skyhanni/utils/LorenzVec;", "GOLDEN_GHOUL", "OLD_WOLF", "SOUL_OF_THE_ALPHA", "VOIDLING_EXTREMIST", "MILLENNIA_AGED_BLAZE", "1.21.10"})
    private static final class AreaMiniBossType
    extends Enum<AreaMiniBossType> {
        @NotNull
        private final String displayName;
        @NotNull
        private final LorenzColor color;
        private final int colorOpacity;
        @NotNull
        private final LorenzVec[] spawnLocations;
        public static final /* enum */ AreaMiniBossType GOLDEN_GHOUL;
        public static final /* enum */ AreaMiniBossType OLD_WOLF;
        public static final /* enum */ AreaMiniBossType SOUL_OF_THE_ALPHA;
        public static final /* enum */ AreaMiniBossType VOIDLING_EXTREMIST;
        public static final /* enum */ AreaMiniBossType MILLENNIA_AGED_BLAZE;
        private static final /* synthetic */ AreaMiniBossType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AreaMiniBossType(String displayName, LorenzColor color, int colorOpacity, LorenzVec ... spawnLocations) {
            this.displayName = displayName;
            this.color = color;
            this.colorOpacity = colorOpacity;
            this.spawnLocations = spawnLocations;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final LorenzColor getColor() {
            return this.color;
        }

        public final int getColorOpacity() {
            return this.colorOpacity;
        }

        @NotNull
        public final LorenzVec[] getSpawnLocations() {
            return this.spawnLocations;
        }

        public static AreaMiniBossType[] values() {
            return (AreaMiniBossType[])$VALUES.clone();
        }

        public static AreaMiniBossType valueOf(String value) {
            return Enum.valueOf(AreaMiniBossType.class, value);
        }

        @NotNull
        public static EnumEntries<AreaMiniBossType> getEntries() {
            return $ENTRIES;
        }

        static {
            LorenzVec[] lorenzVecArray = new LorenzVec[]{new LorenzVec(-99, 39, -86), new LorenzVec(-128, 42, -138)};
            GOLDEN_GHOUL = new AreaMiniBossType("Golden Ghoul", LorenzColor.YELLOW, 127, lorenzVecArray);
            lorenzVecArray = new LorenzVec[]{new LorenzVec(-248, 123, 54), new LorenzVec(-256, 105, 75), new LorenzVec(-268, 90, 97), new LorenzVec(-258, 94, 75), new LorenzVec(-225, 92, 127)};
            OLD_WOLF = new AreaMiniBossType("Old Wolf", LorenzColor.GOLD, 60, lorenzVecArray);
            lorenzVecArray = new LorenzVec[]{new LorenzVec(-381, 56, -94), new LorenzVec(-394, 63, -52), new LorenzVec(-386, 50, -2), new LorenzVec(-396, 58, 29)};
            SOUL_OF_THE_ALPHA = new AreaMiniBossType("Soul of the Alpha", LorenzColor.GOLD, 60, lorenzVecArray);
            lorenzVecArray = new LorenzVec[]{new LorenzVec(-591, 10, -304), new LorenzVec(-544, 21, -301), new LorenzVec(-593, 26, -328), new LorenzVec(-565, 41, -307), new LorenzVec(-573, 51, -353)};
            VOIDLING_EXTREMIST = new AreaMiniBossType("Voidling Extremist", LorenzColor.LIGHT_PURPLE, 127, lorenzVecArray);
            lorenzVecArray = new LorenzVec[]{new LorenzVec(-292, 97, -999), new LorenzVec(-232, 77, -951), new LorenzVec(-304, 73, -952), new LorenzVec(-281, 82, -1010), new LorenzVec(-342, 86, -1035)};
            MILLENNIA_AGED_BLAZE = new AreaMiniBossType("Millennia-Aged Blaze", LorenzColor.DARK_RED, 60, lorenzVecArray);
            $VALUES = areaMiniBossTypeArray = new AreaMiniBossType[]{AreaMiniBossType.GOLDEN_GHOUL, AreaMiniBossType.OLD_WOLF, AreaMiniBossType.SOUL_OF_THE_ALPHA, AreaMiniBossType.VOIDLING_EXTREMIST, AreaMiniBossType.MILLENNIA_AGED_BLAZE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

