/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.dungeon.DungeonConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.dungeon.DungeonStartEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniTickEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonApi;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u000f\u0010\r\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\r\u0010\u0003J\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010 \u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010%\u001a\u00020$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010(\u001a\u00020'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R\"\u0010*\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010#\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonMilestonesDisplay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;", "event", "", "onTick", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "update", "onWorldChange", "Lat/hannibal2/skyhanni/events/dungeon/DungeonStartEvent;", "onDungeonStart", "(Lat/hannibal2/skyhanni/events/dungeon/DungeonStartEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/dungeon/DungeonConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dungeon/DungeonConfig;", "config", "Ljava/util/regex/Pattern;", "milestonePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getMilestonePattern", "()Ljava/util/regex/Pattern;", "milestonePattern", "", "display", "Ljava/lang/String;", "", "currentMilestone", "I", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "timeReached", "J", "color", "getColor", "()Ljava/lang/String;", "setColor", "(Ljava/lang/String;)V", "1.21.10"})
public final class DungeonMilestonesDisplay {
    @NotNull
    public static final DungeonMilestonesDisplay INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern milestonePattern$delegate;
    @NotNull
    private static String display;
    private static int currentMilestone;
    private static long timeReached;
    @NotNull
    private static String color;

    private DungeonMilestonesDisplay() {
    }

    private final DungeonConfig getConfig() {
        return SkyHanniMod.feature.getDungeon();
    }

    private final Pattern getMilestonePattern() {
        return (Pattern)milestonePattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @NotNull
    public final String getColor() {
        return color;
    }

    public final void setColor(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        color = string;
    }

    @HandleEvent
    public final void onTick(@NotNull SkyHanniTickEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!SkyHanniTickEvent.isMod$default(event2, 5, 0, 2, null)) {
            return;
        }
        if (currentMilestone >= 3) {
            if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(timeReached), (long)DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS)) > 0 && ((CharSequence)display).length() > 0) {
                String string = display.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                display = string;
            }
        }
    }

    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (RegexUtils.INSTANCE.matches(this.getMilestonePattern(), event2.getMessage())) {
            event2.setBlockedReason("dungeon_milestone");
            int n = currentMilestone;
            currentMilestone = n + 1;
            this.update();
        }
    }

    private final void update() {
        if (currentMilestone > 3) {
            return;
        }
        if (currentMilestone == 3) {
            timeReached = SimpleTimeMark.Companion.now-uFjCsEo();
        }
        color = switch (currentMilestone) {
            case 0, 1 -> "\u00a7c";
            case 2 -> "\u00a7e";
            default -> "\u00a7a";
        };
        display = "Current Milestone: " + currentMilestone;
    }

    @HandleEvent
    public final void onWorldChange() {
        display = "";
        currentMilestone = 0;
    }

    @HandleEvent
    public final void onDungeonStart(@NotNull DungeonStartEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        currentMilestone = 0;
        this.update();
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        RenderUtils.renderString$default(RenderUtils.INSTANCE, this.getConfig().getShowMileStonesDisplayPos(), color + display, 0, 0, "Dungeon Milestone", 6, null);
    }

    private final boolean isEnabled() {
        return DungeonApi.INSTANCE.inDungeon() && this.getConfig().getShowMilestonesDisplay();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DungeonMilestonesDisplay.class, "milestonePattern", "getMilestonePattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new DungeonMilestonesDisplay();
        milestonePattern$delegate = RepoPattern.Companion.pattern("dungeon.milestone", "\u00a7e\u00a7l.*Milestone \u00a7r\u00a7e.\u00a7r\u00a77: You have (?:tanked and )?(?:dealt|healed) \u00a7r\u00a7.*\u00a7r\u00a77.*so far! \u00a7r\u00a7a.*");
        display = "";
        timeReached = SimpleTimeMark.Companion.farPast();
        color = "";
    }
}

