/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.inventory;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.garden.NumbersConfig;
import at.hannibal2.skyhanni.data.GardenCropMilestones;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.model.ComposterUpgrade;
import at.hannibal2.skyhanni.events.RenderItemTipEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0015\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lat/hannibal2/skyhanni/features/garden/inventory/GardenInventoryNumbers;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/RenderItemTipEvent;", "event", "", "onRenderItemTip", "(Lat/hannibal2/skyhanni/events/RenderItemTipEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/NumbersConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/NumbersConfig;", "config", "Ljava/util/regex/Pattern;", "upgradeTierPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getUpgradeTierPattern", "()Ljava/util/regex/Pattern;", "upgradeTierPattern", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nGardenInventoryNumbers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GardenInventoryNumbers.kt\nat/hannibal2/skyhanni/features/garden/inventory/GardenInventoryNumbers\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n27#2:71\n14#2,2:72\n17#2:75\n8#2:76\n1#3:74\n1#3:77\n*S KotlinDebug\n*F\n+ 1 GardenInventoryNumbers.kt\nat/hannibal2/skyhanni/features/garden/inventory/GardenInventoryNumbers\n*L\n48#1:71\n48#1:72,2\n48#1:75\n56#1:76\n48#1:74\n56#1:77\n*E\n"})
public final class GardenInventoryNumbers {
    @NotNull
    public static final GardenInventoryNumbers INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern upgradeTierPattern$delegate;

    private GardenInventoryNumbers() {
    }

    private final NumbersConfig getConfig() {
        return GardenApi.INSTANCE.getConfig().getNumber();
    }

    private final Pattern getUpgradeTierPattern() {
        return (Pattern)upgradeTierPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onRenderItemTip(@NotNull RenderItemTipEvent event2) {
        RegexUtils this_$iv;
        Object crop;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (Intrinsics.areEqual((Object)InventoryUtils.INSTANCE.openInventoryName(), (Object)"Crop Milestones")) {
            if (!this.getConfig().getCropMilestone()) {
                return;
            }
            CropType cropType = GardenCropMilestones.INSTANCE.getCropTypeByLore(event2.getStack());
            if (cropType == null) {
                return;
            }
            crop = cropType;
            long counter = GardenCropMilestones.INSTANCE.getCounter((CropType)((Object)crop));
            boolean allowOverflow = GardenApi.INSTANCE.getConfig().getCropMilestones().getOverflow().getInventoryStackSize();
            int currentTier = GardenCropMilestones.INSTANCE.getTierForCropCount(counter, (CropType)((Object)crop), allowOverflow);
            event2.setStackTip("" + currentTier);
        }
        if (Intrinsics.areEqual((Object)InventoryUtils.INSTANCE.openInventoryName(), (Object)"Crop Upgrades")) {
            void $this$firstMatcher$iv;
            if (!this.getConfig().getCropUpgrades()) {
                return;
            }
            crop = RegexUtils.INSTANCE;
            Pattern counter = this.getUpgradeTierPattern();
            List<String> list$iv = ItemUtils.INSTANCE.getLore(event2.getStack());
            boolean $i$f$firstMatcher = false;
            RegexUtils currentTier = this_$iv;
            void var7_11 = $this$firstMatcher$iv;
            Sequence sequence$iv$iv = CollectionsKt.asSequence((Iterable)list$iv);
            boolean $i$f$firstMatcher2 = false;
            for (String line$iv$iv : sequence$iv$iv) {
                void $this$firstMatcher$iv$iv;
                Matcher it$iv$iv = $this$firstMatcher$iv$iv.matcher(line$iv$iv);
                boolean bl = false;
                if (!it$iv$iv.matches()) continue;
                Intrinsics.checkNotNull((Object)it$iv$iv);
                Matcher $this$onRenderItemTip_u24lambda_u240 = it$iv$iv;
                boolean bl2 = false;
                event2.setStackTip($this$onRenderItemTip_u24lambda_u240.group("tier"));
                break;
            }
        }
        if (Intrinsics.areEqual((Object)InventoryUtils.INSTANCE.openInventoryName(), (Object)"Composter Upgrades")) {
            void $this$matchMatcher$iv;
            if (!this.getConfig().getComposterUpgrades()) {
                return;
            }
            this_$iv = RegexUtils.INSTANCE;
            Pattern $this$firstMatcher$iv = ComposterUpgrade.Companion.getRegex();
            String text$iv = TextCompatKt.formattedTextCompatLeadingWhiteLessResets(event2.getStack().method_7964());
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
            boolean bl = false;
            if (it$iv.matches()) {
                Intrinsics.checkNotNull((Object)it$iv);
                Matcher $this$onRenderItemTip_u24lambda_u241 = it$iv;
                boolean bl3 = false;
                String string = $this$onRenderItemTip_u24lambda_u241.group("level");
                int level = string != null ? NumberUtil.INSTANCE.romanToDecimalIfNecessary(string) : 0;
                event2.setStackTip(String.valueOf(level));
            }
        }
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 3, "garden.numberCropMilestone", "garden.number.cropMilestone", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 3, "garden.numberCropUpgrades", "garden.number.cropUpgrades", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 3, "garden.numberComposterUpgrades", "garden.number.composterUpgrades", null, 8, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(GardenInventoryNumbers.class, "upgradeTierPattern", "getUpgradeTierPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new GardenInventoryNumbers();
        upgradeTierPattern$delegate = RepoPattern.Companion.pattern("garden.inventory.numbers.upgradetier", "\u00a77Current Tier: \u00a7[ea](?<tier>.*)\u00a77/\u00a7a.*");
    }
}

