/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.bazaar;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.inventory.BazaarConfig;
import at.hannibal2.skyhanni.config.storage.PlayerSpecificStorage;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.jsonobjects.repo.BazaarJson;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.bazaar.BazaarTransactionEvent;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarApi;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ItemPriceUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0014\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010 \u001a\u0004\u0018\u00010\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR$\u0010&\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00138B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R(\u0010,\u001a\u0004\u0018\u00010'2\b\u0010!\u001a\u0004\u0018\u00010'8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006-"}, d2={"Lat/hannibal2/skyhanni/features/inventory/bazaar/BazaarLimitTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/bazaar/BazaarTransactionEvent;", "event", "", "onBazaarTransaction", "(Lat/hannibal2/skyhanni/events/bazaar/BazaarTransactionEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryFullyOpened", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "checkDate", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "onBackgroundDraw", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "", "dailyLimit", "D", "", "capOrdersAtIntLimit", "Z", "Lat/hannibal2/skyhanni/config/features/inventory/BazaarConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/BazaarConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/PlayerSpecificStorage$BazaarStorage;", "getStorage", "()Lat/hannibal2/skyhanni/config/storage/PlayerSpecificStorage$BazaarStorage;", "storage", "value", "getCoinsTowardsLimit", "()D", "setCoinsTowardsLimit", "(D)V", "coinsTowardsLimit", "Ljava/time/LocalDate;", "getLastAccessedDay", "()Ljava/time/LocalDate;", "setLastAccessedDay", "(Ljava/time/LocalDate;)V", "lastAccessedDay", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nBazaarLimitTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazaarLimitTracker.kt\nat/hannibal2/skyhanni/features/inventory/bazaar/BazaarLimitTracker\n+ 2 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 3 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 4 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n*L\n1#1,99:1\n13#2,7:100\n21#2,6:117\n167#3,5:107\n172#3,4:113\n24#4:112\n*S KotlinDebug\n*F\n+ 1 BazaarLimitTracker.kt\nat/hannibal2/skyhanni/features/inventory/bazaar/BazaarLimitTracker\n*L\n94#1:100,7\n94#1:117,6\n94#1:107,5\n94#1:113,4\n94#1:112\n*E\n"})
public final class BazaarLimitTracker {
    @NotNull
    public static final BazaarLimitTracker INSTANCE = new BazaarLimitTracker();
    private static double dailyLimit = 1.5E10;
    private static boolean capOrdersAtIntLimit = true;

    private BazaarLimitTracker() {
    }

    private final BazaarConfig getConfig() {
        return SkyHanniMod.feature.getInventory().getBazaar();
    }

    private final PlayerSpecificStorage.BazaarStorage getStorage() {
        PlayerSpecificStorage playerSpecificStorage = ProfileStorageData.INSTANCE.getPlayerSpecific();
        return playerSpecificStorage != null ? playerSpecificStorage.getBazaar() : null;
    }

    private final double getCoinsTowardsLimit() {
        PlayerSpecificStorage.BazaarStorage bazaarStorage = this.getStorage();
        return bazaarStorage != null ? bazaarStorage.getCoinsTowardsLimit() : 0.0;
    }

    private final void setCoinsTowardsLimit(double value) {
        block0: {
            PlayerSpecificStorage.BazaarStorage bazaarStorage = this.getStorage();
            if (bazaarStorage == null) break block0;
            bazaarStorage.setCoinsTowardsLimit(value);
        }
    }

    private final LocalDate getLastAccessedDay() {
        PlayerSpecificStorage.BazaarStorage bazaarStorage = this.getStorage();
        return bazaarStorage != null ? bazaarStorage.getLastAccessedDay() : null;
    }

    private final void setLastAccessedDay(LocalDate value) {
        block0: {
            PlayerSpecificStorage.BazaarStorage bazaarStorage = this.getStorage();
            if (bazaarStorage == null) break block0;
            bazaarStorage.setLastAccessedDay(value);
        }
    }

    @HandleEvent
    public final void onBazaarTransaction(@NotNull BazaarTransactionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getTransactionType() == BazaarTransactionEvent.TransactionType.FLIP_ORDER) {
            return;
        }
        double coinsUpToIntLimit = capOrdersAtIntLimit && event2.getCoinAmount() >= 2.147483647E9 ? 2.147483647E9 : event2.getCoinAmount();
        this.setCoinsTowardsLimit(this.getCoinsTowardsLimit() + coinsUpToIntLimit);
        if (this.getCoinsTowardsLimit() >= dailyLimit) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "You reached your daily trade limit in the bazaar!", false, null, false, false, null, 62, null);
        }
    }

    @HandleEvent
    public final void onInventoryFullyOpened(@NotNull InventoryFullyOpenedEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!BazaarApi.INSTANCE.getInBazaarInventory()) {
            return;
        }
        this.checkDate();
    }

    private final void checkDate() {
        LocalDate currentDay = ZonedDateTime.now(ZoneOffset.UTC).toLocalDate();
        LocalDate lastAccessed = this.getLastAccessedDay();
        if (lastAccessed == null || currentDay.isAfter(lastAccessed)) {
            this.setCoinsTowardsLimit(0.0);
            this.setLastAccessedDay(currentDay);
        }
    }

    @HandleEvent
    public final void onBackgroundDraw(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.getConfig().getDailyLimitTracker()) {
            return;
        }
        if (!BazaarApi.INSTANCE.getInBazaarInventory()) {
            return;
        }
        String color = NumberUtil.INSTANCE.percentageColor((long)dailyLimit - (long)this.getCoinsTowardsLimit(), (long)dailyLimit).getChatColor();
        List $this$onBackgroundDraw_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$onBackgroundDraw_u24lambda_u240, "\u00a7aBazaar Daily Limit:", 0.0, null, null, 14, null);
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$onBackgroundDraw_u24lambda_u240, color + NumberUtil.INSTANCE.addSeparators((long)INSTANCE.getCoinsTowardsLimit()) + "\u00a77/" + ItemPriceUtils.formatCoin$default(ItemPriceUtils.INSTANCE, dailyLimit, false, 1, null) + " coins", 0.0, null, null, 14, null);
        if (INSTANCE.getCoinsTowardsLimit() >= dailyLimit) {
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$onBackgroundDraw_u24lambda_u240, "\u00a7cLimit reached!", 0.0, null, null, 14, null);
        }
        List display2 = CollectionsKt.build((List)list);
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, this.getConfig().getDailyLimitTrackerPosition(), display2, 0, "Bazaar Daily Limit Tracker", false, 10, null);
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        String constant$iv = "Bazaar";
        Object type$iv = null;
        Gson gson$iv = ((AbstractRepoReloadEvent)event2).getGson();
        boolean $i$f$getConstant = false;
        Object object2 = event2;
        try {
            Object $this$getRepoData_u24lambda_u2414$iv$iv;
            void this_$iv$iv;
            AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = object2;
            boolean bl = false;
            AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
            String directory$iv$iv = "constants";
            boolean $i$f$getRepoData = false;
            Object object3 = this_$iv$iv;
            try {
                $this$getRepoData_u24lambda_u2414$iv$iv = object3;
                boolean bl2 = false;
                String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                JsonElement json$iv$iv = jsonElement;
                Gson $this$fromJson$iv$iv$iv = gson$iv;
                boolean $i$f$fromJson = false;
                Object object4 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(BazaarJson.class)));
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"fromJson(...)");
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)object4);
            }
            catch (Throwable bl2) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object3 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable != null) {
                Throwable e$iv$iv = throwable;
                boolean bl3 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + constant$iv + "'", e$iv$iv);
                throw new KotlinNothingValueException();
            }
            Object constantData$iv = object3;
            $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant(constant$iv);
            object = constantData$iv;
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl4 = false;
                ((AbstractRepoReloadEvent)event2).getManager().addUnsuccessfulConstant(constant$iv);
                ((AbstractRepoReloadEvent)event2).getManager().getLogger().throwErrorWithCause("Could not load constant '" + constant$iv + "'", it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        BazaarJson data = (BazaarJson)object;
        dailyLimit = data.getDailyLimit();
        capOrdersAtIntLimit = data.getCapOrdersAtIntLimit();
    }
}

