/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.compacttablist;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.api.minecraftevents.RenderLayer;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.misc.compacttablist.CompactTabListConfig;
import at.hannibal2.skyhanni.data.GlobalRender;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.SkipTabListLineEvent;
import at.hannibal2.skyhanni.events.render.gui.GameOverlayRenderPreEvent;
import at.hannibal2.skyhanni.features.misc.compacttablist.AdvancedPlayerList;
import at.hannibal2.skyhanni.features.misc.compacttablist.RenderColumn;
import at.hannibal2.skyhanni.features.misc.compacttablist.TabLine;
import at.hannibal2.skyhanni.features.misc.compacttablist.TabListReader;
import at.hannibal2.skyhanni.features.misc.compacttablist.TabStringType;
import at.hannibal2.skyhanni.utils.GuiRenderUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.TabListData;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.compat.DrawContextUtils;
import at.hannibal2.skyhanni.utils.compat.GuiScreenUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_640;
import net.minecraft.class_7532;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J-\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\r8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b!\u0010 R\u0014\u0010\"\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\"\u0010 R\u0014\u0010#\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b#\u0010 R\u0014\u0010%\u001a\u00020$8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010(\u001a\u00020'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010*\u001a\u00020'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010)R\u001b\u00100\u001a\u00020+8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lat/hannibal2/skyhanni/features/misc/compacttablist/TabListRenderer;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/render/gui/GameOverlayRenderPreEvent;", "event", "", "onRenderOverlayPre", "(Lat/hannibal2/skyhanni/events/render/gui/GameOverlayRenderPreEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "drawTabList", "", "x", "headerY", "", "Lat/hannibal2/skyhanni/features/misc/compacttablist/RenderColumn;", "columns", "drawColumns", "(IILjava/util/List;)V", "Lat/hannibal2/skyhanni/events/SkipTabListLineEvent;", "onSkipTablistLine", "(Lat/hannibal2/skyhanni/events/SkipTabListLineEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/misc/compacttablist/CompactTabListConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/misc/compacttablist/CompactTabListConfig;", "config", "MAX_LINES", "I", "LINE_HEIGHT", "TAB_PADDING", "COLUMN_SPACING", "", "TAB_Z_OFFSET", "F", "", "isPressed", "Z", "isTabToggled", "Ljava/util/regex/Pattern;", "fireSalePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getFireSalePattern", "()Ljava/util/regex/Pattern;", "fireSalePattern", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nTabListRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TabListRenderer.kt\nat/hannibal2/skyhanni/features/misc/compacttablist/TabListRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n1#2:243\n*E\n"})
public final class TabListRenderer {
    @NotNull
    public static final TabListRenderer INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    public static final int MAX_LINES = 22;
    private static final int LINE_HEIGHT = 9;
    private static final int TAB_PADDING = 3;
    private static final int COLUMN_SPACING = 6;
    private static final float TAB_Z_OFFSET = 10.0f;
    private static boolean isPressed;
    private static boolean isTabToggled;
    @NotNull
    private static final RepoPattern fireSalePattern$delegate;

    private TabListRenderer() {
    }

    private final CompactTabListConfig getConfig() {
        return SkyHanniMod.feature.gui.getCompactTabList();
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onRenderOverlayPre(@NotNull GameOverlayRenderPreEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (GlobalRender.INSTANCE.getRenderDisabled()) {
            return;
        }
        if (event2.getType() != RenderLayer.PLAYER_LIST) {
            return;
        }
        if (!((Boolean)this.getConfig().getEnabled().get()).booleanValue()) {
            return;
        }
        event2.cancel();
        if (this.getConfig().getToggleTab()) {
            return;
        }
        this.drawTabList();
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (GlobalRender.INSTANCE.getRenderDisabled()) {
            return;
        }
        if (!((Boolean)this.getConfig().getEnabled().get()).booleanValue()) {
            return;
        }
        if (!this.getConfig().getToggleTab()) {
            return;
        }
        if (class_310.method_1551().field_1755 != null) {
            return;
        }
        class_304 class_3042 = class_310.method_1551().field_1690.field_1907;
        Intrinsics.checkNotNullExpressionValue((Object)class_3042, (String)"playerListKey");
        if (KeyboardManager.INSTANCE.isActive(class_3042)) {
            if (!isPressed) {
                isPressed = true;
                isTabToggled = !isTabToggled;
            }
        } else {
            isPressed = false;
        }
        if (isTabToggled) {
            this.drawTabList();
        }
    }

    private final void drawTabList() {
        List<RenderColumn> columns = TabListReader.INSTANCE.getRenderColumns();
        if (columns.isEmpty()) {
            return;
        }
        DrawContextUtils.INSTANCE.translate(0.0f, 0.0f, 10.0f);
        int maxLines = 0;
        int totalWidth = -6;
        for (RenderColumn column : columns) {
            maxLines = RangesKt.coerceAtLeast((int)maxLines, (int)column.size());
            totalWidth += column.getMaxWidth() + 6;
        }
        int totalHeight = maxLines * 9;
        List header = CollectionsKt.emptyList();
        if (!this.getConfig().getHideAdverts()) {
            String[] stringArray = new String[]{"\n"};
            header = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)TabListData.INSTANCE.getHeader(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            header.removeIf(arg_0 -> TabListRenderer.drawTabList$lambda$1(TabListRenderer::drawTabList$lambda$0, arg_0));
            totalHeight += header.size() * 9 + 3;
        }
        List footer = CollectionsKt.emptyList();
        if (!this.getConfig().getHideAdverts()) {
            String[] stringArray = new String[]{"\n"};
            footer = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)TabListData.INSTANCE.getFooter(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            footer.removeIf(arg_0 -> TabListRenderer.drawTabList$lambda$3(TabListRenderer::drawTabList$lambda$2, arg_0));
            totalHeight += footer.size() * 9 + 3;
        }
        class_310 minecraft = class_310.method_1551();
        int screenWidth = GuiScreenUtils.INSTANCE.getScaledWindowWidth() / 2;
        int x = screenWidth - totalWidth / 2;
        int y = 10;
        if (!this.getConfig().getHideTabBackground()) {
            GuiRenderUtils.INSTANCE.drawRect(x - 6, y - 3, screenWidth + totalWidth / 2 + 6, 10 + totalHeight + 3, Integer.MIN_VALUE);
        }
        int headerY = y;
        if (!((Collection)header).isEmpty()) {
            for (String line : header) {
                GuiRenderUtils.drawString$default(GuiRenderUtils.INSTANCE, line, (float)x + (float)totalWidth / 2.0f - (float)minecraft.field_1772.method_1727(line) / 2.0f, (float)headerY, -1, false, 16, null);
                headerY += 9;
            }
        }
        this.drawColumns(x, headerY, columns);
        if (!((Collection)footer).isEmpty()) {
            int footerY = y + totalHeight - footer.size() * 9 + 1 + 1;
            for (String line : footer) {
                GuiRenderUtils.drawString$default(GuiRenderUtils.INSTANCE, line, (float)x + (float)totalWidth / 2.0f - (float)minecraft.field_1772.method_1727(line) / 2.0f, (float)footerY, -1, false, 16, null);
                footerY += 9;
            }
        }
        DrawContextUtils.INSTANCE.translate(0.0f, 0.0f, -10.0f);
    }

    private final void drawColumns(int x, int headerY, List<RenderColumn> columns) {
        int middleX = x;
        Ref.ObjectRef lastTitle = new Ref.ObjectRef();
        Ref.ObjectRef lastSubTitle = new Ref.ObjectRef();
        for (RenderColumn originalColumn : columns) {
            int middleY = this.getConfig().getHideAdverts() ? headerY : headerY + 3 + 2;
            List<TabLine> p0 = CollectionUtils.INSTANCE.filterToMutable(originalColumn.getLines(), arg_0 -> TabListRenderer.drawColumns$lambda$4(lastSubTitle, lastTitle, arg_0));
            boolean bl = false;
            RenderColumn column = new RenderColumn(p0);
            GuiRenderUtils.INSTANCE.drawRect(middleX - 3 + 1, middleY - 3 + 1, middleX + column.getMaxWidth() + 3 - 2, middleY + column.size() * 9 + 3 - 2, this.getConfig().getHideTabBackground() ? -1893325274 : 0x20AAAAAA);
            for (TabLine tabLine : column.getLines()) {
                Object text;
                boolean hideIcons;
                int savedX = middleX;
                boolean bl2 = hideIcons = this.getConfig().getAdvancedPlayerList().getHidePlayerIcons() && !AdvancedPlayerList.INSTANCE.ignoreCustomTabList();
                if (tabLine.getType() == TabStringType.PLAYER && !hideIcons) {
                    class_640 playerInfo = tabLine.getInfo();
                    if (playerInfo != null) {
                        class_2960 texture = playerInfo.method_52810().comp_1626().comp_3626();
                        class_7532.method_44445((class_332)DrawContextUtils.INSTANCE.getDrawContext(), (class_2960)texture, (int)middleX, (int)middleY, (int)8, (boolean)playerInfo.method_65195(), (boolean)false, (int)-1);
                    }
                    middleX += 10;
                }
                Object object = text = AdvancedPlayerList.INSTANCE.ignoreCustomTabList() ? tabLine.getText() : tabLine.getCustomName();
                if (StringsKt.contains$default((CharSequence)((CharSequence)text), (CharSequence)"\u00a7l", (boolean)false, (int)2, null)) {
                    text = "\u00a7r" + (String)text;
                }
                if (tabLine.getType() == TabStringType.TITLE) {
                    GuiRenderUtils.drawString$default(GuiRenderUtils.INSTANCE, (String)text, (float)middleX + (float)column.getMaxWidth() / 2.0f - (float)tabLine.getWidth() / 2.0f, (float)middleY, -1, false, 16, null);
                } else {
                    GuiRenderUtils.drawString$default(GuiRenderUtils.INSTANCE, (String)text, (float)middleX, (float)middleY, -1, false, 16, null);
                }
                middleY += 9;
                middleX = savedX;
            }
            middleX += column.getMaxWidth() + 6;
        }
    }

    private final Pattern getFireSalePattern() {
        return (Pattern)fireSalePattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @HandleEvent
    public final void onSkipTablistLine(@NotNull SkipTabListLineEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (this.getConfig().getHideFiresales() && event2.getLastSubTitle() != null && RegexUtils.INSTANCE.matches(this.getFireSalePattern(), event2.getLastSubTitle().getText())) {
            event2.cancel();
        }
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 31, "misc.compactTabList", "gui.compactTabList", null, 8, null);
    }

    private static final boolean drawTabList$lambda$0(String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return !StringsKt.contains$default((CharSequence)line, (CharSequence)TabListReader.INSTANCE.getHypixelAdvertisingString(), (boolean)false, (int)2, null);
    }

    private static final boolean drawTabList$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean drawTabList$lambda$2(String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return !StringsKt.contains$default((CharSequence)line, (CharSequence)TabListReader.INSTANCE.getHypixelAdvertisingString(), (boolean)false, (int)2, null);
    }

    private static final boolean drawTabList$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean drawColumns$lambda$4(Ref.ObjectRef $lastSubTitle, Ref.ObjectRef $lastTitle, TabLine tabLine) {
        Intrinsics.checkNotNullParameter((Object)$lastSubTitle, (String)"$lastSubTitle");
        Intrinsics.checkNotNullParameter((Object)$lastTitle, (String)"$lastTitle");
        Intrinsics.checkNotNullParameter((Object)tabLine, (String)"tabLine");
        if (tabLine.getType() == TabStringType.TITLE) {
            $lastSubTitle.element = null;
            $lastTitle.element = tabLine;
        }
        if (tabLine.getType() == TabStringType.SUB_TITLE) {
            $lastSubTitle.element = tabLine;
        }
        return !new SkipTabListLineEvent(tabLine, (TabLine)$lastSubTitle.element, (TabLine)$lastTitle.element).post();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TabListRenderer.class, "fireSalePattern", "getFireSalePattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new TabListRenderer();
        fireSalePattern$delegate = RepoPattern.Companion.pattern("tablist.firesaletitle", "\u00a7.\u00a7lFire Sales: \u00a7r\u00a7f\\([0-9]+\\)");
    }
}

