/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.nether.ashfang;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.crimsonisle.ashfang.AshfangConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.events.SkyHanniRenderEntityEvent;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.MobUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0011\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0011\u0010\u001a\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR(\u0010 \u001a\u0004\u0018\u00010\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001c8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R$\u0010%\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020$8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0011\u0010,\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006-"}, d2={"Lat/hannibal2/skyhanni/features/nether/ashfang/AshfangManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;", "event", "", "onMobSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/MobEvent$FirstSeen$SkyblockMob;", "onMobFirstSeen", "(Lat/hannibal2/skyhanni/events/MobEvent$FirstSeen$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;", "onMobDespawn", "(Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/SkyHanniRenderEntityEvent$Specials$Pre;", "Lnet/minecraft/class_1531;", "onRenderLiving", "(Lat/hannibal2/skyhanni/events/SkyHanniRenderEntityEvent$Specials$Pre;)V", "onWorldChange", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/crimsonisle/ashfang/AshfangConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/crimsonisle/ashfang/AshfangConfig;", "config", "", "Lat/hannibal2/skyhanni/data/mob/Mob;", "ashfangMobs", "Ljava/util/Set;", "value", "ashfang", "Lat/hannibal2/skyhanni/data/mob/Mob;", "getAshfang", "()Lat/hannibal2/skyhanni/data/mob/Mob;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastSpawnTime", "J", "getLastSpawnTime-uFjCsEo", "()J", "", "getActive", "()Z", "active", "1.21.10"})
public final class AshfangManager {
    @NotNull
    public static final AshfangManager INSTANCE = new AshfangManager();
    @NotNull
    private static final Set<Mob> ashfangMobs = new LinkedHashSet();
    @Nullable
    private static Mob ashfang;
    private static long lastSpawnTime;

    private AshfangManager() {
    }

    @NotNull
    public final AshfangConfig getConfig() {
        return SkyHanniMod.feature.getCrimsonIsle().getAshfang();
    }

    @Nullable
    public final Mob getAshfang() {
        return ashfang;
    }

    public final long getLastSpawnTime-uFjCsEo() {
        return lastSpawnTime;
    }

    public final boolean getActive() {
        return ashfang != null;
    }

    @HandleEvent(onlyOnIsland=IslandType.CRIMSON_ISLE)
    public final void onMobSpawn(@NotNull MobEvent.Spawn.SkyblockMob event2) {
        LorenzColor lorenzColor;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Mob mob = event2.getMob();
        switch (mob.getName()) {
            case "Ashfang Follower": {
                lorenzColor = LorenzColor.DARK_GRAY;
                break;
            }
            case "Ashfang Underling": {
                lorenzColor = LorenzColor.RED;
                break;
            }
            case "Ashfang Acolyte": {
                lorenzColor = LorenzColor.BLUE;
                break;
            }
            case "Ashfang": {
                ashfang = mob;
                return;
            }
            default: {
                return;
            }
        }
        LorenzColor color = lorenzColor;
        ((Collection)ashfangMobs).add(mob);
        if (this.getConfig().getHighlightBlazes()) {
            mob.highlight(ColorUtils.toChromaColor$default(ColorUtils.INSTANCE.addAlpha(color.toColor(), 40), 0, 0, 3, null));
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.CRIMSON_ISLE)
    public final void onMobFirstSeen(@NotNull MobEvent.FirstSeen.SkyblockMob event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!StringsKt.contains$default((CharSequence)event2.getMob().getName(), (CharSequence)"Ashfang ", (boolean)false, (int)2, null)) {
            return;
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastSpawnTime), (long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS)) < 0) {
            return;
        }
        lastSpawnTime = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @HandleEvent
    public final void onMobDespawn(@NotNull MobEvent.DeSpawn.SkyblockMob event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Mob mob = event2.getMob();
        ((Collection)ashfangMobs).remove(mob);
        if (Intrinsics.areEqual((Object)ashfang, (Object)mob)) {
            ashfang = null;
            if (mob.isInRender()) {
                lastSpawnTime = SimpleTimeMark.Companion.farPast();
            }
        }
    }

    @HandleEvent(priority=-1)
    public final void onRenderLiving(@NotNull SkyHanniRenderEntityEvent.Specials.Pre<class_1531> event2) {
        Intrinsics.checkNotNullParameter(event2, (String)"event");
        if (!this.getActive() || !this.getConfig().getHide().getFullNames()) {
            return;
        }
        Mob mob = MobUtils.INSTANCE.getMob((class_1309)event2.getEntity());
        if (mob == null) {
            return;
        }
        Mob mob2 = mob;
        if (!ashfangMobs.contains(mob2)) {
            return;
        }
        if (EntityUtils.INSTANCE.isAtFullHealth(mob2.getBaseEntity())) {
            event2.cancel();
        }
    }

    @HandleEvent
    public final void onWorldChange() {
        lastSpawnTime = SimpleTimeMark.Companion.farPast();
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 2, "ashfang.nextResetCooldown", "crimsonIsle.ashfang.nextResetCooldown", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 2, "ashfang.highlightBlazes", "crimsonIsle.ashfang.highlightBlazes", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 2, "ashfang.hideNames", "crimsonIsle.ashfang.hide.fullNames", null, 8, null);
    }

    static {
        lastSpawnTime = SimpleTimeMark.Companion.farPast();
    }
}

