/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.slayer;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.slayer.ActiveBossTransparencyConfig;
import at.hannibal2.skyhanni.data.SlayerApi;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.data.mob.MobFilter;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.events.entity.EntityClickEvent;
import at.hannibal2.skyhanni.events.entity.EntityOpacityActiveEvent;
import at.hannibal2.skyhanni.events.entity.EntityOpacityEvent;
import at.hannibal2.skyhanni.features.misc.CarryTracker;
import at.hannibal2.skyhanni.utils.MobUtils;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2824;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0011\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0019\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lat/hannibal2/skyhanni/features/slayer/ActiveBossTransparency;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/entity/EntityOpacityActiveEvent;", "event", "", "onEntityOpacityActive", "(Lat/hannibal2/skyhanni/events/entity/EntityOpacityActiveEvent;)V", "Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;", "onMobDeSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/entity/EntityClickEvent;", "onClickEntity", "(Lat/hannibal2/skyhanni/events/entity/EntityClickEvent;)V", "Lat/hannibal2/skyhanni/events/entity/EntityOpacityEvent;", "Lnet/minecraft/class_1309;", "onEntityOpacity", "(Lat/hannibal2/skyhanni/events/entity/EntityOpacityEvent;)V", "", "isActive", "()Z", "Lat/hannibal2/skyhanni/config/features/slayer/ActiveBossTransparencyConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/slayer/ActiveBossTransparencyConfig;", "config", "Lat/hannibal2/skyhanni/data/mob/Mob;", "lastClickedMob", "Lat/hannibal2/skyhanni/data/mob/Mob;", "lastHitCarrierBoss", "Z", "1.21.10"})
public final class ActiveBossTransparency {
    @NotNull
    public static final ActiveBossTransparency INSTANCE = new ActiveBossTransparency();
    @Nullable
    private static Mob lastClickedMob;
    private static boolean lastHitCarrierBoss;

    private ActiveBossTransparency() {
    }

    private final ActiveBossTransparencyConfig getConfig() {
        return SlayerApi.INSTANCE.getConfig().getActiveBossTransparency();
    }

    @HandleEvent
    public final void onEntityOpacityActive(@NotNull EntityOpacityActiveEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.setActive(this.isActive());
    }

    @HandleEvent
    public final void onMobDeSpawn(@NotNull MobEvent.DeSpawn.SkyblockMob event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (Intrinsics.areEqual((Object)lastClickedMob, (Object)event2.getMob())) {
            lastClickedMob = null;
            lastHitCarrierBoss = false;
        }
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onClickEntity(@NotNull EntityClickEvent event2) {
        Mob mob;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getAction() != class_2824.class_5907.field_29172) {
            return;
        }
        Mob mob2 = MobUtils.INSTANCE.getMob(event2.getClickedEntity());
        if (mob2 == null) {
            return;
        }
        lastClickedMob = mob = mob2;
        lastHitCarrierBoss = CarryTracker.INSTANCE.isCustomer(mob.getOwnerNameOrEmpty());
    }

    @HandleEvent
    public final void onEntityOpacity(@NotNull EntityOpacityEvent<class_1309> event2) {
        Intrinsics.checkNotNullParameter(event2, (String)"event");
        if (!this.isActive()) {
            return;
        }
        class_1309 entity = event2.getEntity();
        if (MinecraftCompat.INSTANCE.isLocalPlayer((class_1297)entity)) {
            return;
        }
        if (MobFilter.INSTANCE.isDisplayNpc(entity)) {
            return;
        }
        Mob mob = MobUtils.INSTANCE.getMob(entity);
        if (mob != null) {
            Mob mob2 = mob;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)mob2, (Object)lastClickedMob)) {
                return;
            }
            Mob.Type type2 = mob2.getMobType();
            if (type2 == Mob.Type.SLAYER) {
                if (Mob.Companion.belongsToPlayer(mob2)) {
                    return;
                }
                if (CarryTracker.INSTANCE.isCustomer(mob2.getOwnerNameOrEmpty())) {
                    return;
                }
            }
            if (type2 == Mob.Type.PLAYER) {
                if (CarryTracker.INSTANCE.isCustomer(mob2.getName())) {
                    return;
                }
                if (!INSTANCE.getConfig().getApplyToPlayers()) {
                    return;
                }
            }
            if (type2 == Mob.Type.PLAYER && !INSTANCE.getConfig().getApplyToPlayers()) {
                return;
            }
        }
        event2.setOpacity(RangesKt.coerceIn((int)this.getConfig().getTransparencyLevel(), (int)15, (int)70));
    }

    private final boolean isActive() {
        return this.getConfig().getEnabled() && (SlayerApi.INSTANCE.isInBossFight() || lastHitCarrierBoss);
    }
}

