/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.slayer;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.slayer.SlayerConfig;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.SlayerApi;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.events.ItemClickEvent;
import at.hannibal2.skyhanni.events.entity.EntityHealthUpdateEvent;
import at.hannibal2.skyhanni.events.slayer.SlayerStateChangeEvent;
import at.hannibal2.skyhanni.features.event.diana.DianaApi;
import at.hannibal2.skyhanni.features.slayer.SlayerType;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u0003J\u001f\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010 \u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010&R\u0016\u0010(\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010*\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010#R\u0016\u0010+\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lat/hannibal2/skyhanni/features/slayer/SlayerQuestWarning;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/slayer/SlayerStateChangeEvent;", "event", "", "onSlayerStateChange", "(Lat/hannibal2/skyhanni/events/slayer/SlayerStateChangeEvent;)V", "", "reason", "needNewQuest", "(Ljava/lang/String;)V", "tryWarn", "titleMessage", "chatMessage", "warn", "(Ljava/lang/String;Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/events/entity/EntityHealthUpdateEvent;", "onEntityHealthUpdate", "(Lat/hannibal2/skyhanni/events/entity/EntityHealthUpdateEvent;)V", "Lnet/minecraft/class_1309;", "entity", "", "isSlayerMob", "(Lnet/minecraft/class_1309;)Z", "Lat/hannibal2/skyhanni/events/ItemClickEvent;", "onItemClick", "(Lat/hannibal2/skyhanni/events/ItemClickEvent;)V", "Lat/hannibal2/skyhanni/config/features/slayer/SlayerConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/slayer/SlayerConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastWeaponUse", "J", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "voidItem", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "endItem", "needSlayerQuest", "Z", "lastWarning", "currentReason", "Ljava/lang/String;", "1.21.10"})
public final class SlayerQuestWarning {
    @NotNull
    public static final SlayerQuestWarning INSTANCE = new SlayerQuestWarning();
    private static long lastWeaponUse = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static final NeuInternalName voidItem = NeuInternalName.Companion.toInternalName("ASPECT_OF_THE_VOID");
    @NotNull
    private static final NeuInternalName endItem = NeuInternalName.Companion.toInternalName("ASPECT_OF_THE_END");
    private static boolean needSlayerQuest;
    private static long lastWarning;
    @NotNull
    private static String currentReason;

    private SlayerQuestWarning() {
    }

    private final SlayerConfig getConfig() {
        return SlayerApi.INSTANCE.getConfig();
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onSlayerStateChange(@NotNull SlayerStateChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getState() == SlayerApi.ActiveQuestState.GRINDING) {
            needSlayerQuest = false;
        }
        if (event2.getState() == SlayerApi.ActiveQuestState.FAILED) {
            this.needNewQuest("The old slayer quest has failed!");
        }
        if (event2.getState() == SlayerApi.ActiveQuestState.SLAIN) {
            DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), (Function0<Unit>)((Function0)SlayerQuestWarning::onSlayerStateChange$lambda$0));
        }
    }

    private final void needNewQuest(String reason) {
        currentReason = reason;
        needSlayerQuest = true;
    }

    private final void tryWarn() {
        if (!needSlayerQuest) {
            return;
        }
        this.warn("New Slayer Quest!", "Start a new slayer quest! " + currentReason);
    }

    private final void warn(String titleMessage, String chatMessage) {
        if (!this.getConfig().getQuestWarning()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastWarning), (long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS)) < 0) {
            return;
        }
        if (DianaApi.INSTANCE.isDoingDiana()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastWeaponUse), (long)DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS)) > 0) {
            return;
        }
        lastWarning = SimpleTimeMark.Companion.now-uFjCsEo();
        ChatUtils.chat$default(ChatUtils.INSTANCE, chatMessage, false, null, false, false, null, 62, null);
        if (this.getConfig().getQuestWarningTitle()) {
            TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, "\u00a7e" + titleMessage, null, DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16378, null);
        }
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onEntityHealthUpdate(@NotNull EntityHealthUpdateEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        class_1309 entity = event2.getEntity();
        if (LocationUtils.INSTANCE.distanceToPlayer(LorenzVecKt.getLorenzVec((class_1297)entity)) < 6.0 && this.isSlayerMob(entity)) {
            this.tryWarn();
        }
    }

    private final boolean isSlayerMob(class_1309 entity) {
        SlayerType slayerType;
        block5: {
            SlayerType slayerType2 = SlayerApi.INSTANCE.getCurrentAreaType();
            if (slayerType2 == null) {
                return false;
            }
            slayerType = slayerType2;
            if (Intrinsics.areEqual((Object)TextCompatKt.formattedTextCompatLessResets(entity.method_5477()), (Object)"Oubliette Guard")) {
                return false;
            }
            if (Intrinsics.areEqual((Object)SkyBlockUtils.INSTANCE.getScoreboardArea(), (Object)"Stronghold") && Intrinsics.areEqual((Object)TextCompatKt.formattedTextCompatLessResets(entity.method_5477()), (Object)"Skeleton")) {
                return false;
            }
            boolean isSlayer = slayerType.getClazz().isInstance(entity);
            if (!isSlayer) {
                return false;
            }
            SlayerType slayerType3 = SlayerApi.INSTANCE.getActiveType();
            if (slayerType3 == null) break block5;
            SlayerType it = slayerType3;
            boolean bl = false;
            if (slayerType != it) {
                String activeSlayerName = it.getDisplayName();
                String slayerName = slayerType.getDisplayName();
                SlayerApi.INSTANCE.setLatestWrongAreaWarning-gJLAdNM(SimpleTimeMark.Companion.now-uFjCsEo());
                INSTANCE.warn("Wrong Slayer!", "Wrong slayer selected! You have " + activeSlayerName + " selected and you are in an " + slayerName + " area!");
            }
        }
        return SlayerApi.INSTANCE.getActiveType() == slayerType;
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onItemClick(@NotNull ItemClickEvent event2) {
        NeuInternalName internalName2;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        class_1799 class_17992 = event2.getItemInHand();
        NeuInternalName neuInternalName = internalName2 = class_17992 != null ? ItemUtils.INSTANCE.getInternalNameOrNull(class_17992) : null;
        if (event2.getClickType() == ClickType.RIGHT_CLICK) {
            if (Intrinsics.areEqual((Object)internalName2, (Object)voidItem) || Intrinsics.areEqual((Object)internalName2, (Object)endItem)) {
                return;
            }
            if (internalName2 == null) {
                return;
            }
        }
        lastWeaponUse = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    private static final Unit onSlayerStateChange$lambda$0() {
        if (SlayerApi.INSTANCE.getState() == SlayerApi.ActiveQuestState.SLAIN) {
            INSTANCE.needNewQuest("You have no Auto-Slayer active!");
        }
        return Unit.INSTANCE;
    }

    static {
        lastWarning = SimpleTimeMark.Companion.farPast();
        currentReason = "";
    }
}

