/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001BO\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012<\u0010\u000b\u001a8\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0017J\u0015\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0017J\u000f\u0010\u001f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0010J\u0013\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\u0004\b \u0010!J+\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0018\u00010\"2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010%RJ\u0010\u000b\u001a8\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010&R0\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\n8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010!R$\u0010+\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b+\u0010%\u001a\u0004\b,\u0010-R$\u0010.\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b.\u0010%\u001a\u0004\b/\u0010-R$\u00100\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00118\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103\u00a8\u00064"}, d2={"Lat/hannibal2/skyhanni/utils/ui/CommandSuggestionController;", "", "", "maxVisible", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "text", "cursor", "", "provider", "<init>", "(ILkotlin/jvm/functions/Function2;)V", "", "reset", "()V", "", "enabled", "update", "(Ljava/lang/String;IZ)V", "delta", "navigate", "(I)V", "next", "page", "(Z)V", "i", "select", "dir", "scrollWheel", "ensureIndexVisible", "visibleSlice", "()Ljava/util/List;", "Lkotlin/Pair;", "accept", "(Ljava/lang/String;I)Lkotlin/Pair;", "I", "Lkotlin/jvm/functions/Function2;", "value", "suggestions", "Ljava/util/List;", "getSuggestions", "index", "getIndex", "()I", "scroll", "getScroll", "visible", "Z", "getVisible", "()Z", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nCommandSuggestionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandSuggestionController.kt\nat/hannibal2/skyhanni/utils/ui/CommandSuggestionController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n774#2:86\n865#2,2:87\n1#3:89\n*S KotlinDebug\n*F\n+ 1 CommandSuggestionController.kt\nat/hannibal2/skyhanni/utils/ui/CommandSuggestionController\n*L\n30#1:86\n30#1:87,2\n*E\n"})
public final class CommandSuggestionController {
    private final int maxVisible;
    @NotNull
    private final Function2<String, Integer, List<String>> provider;
    @NotNull
    private List<String> suggestions;
    private int index;
    private int scroll;
    private boolean visible;

    public CommandSuggestionController(int maxVisible, @NotNull Function2<? super String, ? super Integer, ? extends List<String>> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        this.maxVisible = maxVisible;
        this.provider = provider;
        this.suggestions = CollectionsKt.emptyList();
        this.index = -1;
    }

    public /* synthetic */ CommandSuggestionController(int n, Function2 function2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 12;
        }
        this(n, (Function2<? super String, ? super Integer, ? extends List<String>>)function2);
    }

    @NotNull
    public final List<String> getSuggestions() {
        return this.suggestions;
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getScroll() {
        return this.scroll;
    }

    public final boolean getVisible() {
        return this.visible;
    }

    public final void reset() {
        this.suggestions = CollectionsKt.emptyList();
        this.index = -1;
        this.scroll = 0;
        this.visible = false;
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull String text, int cursor, boolean enabled) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!enabled) {
            this.reset();
            return;
        }
        try {
            iterable = (List)this.provider.invoke((Object)text, (Object)cursor);
        }
        catch (Throwable throwable) {
            iterable = CollectionsKt.emptyList();
        }
        List list = iterable;
        iterable = CollectionsKt.distinct((Iterable)list);
        CommandSuggestionController commandSuggestionController = this;
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        commandSuggestionController.suggestions = (List)destination$iv$iv;
        this.index = !((Collection)this.suggestions).isEmpty() ? 0 : -1;
        this.scroll = 0;
        this.visible = !((Collection)this.suggestions).isEmpty();
    }

    public static /* synthetic */ void update$default(CommandSuggestionController commandSuggestionController, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        commandSuggestionController.update(string, n, bl);
    }

    public final void navigate(int delta) {
        if (!this.visible || this.suggestions.isEmpty()) {
            return;
        }
        this.index = RangesKt.coerceIn((int)(this.index + delta), (int)0, (int)CollectionsKt.getLastIndex(this.suggestions));
        this.ensureIndexVisible();
    }

    public final void page(boolean next) {
        if (!this.visible || this.suggestions.isEmpty()) {
            return;
        }
        int step = next ? this.maxVisible : -this.maxVisible;
        this.index = RangesKt.coerceIn((int)(this.index + step), (int)0, (int)CollectionsKt.getLastIndex(this.suggestions));
        this.ensureIndexVisible();
    }

    public final void select(int i2) {
        if (!this.visible || this.suggestions.isEmpty()) {
            return;
        }
        this.index = RangesKt.coerceIn((int)i2, (int)0, (int)CollectionsKt.getLastIndex(this.suggestions));
        this.ensureIndexVisible();
    }

    public final void scrollWheel(int dir) {
        this.navigate(dir);
    }

    private final void ensureIndexVisible() {
        if (this.index < this.scroll) {
            this.scroll = this.index;
        }
        if (this.index >= this.scroll + this.maxVisible) {
            this.scroll = this.index - this.maxVisible + 1;
        }
        this.scroll = RangesKt.coerceIn((int)this.scroll, (int)0, (int)Math.max(0, this.suggestions.size() - this.maxVisible));
    }

    @NotNull
    public final List<String> visibleSlice() {
        return !this.visible ? CollectionsKt.emptyList() : CollectionsKt.take((Iterable)CollectionsKt.drop((Iterable)this.suggestions, (int)this.scroll), (int)this.maxVisible);
    }

    @Nullable
    public final Pair<String, Integer> accept(@NotNull String text, int cursor) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int n = ((Collection)this.suggestions).size();
        int n2 = this.index;
        if (!(0 <= n2 ? n2 < n : false)) {
            return null;
        }
        String chosen = this.suggestions.get(this.index);
        int safeCursor = RangesKt.coerceIn((int)cursor, (int)0, (int)text.length());
        String string = text.substring(0, safeCursor);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        int it = StringsKt.lastIndexOf$default((CharSequence)string, (char)' ', (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        int leftBoundary = it < 0 ? 0 : it + 1;
        String string2 = text.substring(safeCursor);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        int rightIdxLocal = StringsKt.indexOf$default((CharSequence)string2, (char)' ', (int)0, (boolean)false, (int)6, null);
        int rightBoundary = rightIdxLocal < 0 ? text.length() : safeCursor + rightIdxLocal;
        String string3 = text.substring(0, leftBoundary);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String string4 = text.substring(rightBoundary);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String newText = string3 + chosen + string4;
        int newCursor = leftBoundary + chosen.length();
        this.visible = false;
        return new Pair((Object)newText, (Object)newCursor);
    }
}

