/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.InputChunked;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.OutputChunked;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.util.ObjectMap;
import com.esotericsoftware.minlog.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompatibleFieldSerializer<T>
extends FieldSerializer<T> {
    public CompatibleFieldSerializer(Kryo kryo, Class type2) {
        super(kryo, type2);
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        FieldSerializer.CachedField[] fields = this.getFields();
        ObjectMap context2 = kryo.getGraphContext();
        if (!context2.containsKey(this)) {
            context2.put(this, null);
            if (Log.TRACE) {
                Log.trace("kryo", "Write " + fields.length + " field names.");
            }
            output.writeVarInt(fields.length, true);
            int n = fields.length;
            for (int i2 = 0; i2 < n; ++i2) {
                output.writeString(fields[i2].field.getName());
            }
        }
        OutputChunked outputChunked = new OutputChunked(output, 1024);
        int n = fields.length;
        for (int i3 = 0; i3 < n; ++i3) {
            fields[i3].write(outputChunked, object);
            outputChunked.endChunks();
        }
    }

    @Override
    public T read(Kryo kryo, Input input2, Class<T> type2) {
        T object = this.create(kryo, input2, type2);
        kryo.reference(object);
        ObjectMap context2 = kryo.getGraphContext();
        FieldSerializer.CachedField[] fields = (FieldSerializer.CachedField[])context2.get(this);
        if (fields == null) {
            int length = input2.readVarInt(true);
            if (Log.TRACE) {
                Log.trace("kryo", "Read " + length + " field names.");
            }
            String[] names = new String[length];
            for (int i2 = 0; i2 < length; ++i2) {
                names[i2] = input2.readString();
            }
            fields = new FieldSerializer.CachedField[length];
            FieldSerializer.CachedField[] allFields = this.getFields();
            block1: for (String schemaName : names) {
                int nn = allFields.length;
                for (int ii = 0; ii < nn; ++ii) {
                    if (!allFields[ii].field.getName().equals(schemaName)) continue;
                    fields[i] = allFields[ii];
                    continue block1;
                }
                if (!Log.TRACE) continue;
                Log.trace("kryo", "Ignore obsolete field: " + schemaName);
            }
            context2.put(this, fields);
        }
        InputChunked inputChunked = new InputChunked(input2, 1024);
        boolean hasGenerics = this.getGenerics() != null;
        for (FieldSerializer.CachedField cachedField : fields) {
            if (cachedField != null && hasGenerics) {
                cachedField = this.getField(cachedField.field.getName());
            }
            if (cachedField == null) {
                if (Log.TRACE) {
                    Log.trace("kryo", "Skip obsolete field.");
                }
                inputChunked.nextChunks();
                continue;
            }
            cachedField.read(inputChunked, object);
            inputChunked.nextChunks();
        }
        return object;
    }
}

