/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.jsonbeans.Json;
import com.esotericsoftware.jsonbeans.JsonException;
import com.esotericsoftware.kryo.io.ByteBufferInputStream;
import com.esotericsoftware.kryo.io.ByteBufferOutputStream;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.Serialization;
import com.esotericsoftware.minlog.Log;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;

public class JsonSerialization
implements Serialization {
    private final Json json = new Json();
    private final ByteBufferInputStream byteBufferInputStream = new ByteBufferInputStream();
    private final ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream();
    private final OutputStreamWriter writer = new OutputStreamWriter(this.byteBufferOutputStream);
    private boolean logging = true;
    private boolean prettyPrint = true;
    private byte[] logBuffer = new byte[0];

    public JsonSerialization() {
        this.json.addClassTag("RegisterTCP", FrameworkMessage.RegisterTCP.class);
        this.json.addClassTag("RegisterUDP", FrameworkMessage.RegisterUDP.class);
        this.json.addClassTag("KeepAlive", FrameworkMessage.KeepAlive.class);
        this.json.addClassTag("DiscoverHost", FrameworkMessage.DiscoverHost.class);
        this.json.addClassTag("Ping", FrameworkMessage.Ping.class);
        this.json.setWriter(this.writer);
    }

    public void setLogging(boolean logging, boolean prettyPrint) {
        this.logging = logging;
        this.prettyPrint = prettyPrint;
    }

    public void write(Connection connection, ByteBuffer buffer, Object object) {
        this.byteBufferOutputStream.setByteBuffer(buffer);
        int start2 = buffer.position();
        try {
            this.json.writeValue(object, Object.class, null);
            this.writer.flush();
        }
        catch (Exception ex) {
            throw new JsonException("Error writing object: " + object, ex);
        }
        if (Log.INFO && this.logging) {
            int end = buffer.position();
            buffer.position(start2);
            buffer.limit(end);
            int length = end - start2;
            if (this.logBuffer.length < length) {
                this.logBuffer = new byte[length];
            }
            buffer.get(this.logBuffer, 0, length);
            buffer.position(end);
            buffer.limit(buffer.capacity());
            String message = new String(this.logBuffer, 0, length);
            if (this.prettyPrint) {
                message = this.json.prettyPrint(message);
            }
            Log.info("Wrote: " + message);
        }
    }

    public Object read(Connection connection, ByteBuffer buffer) {
        this.byteBufferInputStream.setByteBuffer(buffer);
        return this.json.fromJson(Object.class, this.byteBufferInputStream);
    }

    public void writeLength(ByteBuffer buffer, int length) {
        buffer.putInt(length);
    }

    public int readLength(ByteBuffer buffer) {
        return buffer.getInt();
    }

    public int getLengthLength() {
        return 4;
    }
}

