package at.hannibal2.skyhanni.config.features.inventory

import at.hannibal2.skyhanni.config.FeatureToggle
import at.hannibal2.skyhanni.utils.LorenzColor
import com.google.gson.annotations.Expose
import io.github.notenoughupdates.moulconfig.ChromaColour
import io.github.notenoughupdates.moulconfig.annotations.Accordion
import io.github.notenoughupdates.moulconfig.annotations.ConfigEditorBoolean
import io.github.notenoughupdates.moulconfig.annotations.ConfigEditorColour
import io.github.notenoughupdates.moulconfig.annotations.ConfigEditorKeybind
import io.github.notenoughupdates.moulconfig.annotations.ConfigOption
import org.lwjgl.input.Keyboard

class AuctionHouseConfig {
    @Expose
    @ConfigOption(name = "Auctions Price Comparison", desc = "")
    @Accordion
    val auctionsPriceComparison: AuctionHousePriceComparisonConfig = AuctionHousePriceComparisonConfig()

    @Expose
    @ConfigOption(
        name = "Highlight Auctions",
        desc = "Highlight own items that are sold in green and that are expired in red.",
    )
    @ConfigEditorBoolean
    @FeatureToggle
    var highlightAuctions: Boolean = true

    @Expose
    @ConfigOption(name = "Sold Color", desc = "Color of sold items.")
    @ConfigEditorColour
    var soldColor: ChromaColour = LorenzColor.GREEN.toChromaColor(255)

    @Expose
    @ConfigOption(name = "Expired Color", desc = "Color of expired items.")
    @ConfigEditorColour
    var expiredColor: ChromaColour = LorenzColor.RED.toChromaColor(255)

    @Expose
    @ConfigOption(
        name = "Highlight Underbid Auctions",
        desc = "Highlight underbid own lowest BIN auctions that are outbid.",
    )
    @ConfigEditorBoolean
    @FeatureToggle
    var highlightAuctionsUnderbid: Boolean = false

    @Expose
    @ConfigOption(name = "Underbid Color", desc = "Color of underbid BIN items.")
    @ConfigEditorColour
    var underbidColor: ChromaColour = LorenzColor.GOLD.toChromaColor(255)

    @Expose
    @ConfigOption(
        name = "Auto Copy Underbid",
        desc = "Automatically copies the price of an item in the \"Create BIN Auction\"" +
            " minus 1 coin into the clipboard for faster under-bidding.",
    )
    @ConfigEditorBoolean
    @FeatureToggle
    var autoCopyUnderbidPrice: Boolean = false

    @Expose
    @ConfigOption(
        name = "Copy Underbid Keybind",
        desc = "Copy the price of the hovered item in Auction House minus 1 coin into the clipboard for easier under-bidding.",
    )
    @ConfigEditorKeybind(defaultKey = Keyboard.KEY_NONE)
    var copyUnderbidKeybind: Int = Keyboard.KEY_NONE

    @Expose
    @ConfigOption(
        name = "Price Website",
        desc = "Add a button to the Auction House that will open the item page in §csky.coflnet.com§7.",
    )
    @ConfigEditorBoolean
    @FeatureToggle
    var openPriceWebsite: Boolean = false

    @Expose
    @ConfigOption(name = "Outbid alert", desc = "Send a warning when you're outbid on an auction.")
    @ConfigEditorBoolean
    @FeatureToggle
    var auctionOutbid: Boolean = false
}
