package at.hannibal2.skyhanni.config.storage

import at.hannibal2.skyhanni.features.bingo.card.goals.BingoGoal
import at.hannibal2.skyhanni.features.chat.CurrentChatDisplay
import at.hannibal2.skyhanni.features.fame.UpgradeReminder.CommunityShopUpgrade
import at.hannibal2.skyhanni.features.misc.UserLuckBreakdown
import at.hannibal2.skyhanni.utils.NeuInternalName
import at.hannibal2.skyhanni.utils.SimpleTimeMark
import at.hannibal2.skyhanni.utils.SimpleTimeMark.Companion.farPast
import com.google.gson.annotations.Expose
import java.time.LocalDate

class PlayerSpecificStorage {
    @Expose
    var profiles: MutableMap<String, ProfileSpecificStorage> = mutableMapOf() // profile name

    @Expose
    var multipleProfiles: Boolean = false

    @Expose
    var useRomanNumerals: Boolean = true

    @Expose
    var gardenCommunityUpgrade: Int = -1

    @Expose
    var fameRank: String = "New Player"

    @Expose
    var currentChat: CurrentChatDisplay.ChatType? = null

    @Expose
    var nextCityProjectParticipationTime: SimpleTimeMark = farPast()

    @Expose
    var communityShopAccountUpgrade: CommunityShopUpgrade? = null

    @Expose
    var guildMembers: MutableList<String> = mutableListOf()

    @Expose
    var bazaar: BazaarStorage = BazaarStorage()

    class BazaarStorage {
        @Expose
        var taxRate: Double = 1.25

        @Expose
        var coinsTowardsLimit: Double = 0.0

        @Expose
        var lastAccessedDay: LocalDate? = null
    }

    @Expose
    var winter: WinterStorage = WinterStorage()

    class WinterStorage {
        @Expose
        var playersThatHaveBeenGifted: MutableSet<String> = mutableSetOf()

        @Expose
        var amountGifted: Int = 0

        @Expose
        var cakeCollectedYear: Int = 0
    }

    @Expose
    var bingoSessions: MutableMap<Long, BingoSession> = mutableMapOf()

    class BingoSession {
        @Expose
        var tierOneMinionsDone: MutableSet<NeuInternalName> = mutableSetOf()

        @Expose
        var goals: MutableMap<Int, BingoGoal> = mutableMapOf()
    }

    @Expose
    var limbo: LimboStats = LimboStats()

    class LimboStats {
        @Expose
        var playtime: Int = 0

        @Expose
        var personalBest: Int = 0

        /**
         * Do NOT use if you are trying to get the players total user luck
         *
         * @see UserLuckBreakdown.getTotalUserLuck
         */
        @Expose
        var userLuck: Float = 0f
    }
}
