package at.hannibal2.skyhanni.data

import at.hannibal2.skyhanni.api.event.HandleEvent
import at.hannibal2.skyhanni.events.GuiRenderEvent
import at.hannibal2.skyhanni.events.render.gui.DrawBackgroundEvent
import at.hannibal2.skyhanni.features.misc.visualwords.VisualWordGui
import at.hannibal2.skyhanni.skyhannimodule.SkyHanniModule
import at.hannibal2.skyhanni.utils.compat.DrawContext
import at.hannibal2.skyhanni.utils.compat.DrawContextUtils
import net.minecraft.client.Minecraft
import net.minecraft.client.gui.GuiChat
import net.minecraft.client.gui.inventory.GuiChest
import net.minecraft.client.gui.inventory.GuiInventory
import net.minecraft.client.renderer.GlStateManager

@SkyHanniModule
object RenderData {

    @JvmStatic
    fun postRenderOverlay(context: DrawContext) {
        if (GlobalRender.renderDisabled) return
        if (GuiEditManager.isInGui() || VisualWordGui.isInGui()) return
        val screen = Minecraft.getMinecraft().currentScreen

        DrawContextUtils.setContext(context)
        DrawContextUtils.translated(z = -3) {
            renderOverlay(DrawContextUtils.drawContext, screen != null && screen !is GuiChat)
        }
        DrawContextUtils.clearContext()
    }

    @HandleEvent
    fun onBackgroundDraw(event: DrawBackgroundEvent) {
        if (GlobalRender.renderDisabled) return
        if (GuiEditManager.isInGui() || VisualWordGui.isInGui()) return
        val currentScreen = Minecraft.getMinecraft().currentScreen ?: return
        if (currentScreen !is GuiInventory && currentScreen !is GuiChest) return

        DrawContextUtils.pushPop {
            GlStateManager.enableDepth()

            if (GuiEditManager.isInGui()) {
                DrawContextUtils.translated(z = -3) {
                    renderOverlay(DrawContextUtils.drawContext, true)
                }
            }
        }

        GuiRenderEvent.ChestGuiOverlayRenderEvent(DrawContextUtils.drawContext).post()
        GuiRenderEvent.GuiOnTopRenderEvent(DrawContextUtils.drawContext).post()
    }

    var outsideInventory = false

    fun renderOverlay(context: DrawContext, inventoryPresent: Boolean = false) {
        outsideInventory = true
        GuiRenderEvent.GuiOverlayRenderEvent(context).post()
        if (!inventoryPresent) GuiRenderEvent.GuiOnTopRenderEvent(context).post()
        outsideInventory = false
    }
}
