package at.hannibal2.skyhanni.events

import at.hannibal2.skyhanni.api.event.SkyHanniEvent
import at.hannibal2.skyhanni.data.HypixelData
import at.hannibal2.skyhanni.data.jsonobjects.other.HypixelPlayerApiJson
import at.hannibal2.skyhanni.utils.PlayerUtils

class NeuProfileDataLoadedEvent(val playerData: HypixelPlayerApiJson) : SkyHanniEvent() {
    fun getCurrentProfileData() =
        playerData.profiles.firstOrNull { it.profileName.equals(HypixelData.profileName, ignoreCase = true) }

    fun getCurrentPlayerData() = getCurrentProfileData()?.members?.get(PlayerUtils.getUuid())
}
