package at.hannibal2.skyhanni.features.garden

import at.hannibal2.skyhanni.api.ReforgeApi
import at.hannibal2.skyhanni.api.event.HandleEvent
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator
import at.hannibal2.skyhanni.config.features.garden.TooltipTweaksConfig.CropTooltipFortuneEntry
import at.hannibal2.skyhanni.events.minecraft.ToolTipEvent
import at.hannibal2.skyhanni.features.garden.FarmingFortuneDisplay.getAbilityFortune
import at.hannibal2.skyhanni.features.garden.GardenApi.getCropType
import at.hannibal2.skyhanni.features.garden.fortuneguide.FFGuideGui
import at.hannibal2.skyhanni.skyhannimodule.SkyHanniModule
import at.hannibal2.skyhanni.utils.ItemUtils.getInternalName
import at.hannibal2.skyhanni.utils.ItemUtils.getLore
import at.hannibal2.skyhanni.utils.KeyboardManager.isKeyHeld
import at.hannibal2.skyhanni.utils.RegexUtils.find
import at.hannibal2.skyhanni.utils.SkyBlockItemModifierUtils.getFarmingForDummiesCount
import at.hannibal2.skyhanni.utils.SkyBlockItemModifierUtils.getReforgeModifier
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern
import java.text.DecimalFormat
import kotlin.math.roundToInt

@SkyHanniModule
object ToolTooltipTweaks {

    private val config get() = GardenApi.config.tooltipTweak

    /**
     * REGEX-TEST: §7Farming Fortune: §6+88.5 §9(+8)
     * REGEX-TEST: §7Farming Fortune: §6+73 §9(+30) §d(+8)
     */
    private val farmingFortunePattern by RepoPattern.pattern(
        "garden.tooltip.farmingfortune",
        "§7Farming Fortune: §6",
    )

    private val counterStartLine = setOf("§6Logarithmic Counter", "§6Collection Analysis")
    private val reforgeEndLine = setOf("", "§7chance for multiple crops.")
    private const val ABILITY_DESCRIPTION_START = "§7These boots gain §a+2❈ Defense"
    private const val ABILITY_DESCRIPTION_END = "§7Skill level."

    private val statFormatter = DecimalFormat("0.##")

    @HandleEvent(onlyOnSkyblock = true)
    fun onToolTip(event: ToolTipEvent) {
        val itemStack = event.itemStack
        val itemLore = itemStack.getLore()
        val internalName = itemStack.getInternalName()
        val crop = itemStack.getCropType()
        val toolFortune = FarmingFortuneDisplay.getToolFortune(internalName)
        val counterFortune = FarmingFortuneDisplay.getCounterFortune(itemStack)
        val collectionFortune = FarmingFortuneDisplay.getCollectionFortune(itemStack)
        val turboCropFortune = FarmingFortuneDisplay.getTurboCropFortune(itemStack, crop)
        val dedicationFortune = FarmingFortuneDisplay.getDedicationFortune(itemStack, crop)

        val reforgeName = itemStack.getReforgeModifier()?.let { modifier ->
            ReforgeApi.reforges.firstOrNull { it.nbtModifier == modifier }?.name
        }

        val sunderFortune = FarmingFortuneDisplay.getSunderFortune(itemStack)
        val harvestingFortune = FarmingFortuneDisplay.getHarvestingFortune(itemStack)
        val cultivatingFortune = FarmingFortuneDisplay.getCultivatingFortune(itemStack)
        val abilityFortune = getAbilityFortune(internalName, itemLore)

        val ffdFortune = itemStack.getFarmingForDummiesCount() ?: 0
        val hiddenFortune =
            (toolFortune + counterFortune + collectionFortune + turboCropFortune + dedicationFortune + abilityFortune)
        val iterator = event.toolTip.listIterator()

        var removingFarmhandDescription = false
        var removingCounterDescription = false
        var removingReforgeDescription = false
        var removingAbilityDescription = false

        for (originalLine in iterator) {
            val line = originalLine.removePrefix("§5§o")
            if (farmingFortunePattern.find(line)) {
                val enchantmentFortune = sunderFortune + harvestingFortune + cultivatingFortune

                FarmingFortuneDisplay.loadFortuneLineData(itemStack, enchantmentFortune)

                val displayedFortune = FarmingFortuneDisplay.displayedFortune
                val reforgeFortune = FarmingFortuneDisplay.reforgeFortune
                val gemstoneFortune = FarmingFortuneDisplay.gemstoneFortune
                val baseFortune = FarmingFortuneDisplay.itemBaseFortune
                val greenThumbFortune = FarmingFortuneDisplay.greenThumbFortune
                val pesterminatorFortune = FarmingFortuneDisplay.pesterminatorFortune

                val totalFortune = displayedFortune + hiddenFortune

                val ffdString = if (ffdFortune != 0) " §2(+${ffdFortune.formatStat()})" else ""
                val reforgeString = if (reforgeFortune != 0.0) " §9(+${reforgeFortune.formatStat()})" else ""
                val cropString = if (hiddenFortune != 0.0) " §6[+${hiddenFortune.roundToInt()}]" else ""

                val fortuneLine = when (config.cropTooltipFortune) {
                    CropTooltipFortuneEntry.DEFAULT ->
                        "§7Farming Fortune: §6+${displayedFortune.formatStat()}$ffdString$reforgeString"

                    CropTooltipFortuneEntry.SHOW ->
                        "§7Farming Fortune: §6+${displayedFortune.formatStat()}$ffdString$reforgeString$cropString"

                    else ->
                        "§7Farming Fortune: §6+${totalFortune.formatStat()}$ffdString$reforgeString$cropString"
                }
                iterator.set(fortuneLine)

                if (config.fortuneTooltipKeybind.isKeyHeld()) {
                    iterator.addStat("  §7Base: §6+", baseFortune)
                    iterator.addStat("  §7Tool: §6+", toolFortune)
                    iterator.addStat("  §7${reforgeName ?: "Reforge"}: §9+", reforgeFortune)
                    iterator.addStat("  §7Gemstone: §d+", gemstoneFortune)
                    iterator.addStat("  §7Ability: §2+", abilityFortune)
                    iterator.addStat("  §7Green Thumb: §a+", greenThumbFortune)
                    iterator.addStat("  §7Pesterminator: §a+", pesterminatorFortune)
                    iterator.addStat("  §7Sunder: §a+", sunderFortune)
                    iterator.addStat("  §7Harvesting: §a+", harvestingFortune)
                    iterator.addStat("  §7Cultivating: §a+", cultivatingFortune)
                    iterator.addStat("  §7Farming for Dummies: §2+", ffdFortune)
                    iterator.addStat("  §7Counter: §6+", counterFortune)
                    iterator.addStat("  §7Collection: §6+", collectionFortune)
                    iterator.addStat("  §7Dedication: §6+", dedicationFortune)
                    iterator.addStat("  §7Turbo-Crop: §6+", turboCropFortune)
                }
            }
            // Beware, dubious control flow beyond these lines
            if (config.compactToolTooltips || FFGuideGui.isInGui()) {
                if (line.startsWith("§7§8Bonus ")) removingFarmhandDescription = true
                if (removingFarmhandDescription) {
                    iterator.remove()
                    removingFarmhandDescription = line != ""
                } else if (removingCounterDescription && !line.startsWith("§7You have")) {
                    iterator.remove()
                } else {
                    removingCounterDescription = false
                }
                if (counterStartLine.contains(line)) removingCounterDescription = true

                if (line == "§9Blessed Bonus") removingReforgeDescription = true
                if (removingReforgeDescription) {
                    iterator.remove()
                    removingReforgeDescription = !reforgeEndLine.contains(line)
                }
                if (line == "§9Bountiful Bonus") removingReforgeDescription = true

                if (FFGuideGui.isInGui()) {
                    if (line.contains("Click to ") || line.contains("§7§8This item can be reforged!") || line.contains("Dyed")) {
                        iterator.remove()
                    }

                    if (line == ABILITY_DESCRIPTION_START) {
                        removingAbilityDescription = true
                    }
                    if (removingAbilityDescription) {
                        iterator.remove()
                        if (line == ABILITY_DESCRIPTION_END) {
                            removingAbilityDescription = false
                        }
                    }
                }
            }
        }
    }

    private fun Number.formatStat() = statFormatter.format(this)

    private fun MutableListIterator<String>.addStat(description: String, value: Number) {
        if (value.toDouble() != 0.0) {
            add("$description${value.formatStat()}")
        }
    }

    @HandleEvent
    fun onConfigFix(event: ConfigUpdaterMigrator.ConfigFixEvent) {
        event.move(3, "garden.compactToolTooltips", "garden.tooltipTweak.compactToolTooltips")
        event.move(3, "garden.fortuneTooltipKeybind", "garden.tooltipTweak.fortuneTooltipKeybind")
        event.move(3, "garden.cropTooltipFortune", "garden.tooltipTweak.cropTooltipFortune")
    }
}
