package at.hannibal2.skyhanni.mixins.transformers;

import at.hannibal2.skyhanni.mixins.hooks.GuiPlayerTabOverlayHookKt;
import net.minecraft.client.gui.GuiPlayerTabOverlay;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.scoreboard.ScorePlayerTeam;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;


@Mixin(GuiPlayerTabOverlay.class)
public class MixinGuiPlayerTabOverlay {

    @Inject(method = "getPlayerName", at = @At(value = "HEAD"), cancellable = true)
    private void renderItemOverlayPost(NetworkPlayerInfo info, CallbackInfoReturnable<String> cir) {
        String text;
        if (info.func_178854_k() != null) {
            text = info.func_178854_k().func_150254_d();
        } else {
            text = ScorePlayerTeam.func_96667_a(info.func_178850_i(), info.func_178845_a().getName());
        }
        GuiPlayerTabOverlayHookKt.getPlayerName(text, cir);
    }
}
