package at.hannibal2.skyhanni.utils.repopatterns

import at.hannibal2.skyhanni.utils.KSerializable

/**
 * A class containing a dump of all regexes that are defined using [RepoPattern].
 *
 * # Generating a dump
 * This dump is generated by the `.github/workflows/generate-constants.yaml` using the gradle task `generateRepoPatterns`.
 * Said gradle task then launches Minecraft headless with environment variables set so that [RepoPatternManager.onPreInitFinished]
 * calls [RepoPatternManager.dump] and closes afterward. The GitHub action then looks at the current branch and repo,
 * and if it finds itself to be running on hannibal002/SkyHanni:beta, it commits that generated dump to the SkyHanni REPO.
 *
 * # Using the dump
 * All clients upon launching will then look at that dump generated by the latest beta version, even if they themselves
 * run an older SkyHanni version. The regexes generated by the dump will then take precedence over the ones found in the
 * running JAR.
 *
 * # Setting up the `generate-constants.yaml` workflow
 * The GitHub action workflow needs to be configured properly. For that it needs to have the
 * `env.data_repo` key adjusted to be the live repo.
 * It also needs a [repository GitHub action secret](https://github.com/nea89o/SkyHanni/settings/secrets/actions)
 * called `REPO_PAT`, which contains a [personal access token](https://github.com/settings/tokens/new) with repo write
 * access to the live repo.
 */
@KSerializable
data class RepoPatternDump(
    val sourceLabel: String = "anonymous",
    val regexes: Map<String, String> = mapOf(),
)
