/*
 * Decompiled with CFR 0.152.
 */
package net.apiocraft.acdrones.entities;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.util.ComponentMap;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.NonNegativeId;
import eu.pb4.common.protection.api.CommonProtection;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import net.apiocraft.acdrones.Acdrones;
import net.apiocraft.acdrones.accessories.simpleAccessories.chunkloader.DroneChunkloaderAccessory;
import net.apiocraft.acdrones.core.DroneBrain;
import net.apiocraft.acdrones.core.IDroneAccessory;
import net.apiocraft.acdrones.inventory.AccessoryInventory;
import net.apiocraft.acdrones.inventory.AttachmentInventory;
import net.apiocraft.acdrones.inventory.DroneInventory;
import net.apiocraft.acdrones.menu.DroneMenu;
import net.apiocraft.acdrones.registries.DroneAccessoryRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3908;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ComputerDroneEntity
extends class_1297
implements class_3908 {
    public static final int INVENTORY_SIZE = 4;
    private static final String NBT_LABEL = "Label";
    private static final String NBT_ON = "On";
    private static final String NBT_ID = "ComputerId";
    private static final String NBT_HOVERING = "Hovering";
    private static final String NBT_SELECTED_SLOT = "SelectedSlot";
    private static final String NBT_ACCESSORY = "Accessory";
    private static final String NBT_OWNER = "Owner";
    private static final class_2940<Boolean> on = class_2945.method_12791(ComputerDroneEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<IDroneAccessory>> accessory = class_2945.method_12791(ComputerDroneEntity.class, Acdrones.DRONE_ACCESSORY_HANDLER);
    private static final class_2940<Optional<IDroneAccessory>> attachment_1 = class_2945.method_12791(ComputerDroneEntity.class, Acdrones.DRONE_ACCESSORY_HANDLER);
    private static final class_2940<Optional<IDroneAccessory>> attachment_2 = class_2945.method_12791(ComputerDroneEntity.class, Acdrones.DRONE_ACCESSORY_HANDLER);
    private final DroneInventory inventory;
    private final AccessoryInventory accessoryInventory;
    private final AttachmentInventory attachmentInventory;
    private final DroneBrain brain;
    public boolean hovering = false;
    @Nullable
    protected String label = null;
    private UUID owner;
    private class_1923 lastChunkPos;
    private int computerId = -1;
    private boolean startByTurningTheHellOn = false;
    private UUID instanceID;
    private boolean itsBrandNew;
    private int selectedSlot = 0;
    private class_243 lastVelocity = class_243.field_1353;

    public ComputerDroneEntity(class_1299<? extends ComputerDroneEntity> type, class_1937 world) {
        super(type, world);
        this.brain = new DroneBrain(this);
        this.inventory = new DroneInventory(this);
        this.accessoryInventory = new AccessoryInventory(this.brain);
        this.attachmentInventory = new AttachmentInventory(this.brain);
    }

    public static class_5132.class_5133 createComputerDroneAttributes() {
        return class_5132.method_26861().method_26867(class_5134.field_23716).method_26867(class_5134.field_23718).method_26867(class_5134.field_23719).method_26867(class_5134.field_23724).method_26867(class_5134.field_23725).method_26867(class_5134.field_45124).method_26867(class_5134.field_47761).method_26867(class_5134.field_47760).method_26867(class_5134.field_49078).method_26867(class_5134.field_49079).method_26867(class_5134.field_49077).method_26867(class_5134.field_23728).method_26867(class_5134.field_51583).method_26867(class_5134.field_51579).method_26867(class_5134.field_51580).method_26867(class_5134.field_51578).method_26867(class_5134.field_51582).method_26867(class_5134.field_23722);
    }

    public static float lerpDegrees(float start, float end, float amount) {
        float difference = Math.abs(end - start);
        if (difference > 180.0f) {
            if (end > start) {
                start += 360.0f;
            } else {
                end += 360.0f;
            }
        }
        float value = start + (end - start) * amount;
        float rangeZero = 360.0f;
        if (value >= 0.0f && value <= 360.0f) {
            return value;
        }
        return value % rangeZero;
    }

    protected double method_7490() {
        return 0.08;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608() && Arrays.stream(this.getAccessoryAttachments()).anyMatch(a -> a instanceof DroneChunkloaderAccessory)) {
            class_3218 serverWorld = (class_3218)this.method_37908();
            class_1923 chunkPos = new class_1923(this.method_24515());
            if (!chunkPos.equals((Object)this.lastChunkPos)) {
                System.out.println("Supposedly loading chunk");
                serverWorld.method_14178().method_17297(class_3230.field_14031, chunkPos, 3, (Object)chunkPos);
                if (this.lastChunkPos != null) {
                    serverWorld.method_14178().method_17300(class_3230.field_14031, this.lastChunkPos, 3, (Object)this.lastChunkPos);
                }
                this.lastChunkPos = chunkPos;
            }
        }
        class_243 movement = this.method_60478();
        this.method_5784(class_1313.field_6308, movement);
        this.updateDirection();
        if (!this.method_37908().method_8608()) {
            ServerComputer computer = this.createServerComputer();
            if (this.itsBrandNew || this.startByTurningTheHellOn && !((Boolean)this.field_6011.method_12789(on)).booleanValue()) {
                this.createServerComputer().turnOn();
                this.itsBrandNew = false;
                this.startByTurningTheHellOn = false;
            }
            this.method_5875(computer.isOn());
            this.method_56990();
            this.method_18799(this.method_18798().method_18805(0.9, 0.9, 0.9));
            computer.keepAlive();
            this.itsBrandNew = false;
            this.computerId = computer.getID();
            this.field_6011.method_12778(on, (Object)computer.isOn());
            if (this.label != computer.getLabel()) {
                this.label = computer.getLabel();
            }
            this.brain.update();
        }
    }

    private void updateDirection() {
        class_243 vel = this.method_18798();
        class_243 deltaVel = vel.method_1020(this.lastVelocity);
        double targetYaw = Math.toDegrees(Math.atan2(-vel.method_10216(), vel.method_10215()));
        targetYaw = (float)targetYaw;
        double horizontalSpeed = Math.sqrt(vel.method_10216() * vel.method_10216() + vel.method_10215() * vel.method_10215());
        double horizontalDeltaSpeed = Math.sqrt(deltaVel.method_10216() * deltaVel.method_10216() + deltaVel.method_10215() * deltaVel.method_10215());
        double velocityWeight = 1.0;
        double deltaVelocityWeight = 0.0;
        double pitchFactor = horizontalSpeed * velocityWeight + horizontalDeltaSpeed * deltaVelocityWeight;
        double targetPitch = -Math.toDegrees(Math.atan(pitchFactor)) * 1.5;
        float currentYaw = this.method_36454();
        float currentPitch = this.method_36455();
        if (horizontalSpeed > 0.01) {
            float newYaw = ComputerDroneEntity.lerpDegrees(currentYaw, (float)targetYaw, 0.25f);
            this.method_36456(newYaw);
        }
        float newPitch = ComputerDroneEntity.lerpDegrees(currentPitch, (float)targetPitch, 0.25f);
        this.method_36457(newPitch);
        this.lastVelocity = new class_243(vel.method_10216(), vel.method_10214(), vel.method_10215());
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        System.out.println("Interacting with drone");
        if (player.method_5715()) {
            if (!this.method_37908().method_8608() && CommonProtection.canInteractEntity((class_1937)this.method_37908(), (class_1297)this, (GameProfile)player.method_7334(), (class_1657)player)) {
                System.out.println("not on client, so we turn on and open gui");
                ServerComputer serverComputer = this.createServerComputer();
                serverComputer.turnOn();
                new ComputerContainerData(serverComputer, class_1799.field_8037).open(player, (class_3908)this);
            }
            return class_1269.field_5812;
        }
        System.out.println("not sneaking");
        if (player.method_5765()) {
            if (!this.method_37908().method_8608()) {
                ServerComputer serverComputer = this.createServerComputer();
                serverComputer.turnOn();
                new ComputerContainerData(serverComputer, class_1799.field_8037).open(player, (class_3908)this);
            }
            return class_1269.field_5812;
        }
        player.method_5804((class_1297)this);
        return class_1269.field_5812;
    }

    public boolean method_5732() {
        return true;
    }

    public boolean method_5698(class_1297 attacker) {
        class_1657 player;
        if (attacker instanceof class_1657 && !this.method_37908().method_8608() && attacker instanceof class_1657 && ((player = (class_1657)attacker).method_5667().equals(this.owner) || CommonProtection.canInteractEntity((class_1937)this.method_37908(), (class_1297)this, (GameProfile)player.method_7334(), (class_1657)player))) {
            class_1264.method_5451((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_1263)this.getInventory());
            class_1264.method_5451((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_1263)this.getAccessoryInventory());
            class_1799 i = new class_1799((class_1935)Acdrones.COMPUTER_DRONE_ITEM);
            i.method_57379((class_9331)ModRegistry.DataComponents.COMPUTER_ID.get(), (Object)NonNegativeId.of((int)this.computerId));
            class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_24515().method_10263(), (double)(this.method_24515().method_10264() + 1), (double)this.method_24515().method_10260(), (class_1799)i);
            this.method_5650(class_1297.class_5529.field_26998);
        }
        return true;
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        if (!this.method_37908().method_8608() && this.lastChunkPos != null) {
            ((class_3218)this.method_37908()).method_14178().method_17300(class_3230.field_14033, this.lastChunkPos, 1, (Object)this.lastChunkPos);
        }
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5863() {
        return true;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(on, (Object)false);
        builder.method_56912(accessory, Optional.empty());
        builder.method_56912(attachment_1, Optional.empty());
        builder.method_56912(attachment_2, Optional.empty());
    }

    protected void method_5749(class_2487 nbt) {
        class_2499 list = nbt.method_10554("Inventory", 10);
        this.inventory.readNbt(list);
        this.computerId = nbt.method_10545(NBT_ID) ? nbt.method_10550(NBT_ID) : -1;
        this.label = nbt.method_10545(NBT_LABEL) ? nbt.method_10558(NBT_LABEL) : null;
        this.startByTurningTheHellOn = nbt.method_10545(NBT_ON) && nbt.method_10577(NBT_ON);
        this.field_6011.method_12778(on, (Object)this.startByTurningTheHellOn);
        this.hovering = nbt.method_10545(NBT_HOVERING) && nbt.method_10577(NBT_HOVERING);
        this.selectedSlot = nbt.method_10545(NBT_SELECTED_SLOT) ? nbt.method_10550(NBT_SELECTED_SLOT) : 0;
        this.field_6011.method_12778(accessory, nbt.method_10545(NBT_ACCESSORY) ? Optional.of(DroneAccessoryRegistry.createFromNbt(nbt.method_10562(NBT_ACCESSORY))) : Optional.empty());
        if (((Optional)this.field_6011.method_12789(accessory)).isPresent()) {
            this.getAccessory().setDrone(this.brain);
        }
        this.field_6011.method_12778(attachment_1, nbt.method_10545("Attachment1") ? Optional.of(DroneAccessoryRegistry.createFromNbt(nbt.method_10562("Attachment1"))) : Optional.empty());
        if (((Optional)this.field_6011.method_12789(attachment_1)).isPresent()) {
            this.getAccessoryAttachment(0).setDrone(this.brain);
        }
        this.field_6011.method_12778(attachment_2, nbt.method_10545("Attachment2") ? Optional.of(DroneAccessoryRegistry.createFromNbt(nbt.method_10562("Attachment2"))) : Optional.empty());
        if (((Optional)this.field_6011.method_12789(attachment_2)).isPresent()) {
            this.getAccessoryAttachment(1).setDrone(this.brain);
        }
        this.owner = nbt.method_10545(NBT_OWNER) ? nbt.method_25926(NBT_OWNER) : null;
    }

    protected void method_5652(class_2487 nbt) {
        class_2487 accessoryNbt;
        class_2499 list = this.inventory.writeNbt(new class_2499());
        nbt.method_10566("Inventory", (class_2520)list);
        if (this.computerId >= 0) {
            nbt.method_10569(NBT_ID, this.computerId);
        }
        if (this.label != null) {
            nbt.method_10582(NBT_LABEL, this.label);
        }
        if (((Boolean)this.field_6011.method_12789(on)).booleanValue()) {
            nbt.method_10556(NBT_ON, true);
        }
        if (this.hovering) {
            nbt.method_10556(NBT_HOVERING, true);
        }
        if (((Optional)this.field_6011.method_12789(accessory)).isPresent()) {
            accessoryNbt = this.getAccessory().toNbt();
            accessoryNbt.method_10582("id", DroneAccessoryRegistry.getId(this.getAccessory()).toString());
            nbt.method_10566(NBT_ACCESSORY, (class_2520)accessoryNbt);
        }
        if (((Optional)this.field_6011.method_12789(attachment_1)).isPresent()) {
            accessoryNbt = this.getAccessoryAttachment(0).toNbt();
            accessoryNbt.method_10582("id", DroneAccessoryRegistry.getId(this.getAccessoryAttachment(0)).toString());
            nbt.method_10566("Attachment1", (class_2520)accessoryNbt);
        }
        if (((Optional)this.field_6011.method_12789(attachment_2)).isPresent()) {
            accessoryNbt = this.getAccessoryAttachment(1).toNbt();
            accessoryNbt.method_10582("id", DroneAccessoryRegistry.getId(this.getAccessoryAttachment(1)).toString());
            nbt.method_10566("Attachment2", (class_2520)accessoryNbt);
        }
        nbt.method_10569(NBT_SELECTED_SLOT, this.selectedSlot);
        if (this.owner != null) {
            nbt.method_25927(NBT_OWNER, this.owner);
        }
    }

    public final ServerComputer createServerComputer() {
        MinecraftServer server = this.method_37908().method_8503();
        if (server == null) {
            throw new IllegalStateException("Cannot access server computer on the client.");
        }
        boolean changed = false;
        ServerComputer computer = ServerContext.get((MinecraftServer)server).registry().get(this.instanceID);
        if (computer == null) {
            System.out.println("Creating new computer bc no exist");
            if (this.computerId < 0) {
                System.out.println("Creating new computer id");
                this.computerId = ComputerCraftAPI.createUniqueNumberedSaveDir((MinecraftServer)server, (String)"computer");
            }
            computer = this.createComputer(this.computerId);
            System.out.println("putting instance id");
            this.instanceID = computer.register();
            System.out.println(this.instanceID);
            this.itsBrandNew = true;
            changed = true;
        }
        if (changed) {
            this.updateInputsImmediately(computer);
        }
        return computer;
    }

    private void updateInputsImmediately(ServerComputer computer) {
        for (class_2350 direction : DirectionUtil.FACINGS) {
            if (DirectionUtil.toLocal((class_2350)class_2350.field_11034, (class_2350)direction) == ComputerSide.TOP) {
                computer.setPeripheral(DirectionUtil.toLocal((class_2350)class_2350.field_11036, (class_2350)direction), (IPeripheral)this.getAccessoryAttachment(0));
                continue;
            }
            if (DirectionUtil.toLocal((class_2350)class_2350.field_11034, (class_2350)direction) == ComputerSide.BACK) {
                computer.setPeripheral(DirectionUtil.toLocal((class_2350)class_2350.field_11034, (class_2350)direction), (IPeripheral)this.getAccessoryAttachment(1));
                continue;
            }
            computer.setPeripheral(DirectionUtil.toLocal((class_2350)class_2350.field_11034, (class_2350)direction), null);
        }
    }

    protected ServerComputer createComputer(int id) {
        return new ServerComputer((class_3218)this.method_37908(), this.method_24515(), id, this.label, ComputerFamily.ADVANCED, 39, 13, ComponentMap.builder().add(Acdrones.DRONE, (Object)this.brain).build());
    }

    public boolean canPlayerUse(class_1657 player) {
        return true;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return DroneMenu.ofBrain(syncId, playerInventory, this.brain);
    }

    public ServerComputer getServerComputer() {
        MinecraftServer server = this.method_37908().method_8503();
        if (server == null) {
            throw new IllegalStateException("Cannot access server computer on the client.");
        }
        ServerComputer computer = ServerContext.get((MinecraftServer)server).registry().get(this.instanceID);
        return computer;
    }

    public DroneInventory getInventory() {
        return this.inventory;
    }

    public boolean isOn() {
        return (Boolean)this.field_6011.method_12789(on);
    }

    public boolean isHovering() {
        return this.hovering;
    }

    public void setHovering(boolean hovering) {
        this.hovering = hovering;
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    public void setSelectedSlot(int slot) {
        this.selectedSlot = slot;
    }

    public IDroneAccessory getAccessory() {
        Optional a = (Optional)this.field_6011.method_12789(accessory);
        return a.orElse(null);
    }

    public void setAccessory(IDroneAccessory accessory) {
        if (accessory != null) {
            accessory.setDrone(this.brain);
            this.field_6011.method_12778(ComputerDroneEntity.accessory, Optional.of(accessory));
        } else {
            this.field_6011.method_12778(ComputerDroneEntity.accessory, Optional.empty());
        }
    }

    public IDroneAccessory[] getAccessoryAttachments() {
        return new IDroneAccessory[]{((Optional)this.field_6011.method_12789(attachment_1)).orElse(null), ((Optional)this.field_6011.method_12789(attachment_2)).orElse(null)};
    }

    public IDroneAccessory getAccessoryAttachment(int index) {
        switch (index) {
            case 0: {
                return ((Optional)this.field_6011.method_12789(attachment_1)).orElse(null);
            }
            case 1: {
                return ((Optional)this.field_6011.method_12789(attachment_2)).orElse(null);
            }
        }
        return null;
    }

    public void setAccessoryAttachment(int slot, IDroneAccessory accessory) {
        if (accessory != null) {
            accessory.setDrone(this.brain);
            switch (slot) {
                case 0: {
                    accessory.setDrone(this.brain);
                    this.field_6011.method_12778(attachment_1, Optional.of(accessory));
                    this.updateInputsImmediately(this.createServerComputer());
                    break;
                }
                case 1: {
                    accessory.setDrone(this.brain);
                    this.field_6011.method_12778(attachment_2, Optional.of(accessory));
                    this.updateInputsImmediately(this.createServerComputer());
                }
            }
        } else {
            switch (slot) {
                case 0: {
                    this.field_6011.method_12778(attachment_1, Optional.empty());
                    break;
                }
                case 1: {
                    this.field_6011.method_12778(attachment_2, Optional.empty());
                }
            }
        }
    }

    public void setOnwer(UUID owner) {
        this.owner = owner;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public boolean isOwner(class_1657 player) {
        return this.owner != null && this.owner.equals(player.method_5667());
    }

    public AccessoryInventory getAccessoryInventory() {
        return this.accessoryInventory;
    }

    public class_2940<Optional<IDroneAccessory>> getTrackedAccessory() {
        return accessory;
    }

    public int getComputerId() {
        return this.computerId;
    }

    public void setComputerId(int computerId) {
        this.computerId = computerId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String customName) {
        this.label = customName;
    }

    public AttachmentInventory getAttachmentInventory() {
        return this.attachmentInventory;
    }
}

