/*
 * Decompiled with CFR 0.152.
 */
package net.apiocraft.acdrones.registries;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.apiocraft.acdrones.Acdrones;
import net.apiocraft.acdrones.accessories.defaultAccessories.modem.DroneModemAccessory;
import net.apiocraft.acdrones.accessories.droneClaw.DroneClawAccessory;
import net.apiocraft.acdrones.accessories.factory.DroneAccessoryFactory;
import net.apiocraft.acdrones.accessories.simpleAccessories.chunkloader.DroneChunkloaderAccessory;
import net.apiocraft.acdrones.core.IDroneAccessory;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class DroneAccessoryRegistry {
    public static final class_2378<DroneAccessoryFactory> DRONE_ACCESSORIES = FabricRegistryBuilder.createSimple(DroneAccessoryFactory.class, (class_2960)class_2960.method_60655((String)"acdrones", (String)"accessories")).buildAndRegister();
    public static final HashMap<DroneAccessoryFactory, class_2960> ACCESSORY_ITEM_LOOKUP = new HashMap();
    private static final HashMap<Class<? extends IDroneAccessory>, DroneAccessoryFactory> ACCESSORY_TYPE_TO_FACTORY = new HashMap();
    public static final DroneAccessoryFactory DRONE_ACCESSORY_CLAW = DroneAccessoryRegistry.registerAccessory("claw", DroneClawAccessory::new, class_7923.field_41178.method_10221((Object)Acdrones.DRONE_ACCESSORY_CLAW_ITEM));
    public static final DroneAccessoryFactory DRONE_ATTACHMENT_MODEM = DroneAccessoryRegistry.registerAccessory("modem", DroneModemAccessory::new, class_2960.method_60655((String)"computercraft", (String)"wireless_modem_normal"));
    public static final DroneAccessoryFactory DRONE_ATTACHMENT_ADVANCED_MODEM = DroneAccessoryRegistry.registerAccessory("advanced_modem", () -> new DroneModemAccessory(true), class_2960.method_60655((String)"computercraft", (String)"wireless_modem_advanced"));
    public static final DroneAccessoryFactory DRONE_ATTACHMENT_CHUNKLOADER = DroneAccessoryRegistry.registerAccessory("chunkloader", DroneChunkloaderAccessory::new, class_7923.field_41178.method_10221((Object)Acdrones.DRONE_ACCESSORY_CHUNKLOADER_ITEM));

    public static DroneAccessoryFactory registerAccessory(String name, Supplier<IDroneAccessory> supplier, class_2960 item) {
        DroneAccessoryFactory factory = new DroneAccessoryFactory(supplier);
        class_2378.method_10230(DRONE_ACCESSORIES, (class_2960)class_2960.method_60655((String)"acdrones", (String)name), (Object)factory);
        ACCESSORY_ITEM_LOOKUP.put(factory, item);
        ACCESSORY_TYPE_TO_FACTORY.put(factory.create().getClass(), factory);
        return factory;
    }

    public static IDroneAccessory createAccessory(class_2960 id) {
        DroneAccessoryFactory factory = (DroneAccessoryFactory)DRONE_ACCESSORIES.method_10223(id);
        if (factory != null) {
            return factory.create();
        }
        return null;
    }

    public static IDroneAccessory createFromNbt(class_2487 nbt) {
        class_2960 id = class_2960.method_12829((String)nbt.method_10558("id"));
        IDroneAccessory accessory = DroneAccessoryRegistry.createAccessory(id);
        if (accessory != null) {
            accessory.fromNbt(nbt);
        }
        return accessory;
    }

    public static IDroneAccessory createAccessoryFromNbt(class_2487 nbt) {
        class_2960 id = class_2960.method_12829((String)nbt.method_10558("id"));
        IDroneAccessory accessory = DroneAccessoryRegistry.createAccessory(id);
        if (accessory != null) {
            accessory.fromNbt(nbt);
        }
        return accessory;
    }

    public static class_1799 createItemStack(IDroneAccessory accessory) {
        class_1792 item;
        class_2960 itemId = ACCESSORY_ITEM_LOOKUP.get(ACCESSORY_TYPE_TO_FACTORY.get(accessory.getClass()));
        if (itemId != null && (item = (class_1792)class_7923.field_41178.method_10223(itemId)) != null) {
            return new class_1799((class_1935)item);
        }
        return class_1799.field_8037;
    }

    public static IDroneAccessory createAccessory(class_1799 stack) {
        class_2960 stackId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        for (Map.Entry<DroneAccessoryFactory, class_2960> entry : ACCESSORY_ITEM_LOOKUP.entrySet()) {
            if (!entry.getValue().equals((Object)stackId)) continue;
            return entry.getKey().create();
        }
        return null;
    }

    public static boolean isAccessory(class_1799 stack) {
        class_2960 stackId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        return ACCESSORY_ITEM_LOOKUP.containsValue(stackId);
    }

    public static class_2960 getId(IDroneAccessory accessory) {
        DroneAccessoryFactory factory = ACCESSORY_TYPE_TO_FACTORY.get(accessory.getClass());
        if (factory != null) {
            return DRONE_ACCESSORIES.method_10221((Object)factory);
        }
        return null;
    }

    public static void initialize() {
    }
}

