/*
 * Decompiled with CFR 0.152.
 */
package net.apiocraft.acdrones.core;

import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.apiocraft.acdrones.DroneCommand;
import net.apiocraft.acdrones.DroneCommandResult;
import net.apiocraft.acdrones.core.IDroneAccess;
import net.apiocraft.acdrones.core.IDroneAccessory;
import net.apiocraft.acdrones.entities.ComputerDroneEntity;
import net.apiocraft.acdrones.inventory.AccessoryInventory;
import net.apiocraft.acdrones.inventory.AttachmentInventory;
import net.minecraft.class_1263;
import net.minecraft.class_1313;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class DroneBrain
implements IDroneAccess {
    private final ComputerDroneEntity drone;
    boolean isCommandBusy = false;
    private CompletableFuture<DroneCommandResult> currentCommandResultPromise;
    private QueuedDroneCommand currentCommand;
    int didCommands;
    private final Queue<QueuedDroneCommand> commandQueue = new LinkedList<QueuedDroneCommand>();
    private IDroneAccessory _cachedAccessory = null;

    public DroneBrain(ComputerDroneEntity drone) {
        this.drone = drone;
    }

    @Override
    public class_243 getPosition() {
        return this.drone.method_19538();
    }

    @Override
    public class_3218 getLevel() {
        return (class_3218)this.drone.method_37908();
    }

    public ComputerDroneEntity getOwner() {
        return this.drone;
    }

    @Override
    public MethodResult executeCommand(DroneCommand command) {
        if (this.getLevel().method_8608()) {
            throw new IllegalStateException("Cannot execute commands on the client side");
        }
        if (this.commandQueue.size() > 16) {
            return MethodResult.of((Object[])new Object[]{false, "The command queue is too fat"});
        }
        this.commandQueue.offer(new QueuedDroneCommand(++this.didCommands, command));
        int commandId = this.didCommands;
        return new DroneCommandCallback((int)commandId).eventPull;
    }

    @Override
    public void setBusy(boolean busy) {
        this.isCommandBusy = busy;
    }

    @Override
    public boolean isBusy() {
        return this.isCommandBusy;
    }

    @Override
    public void move(class_243 targetMovement) {
        this.drone.method_5784(class_1313.field_6308, targetMovement);
    }

    @Override
    public void setVelocity(class_243 velocity) {
        this.drone.method_18799(velocity);
    }

    @Override
    public class_243 getVelocity() {
        return this.drone.method_18798();
    }

    @Override
    public int getSelectedSlot() {
        return this.drone.getSelectedSlot();
    }

    @Override
    public class_1263 getInventory() {
        return this.drone.getInventory();
    }

    @Override
    public void setSelectedSlot(int slot) {
        this.drone.setSelectedSlot(slot);
    }

    @Override
    public ComputerDroneEntity getEntity() {
        return this.drone;
    }

    @Override
    public IDroneAccessory getAccessory() {
        return this.drone.getAccessory();
    }

    @Override
    public AccessoryInventory getAccessoryInventory() {
        return this.drone.getAccessoryInventory();
    }

    @Override
    public IDroneAccessory[] getAccessoryAttachments() {
        return this.drone.getAccessoryAttachments();
    }

    @Override
    public IDroneAccessory getAccessoryAttachment(int index) {
        return this.drone.getAccessoryAttachment(index);
    }

    @Override
    public void setAccessoryAttachment(int index, IDroneAccessory accessory) {
        this.drone.setAccessoryAttachment(index, accessory);
    }

    @Override
    public AttachmentInventory getAttachmentInventory() {
        return this.drone.getAttachmentInventory();
    }

    public void update() {
        if (!this.getLevel().method_8608()) {
            ServerComputer computer = this.drone.getServerComputer();
            if (computer != null && this._cachedAccessory != this.drone.getAccessory()) {
                this._cachedAccessory = this.drone.getAccessory();
                computer.setPeripheral(ComputerSide.BOTTOM, (IPeripheral)this._cachedAccessory);
            }
            if (computer != null && !computer.getMainThreadMonitor().canWork()) {
                System.out.println("Cannot work");
                return;
            }
            if (this.checkWorkCommand(computer)) {
                return;
            }
            QueuedDroneCommand command = this.commandQueue.poll();
            if (command == null) {
                return;
            }
            long start = System.nanoTime();
            CompletableFuture<DroneCommandResult> resultPromise = command.command.execute(this);
            this.currentCommandResultPromise = resultPromise;
            this.currentCommand = command;
            long end = System.nanoTime();
            if (computer == null) {
                return;
            }
            computer.getMainThreadMonitor().trackWork(end - start, TimeUnit.NANOSECONDS);
            this.checkWorkCommand(computer);
            computer.setPosition(this.getLevel(), this.drone.method_24515());
        }
    }

    private boolean checkWorkCommand(ServerComputer computer) {
        if (this.currentCommandResultPromise != null && this.currentCommandResultPromise.isDone()) {
            DroneCommandResult result = this.currentCommandResultPromise.getNow(null);
            int callback_id = this.currentCommand.id;
            if (callback_id < 0) {
                return true;
            }
            if (result != null && result.isSuccess()) {
                Object[] results = result.getResults();
                if (results != null) {
                    Object[] args = new Object[results.length + 2];
                    args[0] = callback_id;
                    args[1] = true;
                    System.arraycopy(results, 0, args, 2, results.length);
                    computer.queueEvent("drone_command_result", args);
                } else {
                    computer.queueEvent("drone_command_result", new Object[]{callback_id, true});
                }
                this.currentCommandResultPromise = null;
                this.currentCommand = null;
            } else {
                String message = result != null ? result.getErrorMessage() : null;
                computer.queueEvent("drone_command_result", new Object[]{callback_id, false, message});
            }
            this.currentCommandResultPromise = null;
            this.currentCommand = null;
        } else if (this.currentCommandResultPromise != null && this.currentCommandResultPromise.isCancelled()) {
            int callback_id = this.currentCommand.id;
            this.currentCommandResultPromise = null;
            this.currentCommand = null;
            if (callback_id < 0) {
                return true;
            }
            computer.queueEvent("drone_command_result", new Object[]{callback_id, false});
        } else if (this.currentCommandResultPromise != null && !this.currentCommandResultPromise.isDone()) {
            if (computer == null) {
                return true;
            }
            long start = System.nanoTime();
            this.currentCommand.command().update(this);
            long end = System.nanoTime();
            computer.getMainThreadMonitor().trackWork(end - start, TimeUnit.NANOSECONDS);
            return true;
        }
        return false;
    }

    private record QueuedDroneCommand(int id, DroneCommand command) {
    }

    private static final class DroneCommandCallback
    implements ILuaCallback {
        final MethodResult eventPull = MethodResult.pullEvent((String)"drone_command_result", (ILuaCallback)this);
        private final int id;

        DroneCommandCallback(int id) {
            this.id = id;
        }

        public MethodResult resume(Object[] response) throws LuaException {
            Number id;
            block5: {
                block4: {
                    Object object;
                    System.out.println("Response: " + Arrays.toString(response));
                    System.out.println("ID: " + this.id);
                    System.out.println("Response length: " + response.length);
                    System.out.println("Response[1] instanceof Number: " + (response[1] instanceof Number));
                    System.out.println("Response[2] instanceof Boolean: " + (response[2] instanceof Boolean));
                    if (response.length < 3 || !((object = response[1]) instanceof Number)) break block4;
                    id = (Number)object;
                    if (response[2] instanceof Boolean) break block5;
                }
                return this.eventPull;
            }
            if (id.intValue() != this.id) {
                return this.eventPull;
            }
            System.out.println("ID matches");
            return MethodResult.of((Object[])Arrays.copyOfRange(response, 2, response.length));
        }
    }
}

