/*
 * Decompiled with CFR 0.152.
 */
package net.apiocraft.acdrones;

import org.jetbrains.annotations.Nullable;

public class DroneCommandResult {
    private static final DroneCommandResult EMPTY_SUCCESS = new DroneCommandResult(true, null, null);
    private static final DroneCommandResult EMPTY_FAILURE = new DroneCommandResult(false, null, null);
    private final boolean success;
    @Nullable
    private final String errorMessage;
    @Nullable
    private final Object[] results;

    public static DroneCommandResult success() {
        return EMPTY_SUCCESS;
    }

    public static DroneCommandResult success(@Nullable Object[] results) {
        if (results == null || results.length == 0) {
            return EMPTY_SUCCESS;
        }
        return new DroneCommandResult(true, null, results);
    }

    public static DroneCommandResult failure() {
        return EMPTY_FAILURE;
    }

    public static DroneCommandResult failure(@Nullable String errorMessage) {
        if (errorMessage == null) {
            return EMPTY_FAILURE;
        }
        return new DroneCommandResult(false, errorMessage, null);
    }

    private DroneCommandResult(boolean success, @Nullable String errorMessage, @Nullable Object[] results) {
        this.success = success;
        this.errorMessage = errorMessage;
        this.results = results;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public Object[] getResults() {
        return this.results;
    }
}

