/*
 * Decompiled with CFR 0.152.
 */
package net.nebula.legacyroulette;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.class_2960;
import net.nebula.legacyroulette.RouletteRewards;

public class PrizeStorage {
    public static final List<RouletteRewards.RouletteEntry> PRIZES = new ArrayList<RouletteRewards.RouletteEntry>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File FILE = new File("config/legacyroulette_prizes.json");
    public static String PASSWORD = "kXg15le652kCaYlEkejrtTycx6ScW2hJaffQ6SWCwC8qBAhHK1";

    public static void add(RouletteRewards.RouletteEntry entry) {
        if (!PRIZES.contains(entry)) {
            PRIZES.add(entry);
        }
    }

    public static void save() {
        JsonArray arr = new JsonArray();
        for (RouletteRewards.RouletteEntry e : PRIZES) {
            JsonObject obj = new JsonObject();
            obj.addProperty("texture", PrizeStorage.encrypt(e.texture().toString(), PASSWORD));
            obj.addProperty("weight", PrizeStorage.encrypt(Integer.toString(e.weight()), PASSWORD));
            obj.addProperty("name", PrizeStorage.encrypt(e.name(), PASSWORD));
            obj.addProperty("rarity", PrizeStorage.encrypt(e.rarity(), PASSWORD));
            arr.add((JsonElement)obj);
        }
        try {
            FILE.getParentFile().mkdirs();
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(FILE), StandardCharsets.UTF_8);){
                GSON.toJson((JsonElement)arr, (Appendable)writer);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void load() {
        PRIZES.clear();
        if (!FILE.exists()) {
            PrizeStorage.save();
            return;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(FILE), StandardCharsets.UTF_8);){
            JsonArray arr = JsonParser.parseReader((Reader)reader).getAsJsonArray();
            for (JsonElement el : arr) {
                JsonObject obj = el.getAsJsonObject();
                String textureStr = PrizeStorage.decrypt(obj.get("texture").getAsString(), PASSWORD);
                String weightStr = PrizeStorage.decrypt(obj.get("weight").getAsString(), PASSWORD);
                String nameStr = PrizeStorage.decrypt(obj.get("name").getAsString(), PASSWORD);
                String rarityStr = PrizeStorage.decrypt(obj.get("rarity").getAsString(), PASSWORD);
                class_2960 tex = null;
                if (textureStr != null) {
                    tex = class_2960.method_12829((String)textureStr);
                }
                int weight = 0;
                if (weightStr != null) {
                    weight = Integer.parseInt(weightStr);
                }
                PRIZES.add(new RouletteRewards.RouletteEntry(tex, weight, nameStr, rarityStr));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String encrypt(String plaintext, String password) {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            byte[] keyBytes = sha.digest(password.getBytes(StandardCharsets.UTF_8));
            SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
            byte[] iv = new byte[12];
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)key, new GCMParameterSpec(128, iv));
            return Base64.getEncoder().encodeToString(cipher.doFinal(plaintext.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decrypt(String base64Cipher, String password) {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            byte[] keyBytes = sha.digest(password.getBytes(StandardCharsets.UTF_8));
            SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
            byte[] iv = new byte[12];
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)key, new GCMParameterSpec(128, iv));
            byte[] ciphertext = Base64.getDecoder().decode(base64Cipher);
            return new String(cipher.doFinal(ciphertext), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }
}

