/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.coppershears.platform;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import de.cech12.coppershears.platform.services.IConfigHelper;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ForgeConfigHelper
implements IConfigHelper {
    private static final ForgeConfigSpec SERVER_CONFIG;
    private static final ForgeConfigSpec.IntValue DURABILITY;

    @Override
    public void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
        Path path = FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).resolve("coppershears-server.toml");
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        SERVER_CONFIG.setConfig((CommentedConfig)configData);
    }

    @Override
    public int getDurability() {
        try {
            return (Integer)DURABILITY.get();
        }
        catch (IllegalStateException ex) {
            return 181;
        }
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Balance Options");
        DURABILITY = builder.comment("Defines the maximum durability of Copper Shears. (181 - default value, 0 - deactivates the durability)").defineInRange("durability", 181, 0, 10000);
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

