package de.cech12.coppershears.mixin;

import com.google.common.collect.ImmutableList;
import de.cech12.coppershears.Constants;
import de.cech12.coppershears.mixin.accessor.HolderSetDirectAccessor;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2073;
import net.minecraft.class_223;
import net.minecraft.class_5341;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;

@Mixin(class_223.class)
public abstract class MatchToolMixin implements class_5341 {

    @Unique
    private static final List<class_2073> ITEM_PREDICATES = new ArrayList<>();

    @Inject(at = @At("RETURN"), method = "<init>")
    private void initProxy(CallbackInfo ci) {
        //collect all MatchTool predicates
        ((class_223)(Object)this).comp_1884().ifPresent(ITEM_PREDICATES::add);
    }

    static {
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            class_6880<class_1792> copperShearsHolder = class_7923.field_41178.method_47983(Constants.COPPER_SHEARS.get());
            class_6880<class_1792> shearsHolder = class_7923.field_41178.method_47983(class_1802.field_8868);
            //add copper shears to all MatchTool predicates that contains vanilla shears
            for (class_2073 itemPredicate : ITEM_PREDICATES) {
                itemPredicate.comp_1784().ifPresent(holders -> {
                    if (holders instanceof class_6885.class_6886 && holders.method_40241(shearsHolder) && !holders.method_40241(copperShearsHolder)) {
                        HolderSetDirectAccessor<class_1792> accessor = ((HolderSetDirectAccessor<class_1792>) holders);
                        ArrayList<class_6880<class_1792>> newList = new ArrayList<>(accessor.getContents());
                        newList.add(copperShearsHolder);
                        accessor.setContents(ImmutableList.copyOf(newList));
                        accessor.setContentsSet(null); //reset contents set
                    }
                });
            }
        });
    }

}
