package dev.booky.vanish.listeners;
// Created by booky10 in CloudVanish (21:34 09.11.22)

import dev.booky.vanish.VanishManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class JoinQuitListener implements Listener {

    private final VanishManager manager;

    public JoinQuitListener(VanishManager manager) {
        this.manager = manager;
    }

    @EventHandler(priority = EventPriority.LOWEST)
    public void onLowJoin(PlayerJoinEvent event) {
        // this is the first event which is consistently called on login for 1.21.9+;
        // previously, we could use the SpawnLocationEvent which was fired immediately after the
        // player data was fully loaded; this event has been moved into the config phase, so
        // it now no longer includes the player instance
        this.manager.handleLogin(event.getPlayer());
    }

    @EventHandler(priority = EventPriority.HIGHEST)
    public void onHighJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        int vanishLevel = this.manager.getVanishLevelOrCalc(player);
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (player == target) {
                continue;
            }

            Integer targetLvl = this.manager.getVanishLevel(target);
            if (targetLvl != null) { // check if target is vanished
                if (targetLvl > vanishLevel) { // check if target has higher level than player
                    player.hidePlayer(this.manager.getPlugin(), target);
                }
            }
        }

        if (!this.manager.isVanished(player)) {
            return;
        }

        player.sendMessage(this.manager.getPrefix()
                .append(Component.translatable("vanish.info", NamedTextColor.YELLOW)));

        Component joinMessage = event.joinMessage();
        if (joinMessage != null) {
            Bukkit.getConsoleSender().sendMessage(joinMessage);
            event.joinMessage(null);

            Component broadcastMessage = this.manager.getPrefix().append(joinMessage);
            for (Player viewer : this.manager.getViewers(player)) {
                viewer.sendMessage(broadcastMessage);
            }
        }
    }

    @EventHandler(priority = EventPriority.HIGHEST)
    public void onQuit(PlayerQuitEvent event) {
        if (!this.manager.isVanished(event.getPlayer())) {
            return;
        }

        Component quitMessage = event.quitMessage();
        if (quitMessage != null) {
            Bukkit.getConsoleSender().sendMessage(quitMessage);
            event.quitMessage(null);

            Component broadcastMessage = this.manager.getPrefix().append(quitMessage);
            for (Player player : this.manager.getViewers(event.getPlayer())) {
                player.sendMessage(broadcastMessage);
            }
        }
        this.manager.handleQuit(event.getPlayer());
    }
}
