/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.bacterium.block;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import me.huanmeng.bacterium.block.BlockBase;
import me.huanmeng.bacterium.item.Items;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;

public class BlockMust
extends BlockBase {
    public static final int MAX = 7;
    public static final IntegerProperty GROWN = IntegerProperty.create((String)"grown", (int)0, (int)7);

    public BlockMust(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)GROWN, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{GROWN});
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if ((Integer)state.getValue((Property)GROWN) >= 7) {
            ItemStack stack = Items.BUNCH.getItem().getDefaultInstance();
            LootParams lootContext = builder.withParameter(LootContextParams.BLOCK_STATE, (Object)state).create(LootContextParamSets.BLOCK);
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int r = ((Random)random).nextInt(3);
            ItemStack tool = (ItemStack)lootContext.getParameter(LootContextParams.TOOL);
            if (!tool.isEmpty()) {
                int m = ((Random)random).nextInt(4);
                if (m <= 0) {
                    m = 1;
                }
                r += EnchantmentHelper.getItemEnchantmentLevel((Holder)builder.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE), (ItemStack)tool) * m;
                r = (int)((float)r + lootContext.getLuck() * (float)((Random)random).nextInt(2));
            }
            if (r > 0) {
                stack.setCount(r);
            }
            return Collections.singletonList(stack);
        }
        return Collections.singletonList(state.getBlock().asItem().getDefaultInstance());
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!world.isClientSide) {
            FluidState fluidState;
            int meta;
            BlockState upBlock = world.getBlockState(pos.above());
            int old = meta = ((Integer)state.getValue((Property)GROWN)).intValue();
            if (meta >= 7) {
                return;
            }
            if (random.nextInt(3) >= 1) {
                ++meta;
            }
            if (!(fluidState = upBlock.getFluidState()).getType().is(FluidTags.WATER)) {
                meta = 0;
            }
            if (meta != old) {
                world.setBlockAndUpdate(pos, (BlockState)this.defaultBlockState().setValue((Property)GROWN, (Comparable)Integer.valueOf(meta)));
            }
        }
    }

    public boolean isRandomlyTicking(BlockState p_49921_) {
        return (Integer)p_49921_.getValue((Property)GROWN) < 7;
    }
}

