/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.bacterium.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.huanmeng.bacterium.Bacterium;
import me.huanmeng.bacterium.block.Blocks;
import me.huanmeng.bacterium.item.ItemJammer;
import me.huanmeng.bacterium.utils.Entry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;

public class BlockEntityBacteria
extends BlockEntity {
    protected Random rand;
    BlockState bacblock;
    List<Entry> mbs;
    int id;
    int time;
    public boolean run;
    boolean jammer;

    public BlockEntityBacteria(BlockPos pos, BlockState state) {
        Bacterium.getInstance();
        this((BlockEntityType)Bacterium.BACTERIA_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public BlockEntityBacteria(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.rand = new Random();
        this.mbs = new ArrayList<Entry>();
        this.time = 0;
        this.bacblock = Blocks.BACTERIA.getBlock().defaultBlockState();
        this.id = new Random().nextInt(Integer.MAX_VALUE);
        while (Bacterium.cl.contains(this.id)) {
            this.id = new Random().nextInt(Integer.MAX_VALUE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void tick(Level level, BlockPos blockPos, BlockState state, BlockEntityBacteria tileEntityBacterium) {
        if (level.isClientSide) return;
        tileEntityBacterium.setChanged();
        if (Bacterium.jamAll || Bacterium.cl.contains(tileEntityBacterium.id)) {
            tileEntityBacterium.jammer = true;
            tileEntityBacterium.die();
            return;
        }
        if (tileEntityBacterium.mbs.isEmpty()) {
            if (!level.hasNeighborSignal(blockPos)) return;
            tileEntityBacterium.selMBS();
            if (tileEntityBacterium.mbs.isEmpty()) return;
            if (tileEntityBacterium.start()) {
                tileEntityBacterium.run = true;
            }
        }
        if (!tileEntityBacterium.run) {
            if (Bacterium.random) {
                tileEntityBacterium.time = tileEntityBacterium.rand.nextInt(50) + 1;
            }
            if (tileEntityBacterium.time < 50) {
                ++tileEntityBacterium.time;
                return;
            }
        }
        tileEntityBacterium.time = 0;
        tileEntityBacterium.te();
    }

    public boolean start() {
        return true;
    }

    public void selMBS() {
        BlockState state;
        if (this.level == null) {
            return;
        }
        BlockPos pos = this.getBlockPos().above();
        while ((state = this.level.getBlockState(pos)).getBlock() != net.minecraft.world.level.block.Blocks.AIR) {
            this.addMBS(state);
            pos = pos.above();
        }
    }

    public void addMBS(BlockState state) {
        if (!BlockEntityBacteria.isInvalidFood(state)) {
            this.mbs.add(new Entry(state));
        }
    }

    public static boolean isInvalidFood(BlockState state) {
        return state.getBlock() == net.minecraft.world.level.block.Blocks.BEDROCK || state.getBlock() == Blocks.BACTERIA.getBlock() || state.getBlock() == Blocks.REPLACE.getBlock() || state.getBlock() == net.minecraft.world.level.block.Blocks.BRICKS || state.getBlock() == Blocks.JAMMER.getBlock();
    }

    public void te() {
        this.ms(this.getBlockPos().north());
        this.ms(this.getBlockPos().south());
        this.ms(this.getBlockPos().east());
        this.ms(this.getBlockPos().west());
        this.ms(this.getBlockPos().below());
        this.ms(this.getBlockPos().above());
        this.die();
    }

    public void ms(BlockPos pos) {
        if (this.level == null) {
            return;
        }
        if (this.isInBar(pos)) {
            return;
        }
        if (this.level.getBlockState(pos).getBlock() == net.minecraft.world.level.block.Blocks.AIR) {
            return;
        }
        if (this.isMVS(this.level.getBlockState(pos))) {
            this.level.setBlockAndUpdate(pos, this.bacblock);
            BlockEntityBacteria bacteriaBlockEntity = (BlockEntityBacteria)this.level.getBlockEntity(pos);
            if (bacteriaBlockEntity == null) {
                return;
            }
            bacteriaBlockEntity.mbs = this.mbs;
            bacteriaBlockEntity.id = this.id;
        }
    }

    public boolean isInBar(BlockPos pos) {
        if (this.level == null) {
            return false;
        }
        return pos.getY() >= this.level.getHeight();
    }

    public boolean isMVS(BlockState state) {
        if (Bacterium.cl.contains(this.id)) {
            return false;
        }
        if (state.getBlock() == Blocks.JAMMER.getBlock()) {
            Bacterium.cl.add(this.id);
            this.jammer = true;
            return false;
        }
        if (this.mbs.size() > 0) {
            for (Entry f : this.mbs) {
                if (!this.isMBSS(f, state)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMBSS(Entry f, BlockState state) {
        if (state == f.state) {
            return true;
        }
        if (state == net.minecraft.world.level.block.Blocks.DIRT.defaultBlockState()) {
            return f.state == net.minecraft.world.level.block.Blocks.GRASS_BLOCK.defaultBlockState();
        }
        if (state == net.minecraft.world.level.block.Blocks.GRASS_BLOCK.defaultBlockState()) {
            return f.state == net.minecraft.world.level.block.Blocks.DIRT.defaultBlockState();
        }
        if (state == net.minecraft.world.level.block.Blocks.WATER.defaultBlockState()) {
            return f.state.getFluidState().getType() == Fluids.FLOWING_WATER;
        }
        if (state.getFluidState().getType() == Fluids.FLOWING_WATER) {
            return f.state == net.minecraft.world.level.block.Blocks.WATER.defaultBlockState();
        }
        if (state == net.minecraft.world.level.block.Blocks.LAVA.defaultBlockState()) {
            return f.state.getFluidState().getType() == Fluids.FLOWING_LAVA;
        }
        if (state.getFluidState().getType() == Fluids.FLOWING_LAVA) {
            return f.state == net.minecraft.world.level.block.Blocks.LAVA.defaultBlockState();
        }
        return false;
    }

    public void die() {
        if (this.level == null) {
            return;
        }
        this.level.setBlockAndUpdate(this.getBlockPos(), net.minecraft.world.level.block.Blocks.AIR.defaultBlockState());
        if (this.jammer) {
            ++ItemJammer.amount;
        }
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider p_333170_) {
        super.loadAdditional(compound, p_333170_);
        if (this.mbs == null) {
            this.mbs = new ArrayList<Entry>();
        }
        this.readLatest(compound);
        this.readForge(compound);
    }

    public void readLatest(CompoundTag compound) {
        if (!compound.contains("bacterium")) {
            return;
        }
        compound = compound.getCompound("bacterium");
        this.id = compound.getInt("identifier");
        if (compound.contains("entries")) {
            CompoundTag entries = compound.getCompound("entries");
            for (String key : entries.getAllKeys()) {
                CompoundTag entry = entries.getCompound(key);
                Entry e = Entry.readFromNbt(entry);
                if (e == null) continue;
                this.mbs.add(e);
            }
        }
    }

    public CompoundTag write(CompoundTag compound) {
        CompoundTag main = new CompoundTag();
        main.putInt("identifier", this.id);
        CompoundTag entries = new CompoundTag();
        for (Entry e : this.mbs) {
            entries.put(RandomStringUtils.random((int)8), (Tag)e.toNbt());
        }
        main.put("entries", (Tag)entries);
        compound.put("bacterium", (Tag)main);
        return compound;
    }

    public void readForge(CompoundTag compound) {
        if (!compound.contains("identifier")) {
            return;
        }
        this.id = compound.getInt("identifier");
        int i = compound.getInt("f");
        for (int j = 0; j < i; ++j) {
            int id = compound.getInt("mbs" + j);
            this.mbs.add(new Entry(Block.byItem((Item)Item.byId((int)id)).defaultBlockState()));
        }
    }

    protected void saveAdditional(CompoundTag p_187471_, HolderLookup.Provider p_327783_) {
        super.saveAdditional(p_187471_, p_327783_);
        this.write(p_187471_);
    }

    @NotNull
    public BlockEntityType<?> getType() {
        Bacterium.getInstance();
        return (BlockEntityType)Bacterium.BACTERIA_BLOCK_ENTITY_TYPE.get();
    }
}

