/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.bacterium.block.entity;

import me.huanmeng.bacterium.Bacterium;
import me.huanmeng.bacterium.block.Blocks;
import me.huanmeng.bacterium.block.entity.BlockEntityBacteria;
import me.huanmeng.bacterium.item.ItemJammer;
import me.huanmeng.bacterium.utils.Entry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BlockEntityReplacer
extends BlockEntityBacteria {
    Entry entry;

    public BlockEntityReplacer(BlockPos pos, BlockState state) {
        Bacterium.getInstance();
        super((BlockEntityType)Bacterium.REPLACER_BLOCK_ENTITY_TYPE.get(), pos, state);
        this.bacblock = Blocks.REPLACE.getBlock().defaultBlockState();
    }

    @Override
    public void selMBS() {
        if (this.level == null) {
            return;
        }
        if (this.level.hasNeighborSignal(this.getBlockPos())) {
            BlockEntity blockEntity;
            BlockState up = this.level.getBlockState(this.getBlockPos().above());
            BlockState down = this.level.getBlockState(this.getBlockPos().below());
            if (up.getBlock() == net.minecraft.world.level.block.Blocks.AIR || down.getBlock() == net.minecraft.world.level.block.Blocks.AIR || down.getBlock() == Blocks.REPLACE.getBlock() || down.getBlock() == Blocks.JAMMER.getBlock() || up == down) {
                return;
            }
            this.addMBS(down);
            this.entry = new Entry(up);
            if (up.hasBlockEntity() && (blockEntity = this.level.getBlockEntity(this.getBlockPos().above())) != null) {
                this.entry.nbt = blockEntity.saveWithFullMetadata((HolderLookup.Provider)this.level.registryAccess());
            }
            if (!up.getProperties().isEmpty()) {
                for (Property property : up.getProperties()) {
                    this.entry.props.put(property, up.getValue(property));
                }
            }
            this.level.setBlockAndUpdate(this.getBlockPos().above(), net.minecraft.world.level.block.Blocks.AIR.defaultBlockState());
        }
    }

    @Override
    public boolean start() {
        return false;
    }

    @Override
    public void ms(BlockPos pos) {
        if (this.level == null) {
            return;
        }
        if (!this.isInBar(pos) && this.isMVS(this.level.getBlockState(pos))) {
            this.level.setBlockAndUpdate(pos, this.bacblock);
            BlockEntityReplacer blockEntity = (BlockEntityReplacer)this.level.getBlockEntity(pos);
            if (blockEntity == null) {
                return;
            }
            blockEntity.mbs = this.mbs;
            blockEntity.id = this.id;
            blockEntity.entry = this.entry;
        }
    }

    @Override
    public void die() {
        if (this.level == null) {
            return;
        }
        BlockPos pos = this.getBlockPos();
        if (this.entry != null) {
            BlockState state = this.entry.state();
            this.level.setBlockAndUpdate(pos, state);
            if (this.entry.nbt != null && this.level.getBlockState(pos).hasBlockEntity()) {
                try {
                    BlockEntity blockEntity = BlockEntity.loadStatic((BlockPos)pos, (BlockState)state, (CompoundTag)this.entry.nbt, (HolderLookup.Provider)this.level.registryAccess());
                    if (blockEntity == null) {
                        return;
                    }
                    this.level.setBlockEntity(blockEntity);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.level.setBlockAndUpdate(pos, net.minecraft.world.level.block.Blocks.AIR.defaultBlockState());
        }
        if (this.jammer) {
            ++ItemJammer.amount;
        }
    }

    @Override
    public CompoundTag write(CompoundTag compound) {
        compound = super.write(compound);
        if (this.entry != null) {
            compound.put("target", (Tag)this.entry.toNbt());
        }
        return compound;
    }

    @Override
    @NotNull
    public BlockEntityType<?> getType() {
        Bacterium.getInstance();
        return (BlockEntityType)Bacterium.REPLACER_BLOCK_ENTITY_TYPE.get();
    }

    @Override
    public void readLatest(CompoundTag compound) {
        super.readLatest(compound);
        if (compound.contains("target")) {
            this.entry = Entry.readFromNbt(compound.getCompound("target"));
        }
    }
}

