/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.bacterium.utils;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import me.huanmeng.bacterium.utils.PropertyType;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class Entry {
    public BlockState state;
    public CompoundTag nbt;
    public Map<Property<? extends Comparable<?>>, Comparable<?>> props;

    public Entry(BlockState state) {
        this.state = state;
        this.props = new HashMap();
    }

    public <E extends Enum<E>> Entry enums(E e, EnumProperty<E> property) {
        this.props.put((Property<Comparable<?>>)property, (Comparable<?>)((Object)e));
        return this;
    }

    public BlockState state() {
        BlockState state = this.state;
        for (Map.Entry<Property<Comparable<?>>, Comparable<?>> entry : this.props.entrySet()) {
            state = (BlockState)state.setValue(entry.getKey(), entry.getValue());
        }
        return state;
    }

    public Entry enums(String enumName, String enumClass, Object instance) {
        try {
            Class<?> enumClazz = Class.forName(enumClass);
            if (!enumClazz.isEnum()) {
                return this;
            }
            this.props.put((Property)instance, (Comparable)enumClazz.getDeclaredMethod("valueOf", String.class).invoke(null, enumName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public Entry bool(boolean b, BooleanProperty property) {
        this.props.put((Property<Comparable<?>>)property, Boolean.valueOf(b));
        return this;
    }

    public Entry bool(boolean b, Object instance) {
        this.props.put((Property)instance, Boolean.valueOf(b));
        return this;
    }

    public Entry ints(int i, IntegerProperty property) {
        this.props.put((Property<Comparable<?>>)property, Integer.valueOf(i));
        return this;
    }

    public Entry ints(int i, Object instance) {
        this.props.put((Property)instance, Integer.valueOf(i));
        return this;
    }

    public Entry dir(Direction dir, DirectionProperty property) {
        this.props.put((Property<Comparable<?>>)property, (Comparable<?>)dir);
        return this;
    }

    public Entry dir(Direction dir, Object instance) {
        this.props.put((Property<Comparable<?>>)((Property)instance), (Comparable<?>)dir);
        return this;
    }

    public String toString() {
        return "Entry{state=" + String.valueOf(this.state) + ", nbt=" + String.valueOf(this.nbt) + ", props=" + String.valueOf(this.props) + "}";
    }

    public static Entry readFromNbt(CompoundTag entry) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.parse((String)entry.getString("id")));
        if (block == null) {
            return null;
        }
        Entry e = new Entry(block.defaultBlockState());
        if (entry.contains("nbt")) {
            e.nbt = entry.getCompound("nbt");
        }
        if (entry.contains("properties")) {
            CompoundTag properties = entry.getCompound("properties");
            for (String name : properties.getAllKeys()) {
                PropertyType type;
                CompoundTag a = properties.getCompound(name);
                int index = a.getInt("index");
                Object propertyInstance = PropertyType.findProperty(block.getClass(), index, block);
                if (propertyInstance == null || (type = PropertyType.type(properties)) == null) continue;
                switch (type) {
                    case BOOL: {
                        e.bool(a.getBoolean("value"), propertyInstance);
                        break;
                    }
                    case DIR: {
                        e.dir(Direction.from3DDataValue((int)a.getInt("value")), propertyInstance);
                        break;
                    }
                    case INT: {
                        e.ints(a.getInt("value"), propertyInstance);
                        break;
                    }
                    case ENUM: {
                        e.enums(a.getString("value"), a.getString("class"), properties);
                    }
                }
            }
        }
        return e;
    }

    public CompoundTag toNbt() {
        CompoundTag entry = new CompoundTag();
        Block block = this.state.getBlock();
        ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (key == null) {
            return entry;
        }
        entry.putString("id", key.toString());
        if (this.nbt != null) {
            entry.put("nbt", (Tag)this.nbt);
        }
        if (!this.props.isEmpty()) {
            CompoundTag properties = new CompoundTag();
            for (Map.Entry<Property<Comparable<?>>, Comparable<?>> comparableEntry : this.props.entrySet()) {
                CompoundTag pro = new CompoundTag();
                PropertyType type = PropertyType.type(comparableEntry.getKey());
                if (type != null) {
                    switch (type) {
                        case DIR: {
                            pro.putInt("value", ((Direction)comparableEntry.getValue()).get3DDataValue());
                            break;
                        }
                        case ENUM: {
                            pro.putString("value", ((Enum)((Object)comparableEntry.getValue())).name());
                            pro.putString("class", comparableEntry.getValue().getClass().getName());
                            break;
                        }
                        case INT: {
                            pro.putInt("value", ((Integer)comparableEntry.getValue()).intValue());
                            break;
                        }
                        case BOOL: {
                            pro.putBoolean("value", ((Boolean)comparableEntry.getValue()).booleanValue());
                        }
                    }
                }
                int index = -1;
                try {
                    Class<?> clazz = block.getClass();
                    Field[] declaredFields = clazz.getDeclaredFields();
                    for (int i = 0; i < declaredFields.length; ++i) {
                        Field field = declaredFields[i];
                        field.setAccessible(true);
                        if (field.get(block) != comparableEntry.getKey()) continue;
                        index = i;
                        break;
                    }
                    pro.putInt("index", index);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (index == -1) continue;
                properties.put(comparableEntry.getKey().getName(), (Tag)pro);
            }
            entry.put("properties", (Tag)properties);
        }
        return entry;
    }
}

