/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.bacterium.block;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import me.huanmeng.bacterium.block.ModBlock;
import me.huanmeng.bacterium.item.ModItems;
import me.huanmeng.bacterium.type.ModBlockType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class BlockMust
extends Block
implements ModBlock {
    public static final int MAX_STAGE = 7;
    public static final IntegerProperty GROWN = IntegerProperty.create((String)"grown", (int)0, (int)7);

    public BlockMust(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)GROWN, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{GROWN});
    }

    @Override
    public ModBlockType getModBlockType() {
        return ModBlockType.MUST;
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        if ((Integer)state.getValue((Property)GROWN) >= 7) {
            LootParams lootparams = params.withParameter(LootContextParams.BLOCK_STATE, (Object)state).create(LootContextParamSets.BLOCK);
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int r = ((Random)random).nextInt(3);
            ItemStack tool = (ItemStack)lootparams.contextMap().getOptional(LootContextParams.TOOL);
            if (tool != null && !tool.isEmpty()) {
                int m = Math.max(1, ((Random)random).nextInt(4));
                Holder.Reference entry = lootparams.getLevel().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
                r += EnchantmentHelper.getItemEnchantmentLevel((Holder)entry, (ItemStack)tool) * m;
                r += (int)(lootparams.getLuck() * (float)((Random)random).nextInt(2));
            }
            ItemStack stack = ModItems.BUNCH.get().getDefaultInstance();
            if (r > 0) {
                stack.setCount(r);
            }
            return Collections.singletonList(stack);
        }
        return super.getDrops(state, params);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int meta;
        if (level.isClientSide()) {
            return;
        }
        FluidState fluidState = level.getFluidState(pos.above());
        int old = meta = ((Integer)state.getValue((Property)GROWN)).intValue();
        if (meta >= 7) {
            return;
        }
        if (random.nextInt(3) >= 1) {
            ++meta;
        }
        if (!fluidState.is(FluidTags.WATER)) {
            meta = 0;
        }
        if (meta != old) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)GROWN, (Comparable)Integer.valueOf(meta)));
        }
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)GROWN) < 7;
    }
}

