/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.bacterium.util;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class Entry {
    private static final JsonOps JSONOPS = JsonOps.COMPRESSED;
    public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("block").forGetter(e -> e.state.method_41520().method_55840()), (App)class_2487.field_25128.optionalFieldOf("nbt").forGetter(e -> Optional.ofNullable(e.nbt)), (App)new Codec<Map<String, JsonElement>>(){

        public <T> DataResult<T> encode(Map<String, JsonElement> input, DynamicOps<T> ops, T prefix) {
            RecordBuilder mappedBuilder = ops.mapBuilder();
            input.forEach((k, v) -> mappedBuilder.add(k, JSONOPS.convertTo(ops, v)));
            return mappedBuilder.build(prefix);
        }

        public <T> DataResult<Pair<Map<String, JsonElement>, T>> decode(DynamicOps<T> ops, T input) {
            HashMap result = new HashMap();
            return ops.getMap(input).flatMap(map -> {
                map.entries().forEach(entry -> {
                    String key = (String)ops.getStringValue(entry.getFirst()).getOrThrow();
                    Object second = entry.getSecond();
                    result.put(key, (JsonElement)ops.convertTo((DynamicOps)JSONOPS, second));
                });
                return DataResult.success((Object)Pair.of((Object)result, (Object)input));
            });
        }
    }.fieldOf("props").forGetter(e -> e.props)).apply((Applicative)instance, Entry::load));
    public class_2680 state;
    private class_2487 nbt;
    private Map<String, JsonElement> props;

    public Entry(class_2680 state, @Nullable class_1937 level, @Nullable class_2586 blockEntity) {
        this.state = state;
        this.props = new HashMap<String, JsonElement>();
        for (class_2769 property : state.method_28501()) {
            Comparable value = state.method_11654(property);
            DataResult object = property.method_30044().encodeStart((DynamicOps)JSONOPS, (Object)new class_2769.class_4933(property, value));
            this.props.put(property.method_11899(), (JsonElement)object.getOrThrow());
        }
        if (level != null && blockEntity != null) {
            this.nbt = blockEntity.method_38242((class_7225.class_7874)level.method_30349());
        }
    }

    public void place(class_1937 level, class_2338 pos) {
        class_2586 blockEntity;
        if (level == null) {
            return;
        }
        class_2680 blockState = this.createState();
        level.method_8501(pos, blockState);
        if (this.nbt != null && level.method_8321(pos) != null && (blockEntity = class_2586.method_11005((class_2338)pos, (class_2680)blockState, (class_2487)this.nbt, (class_7225.class_7874)level.method_30349())) != null) {
            level.method_8438(blockEntity);
        }
    }

    public class_2680 createState() {
        class_2680 state = this.state;
        for (class_2769 property : state.method_28501()) {
            if (!this.props.containsKey(property.method_11899())) continue;
            state = this.setPropertyValue(state, property);
        }
        return state;
    }

    private <T extends Comparable<T>> class_2680 setPropertyValue(class_2680 state, class_2769<T> property) {
        JsonElement value = this.props.get(property.method_11899());
        if (property.method_11902().isInstance(value)) {
            try {
                return (class_2680)state.method_11657(property, ((class_2769.class_4933)((Pair)property.method_30044().decode((DynamicOps)JSONOPS, (Object)value).getOrThrow()).getFirst()).comp_71());
            }
            catch (Throwable e) {
                return state;
            }
        }
        return state;
    }

    private static Entry load(String blockId, Optional<class_2487> nbt, Map<String, JsonElement> props) {
        Optional block = class_7923.field_41175.method_17966(class_2960.method_60654((String)blockId));
        if (block.isEmpty()) {
            return null;
        }
        Entry entry = new Entry(((class_2248)block.get()).method_9564(), null, null);
        entry.nbt = nbt.orElse(null);
        entry.props = props;
        return entry;
    }

    public class_2520 toNbt() {
        return (class_2520)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).getOrThrow();
    }

    public String toString() {
        return "Entry{state=" + String.valueOf(this.state) + ", nbt=" + String.valueOf(this.nbt) + ", props=" + String.valueOf(this.props) + "}";
    }
}

