/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.bacterium.platform;

import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import me.huanmeng.bacterium.platform.services.IRegister;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ForgeRegister
implements IRegister {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"bacterium");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"bacterium");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"bacterium");
    private static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"bacterium");
    private static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TAB = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"bacterium");

    public static void register(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        BLOCK_TYPES.register(bus);
        ENTITIES.register(bus);
        CREATIVE_MODE_TAB.register(bus);
    }

    @Override
    public BlockBehaviour.Properties createProperties(ResourceLocation location, float destroyTime, float explosionResistance) {
        return BlockBehaviour.Properties.of().strength(destroyTime, explosionResistance).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)location));
    }

    @Override
    public Supplier<Block> registerBlock(ResourceLocation location, Function<BlockBehaviour.Properties, Block> blockFunction, BlockBehaviour.Properties properties) {
        return BLOCKS.register(location.getPath(), () -> (Block)blockFunction.apply(properties));
    }

    @Override
    public <T extends BlockEntity> Supplier<BlockEntityType<?>> registerBlockEntityType(ResourceLocation location, BiFunction<BlockPos, BlockState, T> blockEntityBiFunction, Supplier<Block> blockSupplier) {
        return BLOCK_TYPES.register(location.getPath(), () -> new BlockEntityType(blockEntityBiFunction::apply, Set.of((Block)blockSupplier.get())));
    }

    @Override
    public Supplier<Item> registerItem(ResourceLocation location, Function<Item.Properties, Item> itemFunction, Item.Properties properties) {
        return ITEMS.register(location.getPath(), () -> (Item)itemFunction.apply(properties));
    }

    @Override
    public <T extends Entity> Supplier<EntityType<T>> registerEntity(ResourceLocation location, MobCategory mobCategory, BiFunction<EntityType<T>, Level, T> entityFunction, float width, float height, int trackingRange, int updateInterval) {
        return ENTITIES.register(location.getPath(), () -> EntityType.Builder.of(entityFunction::apply, (MobCategory)mobCategory).sized(width, height).clientTrackingRange(trackingRange).updateInterval(updateInterval).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)location)));
    }

    @Override
    public void initCreativeModeTab(ResourceLocation location, Supplier<ItemStack> icon, List<Supplier<Item>> items) {
        CREATIVE_MODE_TAB.register(location.getPath(), () -> CreativeModeTab.builder().icon(icon).title((Component)Component.translatable((String)"itemGroup.bacterium.bacterium")).displayItems((itemDisplayParameters, output) -> items.forEach(item -> output.accept((ItemLike)item.get()))).build());
    }
}

