/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.bacterium.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.huanmeng.bacterium.Bacterium;
import me.huanmeng.bacterium.block.Blocks;
import me.huanmeng.bacterium.item.ItemJammer;
import me.huanmeng.bacterium.utils.Entry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;

public class BlockEntityBacteria
extends BlockEntity {
    protected Random rand;
    BlockState bacblock;
    List<Entry> mbs;
    int id;
    int time;
    public boolean run;
    boolean jammer;

    public BlockEntityBacteria(BlockPos pos, BlockState state) {
        Bacterium.getInstance();
        this((BlockEntityType)Bacterium.BACTERIA_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public BlockEntityBacteria(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.rand = new Random();
        this.mbs = new ArrayList<Entry>();
        this.time = 0;
        this.bacblock = Blocks.BACTERIA.getBlock().m_49966_();
        this.id = new Random().nextInt(Integer.MAX_VALUE);
        while (Bacterium.cl.contains(this.id)) {
            this.id = new Random().nextInt(Integer.MAX_VALUE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void tick(Level level, BlockPos blockPos, BlockState state, BlockEntityBacteria tileEntityBacterium) {
        if (level.f_46443_) return;
        tileEntityBacterium.m_6596_();
        if (Bacterium.jamAll || Bacterium.cl.contains(tileEntityBacterium.id)) {
            tileEntityBacterium.jammer = true;
            tileEntityBacterium.die();
            return;
        }
        if (tileEntityBacterium.mbs.isEmpty()) {
            if (!level.m_276867_(blockPos)) return;
            tileEntityBacterium.selMBS();
            if (tileEntityBacterium.mbs.isEmpty()) return;
            if (tileEntityBacterium.start()) {
                tileEntityBacterium.run = true;
            }
        }
        if (!tileEntityBacterium.run) {
            if (Bacterium.random) {
                tileEntityBacterium.time = tileEntityBacterium.rand.nextInt(50) + 1;
            }
            if (tileEntityBacterium.time < 50) {
                ++tileEntityBacterium.time;
                return;
            }
        }
        tileEntityBacterium.time = 0;
        tileEntityBacterium.te();
    }

    public boolean start() {
        return true;
    }

    public void selMBS() {
        BlockState state;
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos pos = this.m_58899_().m_7494_();
        while ((state = this.f_58857_.m_8055_(pos)).m_60734_() != net.minecraft.world.level.block.Blocks.f_50016_) {
            this.addMBS(state);
            pos = pos.m_7494_();
        }
    }

    public void addMBS(BlockState state) {
        if (!BlockEntityBacteria.isInvalidFood(state)) {
            this.mbs.add(new Entry(state));
        }
    }

    public static boolean isInvalidFood(BlockState state) {
        return state.m_60734_() == net.minecraft.world.level.block.Blocks.f_50752_ || state.m_60734_() == Blocks.BACTERIA.getBlock() || state.m_60734_() == Blocks.REPLACE.getBlock() || state.m_60734_() == net.minecraft.world.level.block.Blocks.f_50076_ || state.m_60734_() == Blocks.JAMMER.getBlock();
    }

    public void te() {
        this.ms(this.m_58899_().m_122012_());
        this.ms(this.m_58899_().m_122019_());
        this.ms(this.m_58899_().m_122029_());
        this.ms(this.m_58899_().m_122024_());
        this.ms(this.m_58899_().m_7495_());
        this.ms(this.m_58899_().m_7494_());
        this.die();
    }

    public void ms(BlockPos pos) {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.isInBar(pos)) {
            return;
        }
        if (this.f_58857_.m_8055_(pos).m_60734_() == net.minecraft.world.level.block.Blocks.f_50016_) {
            return;
        }
        if (this.isMVS(this.f_58857_.m_8055_(pos))) {
            this.f_58857_.m_46597_(pos, this.bacblock);
            BlockEntityBacteria bacteriaBlockEntity = (BlockEntityBacteria)this.f_58857_.m_7702_(pos);
            if (bacteriaBlockEntity == null) {
                return;
            }
            bacteriaBlockEntity.mbs = this.mbs;
            bacteriaBlockEntity.id = this.id;
        }
    }

    public boolean isInBar(BlockPos pos) {
        if (this.f_58857_ == null) {
            return false;
        }
        return pos.m_123342_() >= this.f_58857_.m_141928_();
    }

    public boolean isMVS(BlockState state) {
        if (Bacterium.cl.contains(this.id)) {
            return false;
        }
        if (state.m_60734_() == Blocks.JAMMER.getBlock()) {
            Bacterium.cl.add(this.id);
            this.jammer = true;
            return false;
        }
        if (this.mbs.size() > 0) {
            for (Entry f : this.mbs) {
                if (!this.isMBSS(f, state)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMBSS(Entry f, BlockState state) {
        if (state == f.state) {
            return true;
        }
        if (state == net.minecraft.world.level.block.Blocks.f_50493_.m_49966_()) {
            return f.state == net.minecraft.world.level.block.Blocks.f_50034_.m_49966_();
        }
        if (state == net.minecraft.world.level.block.Blocks.f_50034_.m_49966_()) {
            return f.state == net.minecraft.world.level.block.Blocks.f_50493_.m_49966_();
        }
        if (state == net.minecraft.world.level.block.Blocks.f_49990_.m_49966_()) {
            return f.state.m_60819_().m_76152_() == Fluids.f_76192_;
        }
        if (state.m_60819_().m_76152_() == Fluids.f_76192_) {
            return f.state == net.minecraft.world.level.block.Blocks.f_49990_.m_49966_();
        }
        if (state == net.minecraft.world.level.block.Blocks.f_49991_.m_49966_()) {
            return f.state.m_60819_().m_76152_() == Fluids.f_76194_;
        }
        if (state.m_60819_().m_76152_() == Fluids.f_76194_) {
            return f.state == net.minecraft.world.level.block.Blocks.f_49991_.m_49966_();
        }
        return false;
    }

    public void die() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_46597_(this.m_58899_(), net.minecraft.world.level.block.Blocks.f_50016_.m_49966_());
        if (this.jammer) {
            ++ItemJammer.amount;
        }
    }

    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        if (this.mbs == null) {
            this.mbs = new ArrayList<Entry>();
        }
        this.readLatest(compound);
        this.readForge(compound);
    }

    public void readLatest(CompoundTag compound) {
        if (!compound.m_128441_("bacterium")) {
            return;
        }
        compound = compound.m_128469_("bacterium");
        this.id = compound.m_128451_("identifier");
        if (compound.m_128441_("entries")) {
            CompoundTag entries = compound.m_128469_("entries");
            for (String key : entries.m_128431_()) {
                CompoundTag entry = entries.m_128469_(key);
                Entry e = Entry.readFromNbt(entry);
                if (e == null) continue;
                this.mbs.add(e);
            }
        }
    }

    public CompoundTag write(CompoundTag compound) {
        CompoundTag main = new CompoundTag();
        main.m_128405_("identifier", this.id);
        CompoundTag entries = new CompoundTag();
        for (Entry e : this.mbs) {
            entries.m_128365_(RandomStringUtils.random((int)8), (Tag)e.toNbt());
        }
        main.m_128365_("entries", (Tag)entries);
        compound.m_128365_("bacterium", (Tag)main);
        return compound;
    }

    public void readForge(CompoundTag compound) {
        if (!compound.m_128441_("identifier")) {
            return;
        }
        this.id = compound.m_128451_("identifier");
        int i = compound.m_128451_("f");
        for (int j = 0; j < i; ++j) {
            int id = compound.m_128451_("mbs" + j);
            this.mbs.add(new Entry(Block.m_49814_((Item)Item.m_41445_((int)id)).m_49966_()));
        }
    }

    public CompoundTag serializeNBT() {
        return this.write(super.serializeNBT());
    }

    @NotNull
    public BlockEntityType<?> m_58903_() {
        Bacterium.getInstance();
        return (BlockEntityType)Bacterium.BACTERIA_BLOCK_ENTITY_TYPE.get();
    }
}

