/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.bacterium.block.entity;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.huanmeng.bacterium.BacteriumCache;
import me.huanmeng.bacterium.block.ModBlock;
import me.huanmeng.bacterium.block.ModBlocks;
import me.huanmeng.bacterium.type.ModBlockType;
import me.huanmeng.bacterium.util.Entry;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3612;
import net.minecraft.class_7225;

public class BlockEntityBacteria
extends class_2586 {
    protected int id;
    protected final List<Entry> infected = new ArrayList<Entry>();

    public BlockEntityBacteria(class_2338 pos, class_2680 blockState) {
        this(ModBlocks.BLOCK_ENTITY_BACTERIA.get(), pos, blockState);
    }

    public BlockEntityBacteria(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
        this.id = BacteriumCache.freeId();
    }

    public void findInfectBlcoks() {
        class_2680 state;
        class_2338 pos = this.field_11867.method_10084();
        while (!(state = this.field_11863.method_8320(pos)).method_26215()) {
            class_2338 finalPos = pos;
            this.addInfectBlock(state, () -> this.field_11863.method_8321(finalPos));
            pos = pos.method_10084();
        }
    }

    public void addInfectBlock(class_2680 state, Supplier<class_2586> blockEntity) {
        if (BlockEntityBacteria.isInvalidBlock(state)) {
            return;
        }
        this.infected.add(new Entry(state, this.field_11863, blockEntity.get()));
    }

    public static boolean isInvalidBlock(class_2680 state) {
        class_2248 block = state.method_26204();
        return state.method_26215() || block == class_2246.field_9987 || block == ModBlocks.BACTERIA.get() || block == ModBlocks.REPLACER.get() || block == ModBlocks.JAMMER.get() || block == class_2246.field_10104;
    }

    public boolean isInfectBlock(class_2680 state) {
        ModBlock block;
        if (BacteriumCache.isUsed(this.id)) {
            return false;
        }
        if (this.infected.isEmpty()) {
            return false;
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ModBlock && (block = (ModBlock)class_22482).getModBlockType() == ModBlockType.JAMMER) {
            BacteriumCache.markUsed(this.id);
            return false;
        }
        return this.infected.stream().anyMatch(entry -> BlockEntityBacteria.matchState(entry, state));
    }

    protected static boolean matchState(Entry a, class_2680 state) {
        class_2680 excepted = a.state;
        if (excepted == state) {
            return true;
        }
        if (state == class_2246.field_10566.method_9564()) {
            return excepted == class_2246.field_10219.method_9564();
        }
        if (state == class_2246.field_10219.method_9564()) {
            return excepted == class_2246.field_10566.method_9564();
        }
        if (state == class_2246.field_10382.method_9564()) {
            return excepted.method_26227().method_15772() == class_3612.field_15909;
        }
        if (state.method_26227().method_15772() == class_3612.field_15909) {
            return excepted == class_2246.field_10382.method_9564();
        }
        if (state == class_2246.field_10164.method_9564()) {
            return excepted.method_26227().method_15772() == class_3612.field_15907;
        }
        if (state.method_26227().method_15772() == class_3612.field_15907) {
            return excepted == class_2246.field_10164.method_9564();
        }
        if (state.method_26164(class_3481.field_15503)) {
            return excepted.method_26204() == state.method_26204();
        }
        return false;
    }

    public void expand(class_2338 pos) {
        if (this.isOutside(pos)) {
            return;
        }
        class_2680 blockState = this.field_11863.method_8320(pos);
        if (blockState.method_26215()) {
            return;
        }
        if (!this.isInfectBlock(blockState)) {
            return;
        }
        this.field_11863.method_8501(pos, this.method_11010());
        BlockEntityBacteria blockEntity = (BlockEntityBacteria)this.field_11863.method_8321(pos);
        assert (blockEntity != null);
        blockEntity.id = this.id;
        blockEntity.infected.addAll(this.infected);
    }

    public void expandAndRemove() {
        this.expand(this.field_11867.method_10095());
        this.expand(this.field_11867.method_10072());
        this.expand(this.field_11867.method_10067());
        this.expand(this.field_11867.method_10078());
        this.expand(this.field_11867.method_10084());
        this.expand(this.field_11867.method_10074());
        this.remove();
    }

    public void remove() {
        this.field_11863.method_8501(this.field_11867, class_2246.field_10124.method_9564());
    }

    public boolean isOutside(class_2338 pos) {
        return pos.method_10264() > this.field_11863.method_31600() || pos.method_10264() < this.field_11863.method_31607();
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        if (!tag.method_10545("bacterium")) {
            return;
        }
        class_2487 main = (class_2487)tag.method_10562("bacterium").orElseThrow();
        if (main.method_10545("id")) {
            this.id = (Integer)main.method_10550("id").orElseThrow();
        }
        if (main.method_10545("entries")) {
            class_2499 entries = (class_2499)main.method_10554("entries").orElseThrow();
            for (class_2520 entry : entries) {
                Entry.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)entry).result().ifPresent(e -> this.infected.add((Entry)e.getFirst()));
            }
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        class_2487 main = new class_2487();
        main.method_10569("id", this.id);
        class_2499 entries = new class_2499();
        for (Entry entry : this.infected) {
            entries.add((Object)entry.toNbt());
        }
        main.method_10566("entries", (class_2520)entries);
        tag.method_10566("bacterium", (class_2520)main);
    }
}

