/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.bacterium.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.huanmeng.bacterium.BacteriumCache;
import me.huanmeng.bacterium.block.ModBlock;
import me.huanmeng.bacterium.block.ModBlocks;
import me.huanmeng.bacterium.type.ModBlockType;
import me.huanmeng.bacterium.util.Entry;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class BlockEntityBacteria
extends BlockEntity {
    protected int id;
    protected final List<Entry> infected = new ArrayList<Entry>();

    public BlockEntityBacteria(BlockPos pos, BlockState blockState) {
        this(ModBlocks.BLOCK_ENTITY_BACTERIA.get(), pos, blockState);
    }

    public BlockEntityBacteria(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.id = BacteriumCache.freeId();
    }

    public void findInfectBlcoks() {
        BlockState state;
        BlockPos pos = this.worldPosition.above();
        while (!(state = this.level.getBlockState(pos)).isAir()) {
            BlockPos finalPos = pos;
            this.addInfectBlock(state, () -> this.level.getBlockEntity(finalPos));
            pos = pos.above();
        }
    }

    public void addInfectBlock(BlockState state, Supplier<BlockEntity> blockEntity) {
        if (BlockEntityBacteria.isInvalidBlock(state)) {
            return;
        }
        this.infected.add(new Entry(state, this.level, blockEntity.get()));
    }

    public static boolean isInvalidBlock(BlockState state) {
        Block block = state.getBlock();
        return state.isAir() || block == Blocks.BEDROCK || block == ModBlocks.BACTERIA.get() || block == ModBlocks.REPLACER.get() || block == ModBlocks.JAMMER.get() || block == Blocks.BRICKS;
    }

    public boolean isInfectBlock(BlockState state) {
        ModBlock block;
        if (BacteriumCache.isUsed(this.id)) {
            return false;
        }
        if (this.infected.isEmpty()) {
            return false;
        }
        Block block2 = state.getBlock();
        if (block2 instanceof ModBlock && (block = (ModBlock)block2).getModBlockType() == ModBlockType.JAMMER) {
            BacteriumCache.markUsed(this.id);
            return false;
        }
        return this.infected.stream().anyMatch(entry -> BlockEntityBacteria.matchState(entry, state));
    }

    protected static boolean matchState(Entry a, BlockState state) {
        BlockState excepted = a.state;
        if (excepted == state) {
            return true;
        }
        if (state == Blocks.DIRT.defaultBlockState()) {
            return excepted == Blocks.GRASS_BLOCK.defaultBlockState();
        }
        if (state == Blocks.GRASS_BLOCK.defaultBlockState()) {
            return excepted == Blocks.DIRT.defaultBlockState();
        }
        if (state == Blocks.WATER.defaultBlockState()) {
            return excepted.getFluidState().getType() == Fluids.FLOWING_WATER;
        }
        if (state.getFluidState().getType() == Fluids.FLOWING_WATER) {
            return excepted == Blocks.WATER.defaultBlockState();
        }
        if (state == Blocks.LAVA.defaultBlockState()) {
            return excepted.getFluidState().getType() == Fluids.FLOWING_LAVA;
        }
        if (state.getFluidState().getType() == Fluids.FLOWING_LAVA) {
            return excepted == Blocks.LAVA.defaultBlockState();
        }
        if (state.is(BlockTags.LEAVES)) {
            return excepted.getBlock() == state.getBlock();
        }
        return false;
    }

    public void expand(BlockPos pos) {
        if (this.isOutside(pos)) {
            return;
        }
        BlockState blockState = this.level.getBlockState(pos);
        if (blockState.isAir()) {
            return;
        }
        if (!this.isInfectBlock(blockState)) {
            return;
        }
        this.level.setBlockAndUpdate(pos, this.getBlockState());
        BlockEntityBacteria blockEntity = (BlockEntityBacteria)this.level.getBlockEntity(pos);
        assert (blockEntity != null);
        blockEntity.id = this.id;
        blockEntity.infected.addAll(this.infected);
    }

    public void expandAndRemove() {
        this.expand(this.worldPosition.north());
        this.expand(this.worldPosition.south());
        this.expand(this.worldPosition.west());
        this.expand(this.worldPosition.east());
        this.expand(this.worldPosition.above());
        this.expand(this.worldPosition.below());
        this.remove();
    }

    public void remove() {
        this.level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
    }

    public boolean isOutside(BlockPos pos) {
        return pos.getY() > this.level.getMaxY() || pos.getY() < this.level.getMinY();
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        if (input.child("bacterium").isEmpty()) {
            return;
        }
        ValueInput main = (ValueInput)input.child("bacterium").orElseThrow();
        if (main.getInt("id").isPresent()) {
            this.id = (Integer)main.getInt("id").orElseThrow();
        }
        if (main.childrenList("entries").isPresent()) {
            ValueInput.ValueInputList entries = (ValueInput.ValueInputList)main.childrenList("entries").orElseThrow();
            for (ValueInput entry : entries) {
                entry.read(Entry.CODEC).map(this.infected::add);
            }
        }
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        ValueOutput main = output.child("bacterium");
        main.putInt("id", this.id);
        ValueOutput.ValueOutputList entries = main.childrenList("entries");
        for (Entry entry : this.infected) {
            entry.write(entries.addChild());
        }
    }
}

