/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.bacterium.util;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class Entry {
    private static final JsonOps JSONOPS = JsonOps.COMPRESSED;
    public static final MapCodec<Entry> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("block").forGetter(e -> e.state.getBlockHolder().getRegisteredName()), (App)CompoundTag.CODEC.optionalFieldOf("nbt").forGetter(e -> Optional.ofNullable(e.nbt)), (App)new Codec<Map<String, JsonElement>>(){

        public <T> DataResult<T> encode(Map<String, JsonElement> input, DynamicOps<T> ops, T prefix) {
            RecordBuilder mappedBuilder = ops.mapBuilder();
            input.forEach((k, v) -> mappedBuilder.add(k, JSONOPS.convertTo(ops, v)));
            return mappedBuilder.build(prefix);
        }

        public <T> DataResult<Pair<Map<String, JsonElement>, T>> decode(DynamicOps<T> ops, T input) {
            HashMap result = new HashMap();
            return ops.getMap(input).flatMap(map -> {
                map.entries().forEach(entry -> {
                    String key = (String)ops.getStringValue(entry.getFirst()).getOrThrow();
                    Object second = entry.getSecond();
                    result.put(key, (JsonElement)ops.convertTo((DynamicOps)JSONOPS, second));
                });
                return DataResult.success((Object)Pair.of((Object)result, (Object)input));
            });
        }
    }.fieldOf("props").forGetter(e -> e.props)).apply((Applicative)instance, Entry::load));
    public BlockState state;
    private CompoundTag nbt;
    private Map<String, JsonElement> props;

    public Entry(BlockState state, @Nullable Level level, @Nullable BlockEntity blockEntity) {
        this.state = state;
        this.props = new HashMap<String, JsonElement>();
        for (Property property : state.getProperties()) {
            Comparable value = state.getValue(property);
            DataResult object = property.valueCodec().encodeStart((DynamicOps)JSONOPS, (Object)new Property.Value(property, value));
            this.props.put(property.getName(), (JsonElement)object.getOrThrow());
        }
        if (level != null && blockEntity != null) {
            this.nbt = blockEntity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
        }
    }

    public void place(Level level, BlockPos pos) {
        BlockEntity blockEntity;
        if (level == null) {
            return;
        }
        BlockState blockState = this.createState();
        level.setBlockAndUpdate(pos, blockState);
        if (this.nbt != null && level.getBlockEntity(pos) != null && (blockEntity = BlockEntity.loadStatic((BlockPos)pos, (BlockState)blockState, (CompoundTag)this.nbt, (HolderLookup.Provider)level.registryAccess())) != null) {
            level.setBlockEntity(blockEntity);
        }
    }

    public BlockState createState() {
        BlockState state = this.state;
        for (Property property : state.getProperties()) {
            if (!this.props.containsKey(property.getName())) continue;
            state = this.setPropertyValue(state, property);
        }
        return state;
    }

    private <T extends Comparable<T>> BlockState setPropertyValue(BlockState state, Property<T> property) {
        JsonElement value = this.props.get(property.getName());
        if (property.getValueClass().isInstance(value)) {
            try {
                return (BlockState)state.setValue(property, ((Property.Value)((Pair)property.valueCodec().decode((DynamicOps)JSONOPS, (Object)value).getOrThrow()).getFirst()).value());
            }
            catch (Throwable e) {
                return state;
            }
        }
        return state;
    }

    private static Entry load(String blockId, Optional<CompoundTag> nbt, Map<String, JsonElement> props) {
        Optional block = BuiltInRegistries.BLOCK.getOptional(ResourceLocation.parse((String)blockId));
        if (block.isEmpty()) {
            return null;
        }
        Entry entry = new Entry(((Block)block.get()).defaultBlockState(), null, null);
        entry.nbt = nbt.orElse(null);
        entry.props = props;
        return entry;
    }

    public void write(ValueOutput output) {
        output.store(CODEC, (Object)this);
    }

    public String toString() {
        return "Entry{state=" + String.valueOf(this.state) + ", nbt=" + String.valueOf(this.nbt) + ", props=" + String.valueOf(this.props) + "}";
    }
}

