/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.bacterium.block.entity;

import com.mojang.serialization.DynamicOps;
import me.huanmeng.bacterium.BacteriumCache;
import me.huanmeng.bacterium.block.ModBlock;
import me.huanmeng.bacterium.block.ModBlocks;
import me.huanmeng.bacterium.block.entity.BlockEntityBacteria;
import me.huanmeng.bacterium.type.ModBlockType;
import me.huanmeng.bacterium.util.Entry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityReplacer
extends BlockEntity {
    protected int id = BacteriumCache.freeId();
    protected Entry bacteria;
    protected Entry sample;

    public BlockEntityReplacer(BlockPos pos, BlockState blockState) {
        this(ModBlocks.BLOCK_ENTITY_REPLACER.get(), pos, blockState);
    }

    public BlockEntityReplacer(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public void findInfectBlcoks() {
        BlockPos above = this.worldPosition.above();
        BlockPos below = this.worldPosition.below();
        BlockState bacteriaState = this.level.getBlockState(above);
        BlockState sampleState = this.level.getBlockState(below);
        if (!BlockEntityReplacer.isInvalidBacteria(bacteriaState) && !BlockEntityBacteria.isInvalidBlock(sampleState) && bacteriaState != sampleState) {
            this.bacteria = new Entry(bacteriaState, this.level, this.level.getBlockEntity(above));
            this.sample = new Entry(sampleState, this.level, this.level.getBlockEntity(below));
            this.level.setBlockAndUpdate(above, Blocks.AIR.defaultBlockState());
        }
    }

    public static boolean isInvalidBacteria(BlockState state) {
        Block block = state.getBlock();
        return state.isAir() || block == Blocks.BEDROCK || block == ModBlocks.JAMMER.get() || block == Blocks.BRICKS;
    }

    public void addInfectBlock(BlockState state, BlockPos pos) {
        if (BlockEntityBacteria.isInvalidBlock(state)) {
            return;
        }
        this.bacteria = new Entry(state, this.level, this.level.getBlockEntity(pos));
    }

    public boolean isInfectBlock(BlockState state) {
        ModBlock block;
        if (BacteriumCache.isUsed(this.id)) {
            return false;
        }
        if (this.sample == null) {
            return false;
        }
        Block block2 = state.getBlock();
        if (block2 instanceof ModBlock && (block = (ModBlock)block2).getModBlockType() == ModBlockType.JAMMER) {
            BacteriumCache.markUsed(this.id);
            return false;
        }
        return BlockEntityBacteria.matchState(this.sample, state);
    }

    public void expand(BlockPos pos) {
        if (this.isOutside(pos)) {
            return;
        }
        BlockState blockState = this.level.getBlockState(pos);
        if (blockState.isAir()) {
            return;
        }
        if (!this.isInfectBlock(blockState)) {
            return;
        }
        this.level.setBlockAndUpdate(pos, this.getBlockState());
        BlockEntityReplacer blockEntity = (BlockEntityReplacer)this.level.getBlockEntity(pos);
        if (blockEntity != null) {
            blockEntity.id = this.id;
            blockEntity.sample = this.sample;
            blockEntity.bacteria = this.bacteria;
        }
    }

    public void expandAndRemove() {
        this.expand(this.worldPosition.north());
        this.expand(this.worldPosition.south());
        this.expand(this.worldPosition.west());
        this.expand(this.worldPosition.east());
        this.expand(this.worldPosition.above());
        this.expand(this.worldPosition.below());
        this.remove();
    }

    public void remove() {
        if (this.bacteria != null) {
            this.bacteria.place(this.level, this.worldPosition);
        } else {
            this.level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
        }
    }

    public boolean isOutside(BlockPos pos) {
        return pos.getY() > this.level.getMaxBuildHeight() || pos.getY() < this.level.getMinBuildHeight();
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (!tag.contains("bacterium", 10)) {
            return;
        }
        CompoundTag main = tag.getCompound("bacterium");
        if (main.contains("id", 3)) {
            this.id = main.getInt("id");
        }
        if (main.contains("bacteria")) {
            Entry.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)main.get("bacteria")).result().ifPresent(e -> {
                this.bacteria = (Entry)e.getFirst();
            });
        }
        if (main.contains("sample")) {
            Entry.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)main.get("sample")).result().ifPresent(e -> {
                this.sample = (Entry)e.getFirst();
            });
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        CompoundTag main = new CompoundTag();
        main.putInt("id", this.id);
        if (this.bacteria != null) {
            main.put("bacteria", this.bacteria.toNbt());
        }
        if (this.sample != null) {
            main.put("sample", this.sample.toNbt());
        }
        tag.put("bacterium", (Tag)main);
    }
}

