/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.bacterium.item;

import me.huanmeng.bacterium.entity.PotionEntityBacteria;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.level.Level;

public class ItemSplashBacteria
extends SplashPotionItem {
    public ItemSplashBacteria(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            PotionEntityBacteria potionEntity = new PotionEntityBacteria(level, (LivingEntity)player);
            potionEntity.setItem(itemStack);
            potionEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
            level.addFreshEntity((Entity)potionEntity);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        itemStack.consume(1, (LivingEntity)player);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SPLASH_POTION_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }
}

