/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.bacterium.item;

import me.huanmeng.bacterium.BacteriumCache;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class ItemJammer
extends Item {
    private int time;

    public ItemJammer(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, EquipmentSlot slot) {
        if (!BacteriumCache.jammedAll || this.time < 0) {
            return;
        }
        --this.time;
        if (this.time <= 0) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.displayClientMessage((Component)Component.translatable((String)"bacterium.item.jammeritem.jammed.message", (Object[])new Object[]{BacteriumCache.jammedCount}), false);
            }
            BacteriumCache.jammedAll = false;
            BacteriumCache.jammedCount = 0;
        }
    }

    public InteractionResult use(Level level, Player player, InteractionHand usedHand) {
        if (!level.isClientSide && this.time <= 0) {
            this.time = 30;
            BacteriumCache.jammedAll = true;
            player.displayClientMessage((Component)Component.translatable((String)"bacterium.item.jammeritem.rightclick.message"), false);
            player.getItemInHand(usedHand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)usedHand));
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && this.time <= 0) {
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
        }
        return super.useOn(context);
    }
}

