/*
 * Decompiled with CFR 0.152.
 */
package me.huanmeng.bacterium.block.entity;

import me.huanmeng.bacterium.BacteriumCache;
import me.huanmeng.bacterium.block.ModBlock;
import me.huanmeng.bacterium.block.ModBlocks;
import me.huanmeng.bacterium.block.entity.BlockEntityBacteria;
import me.huanmeng.bacterium.type.ModBlockType;
import me.huanmeng.bacterium.util.Entry;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class BlockEntityReplacer
extends class_2586 {
    protected int id = BacteriumCache.freeId();
    protected Entry bacteria;
    protected Entry sample;

    public BlockEntityReplacer(class_2338 pos, class_2680 blockState) {
        this(ModBlocks.BLOCK_ENTITY_REPLACER.get(), pos, blockState);
    }

    public BlockEntityReplacer(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    public void findInfectBlcoks() {
        class_2338 above = this.field_11867.method_10084();
        class_2338 below = this.field_11867.method_10074();
        class_2680 bacteriaState = this.field_11863.method_8320(above);
        class_2680 sampleState = this.field_11863.method_8320(below);
        if (!BlockEntityReplacer.isInvalidBacteria(bacteriaState) && !BlockEntityBacteria.isInvalidBlock(sampleState) && bacteriaState != sampleState) {
            this.bacteria = new Entry(bacteriaState, this.field_11863, this.field_11863.method_8321(above));
            this.sample = new Entry(sampleState, this.field_11863, this.field_11863.method_8321(below));
            this.field_11863.method_8501(above, class_2246.field_10124.method_9564());
        }
    }

    public static boolean isInvalidBacteria(class_2680 state) {
        class_2248 block = state.method_26204();
        return state.method_26215() || block == class_2246.field_9987 || block == ModBlocks.JAMMER.get() || block == class_2246.field_10104;
    }

    public void addInfectBlock(class_2680 state, class_2338 pos) {
        if (BlockEntityBacteria.isInvalidBlock(state)) {
            return;
        }
        this.bacteria = new Entry(state, this.field_11863, this.field_11863.method_8321(pos));
    }

    public boolean isInfectBlock(class_2680 state) {
        ModBlock block;
        if (BacteriumCache.isUsed(this.id)) {
            return false;
        }
        if (this.sample == null) {
            return false;
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ModBlock && (block = (ModBlock)class_22482).getModBlockType() == ModBlockType.JAMMER) {
            BacteriumCache.markUsed(this.id);
            return false;
        }
        return BlockEntityBacteria.matchState(this.sample, state);
    }

    public void expand(class_2338 pos) {
        if (this.isOutside(pos)) {
            return;
        }
        class_2680 blockState = this.field_11863.method_8320(pos);
        if (blockState.method_26215()) {
            return;
        }
        if (!this.isInfectBlock(blockState)) {
            return;
        }
        this.field_11863.method_8501(pos, this.method_11010());
        BlockEntityReplacer blockEntity = (BlockEntityReplacer)this.field_11863.method_8321(pos);
        if (blockEntity != null) {
            blockEntity.id = this.id;
            blockEntity.sample = this.sample;
            blockEntity.bacteria = this.bacteria;
        }
    }

    public void expandAndRemove() {
        this.expand(this.field_11867.method_10095());
        this.expand(this.field_11867.method_10072());
        this.expand(this.field_11867.method_10067());
        this.expand(this.field_11867.method_10078());
        this.expand(this.field_11867.method_10084());
        this.expand(this.field_11867.method_10074());
        this.remove();
    }

    public void remove() {
        if (this.bacteria != null) {
            this.bacteria.place(this.field_11863, this.field_11867);
        } else {
            this.field_11863.method_8501(this.field_11867, class_2246.field_10124.method_9564());
        }
    }

    public boolean isOutside(class_2338 pos) {
        return pos.method_10264() > this.field_11863.method_31600() || pos.method_10264() < this.field_11863.method_31607();
    }

    protected void method_11014(class_11368 input) {
        super.method_11014(input);
        if (input.method_71420("bacterium").isEmpty()) {
            return;
        }
        class_11368 main = (class_11368)input.method_71420("bacterium").orElseThrow();
        if (main.method_71439("id").isPresent()) {
            this.id = (Integer)main.method_71439("id").orElseThrow();
        }
        if (main.method_71420("bacteria").isPresent()) {
            this.bacteria = (Entry)main.method_71420("bacteria").flatMap(e -> e.method_71418(Entry.CODEC)).orElseThrow();
        }
        if (main.method_71420("sample").isPresent()) {
            this.sample = (Entry)main.method_71420("sample").flatMap(e -> e.method_71418(Entry.CODEC)).orElseThrow();
        }
    }

    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        class_11372 main = output.method_71461("bacterium");
        main.method_71465("id", this.id);
        if (this.bacteria != null) {
            this.bacteria.write(main.method_71461("bacteria"));
        }
        if (this.sample != null) {
            this.sample.write(main.method_71461("sample"));
        }
    }
}

