/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.block.entity;

import com.daqem.irobot.block.entity.IRobotBlockEntities;
import com.daqem.irobot.config.IRobotConfig;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.item.BatteryItem;
import com.daqem.irobot.item.data.BatteryDataComponent;
import com.daqem.irobot.item.data.IRobotDataComponents;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_9331;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RobotStationBlockEntity
extends class_2586
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RobotStationBlockEntity(class_2338 pos, class_2680 blockState) {
        super((class_2591)IRobotBlockEntities.ROBOT_STATION.get(), pos, blockState);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, RobotStationBlockEntity station) {
        class_238 chargingArea = new class_238(pos);
        List entities = level.method_18467(class_1297.class, chargingArea);
        for (class_1297 entity : entities) {
            if (entity instanceof IRobotEntity) {
                IRobotEntity robot = (IRobotEntity)entity;
                RobotStationBlockEntity.chargeRobot(robot, station);
                continue;
            }
            if (!(entity instanceof class_1542)) continue;
            class_1542 itemEntity = (class_1542)entity;
            RobotStationBlockEntity.chargeBatteryItem(itemEntity);
        }
    }

    private static void chargeRobot(IRobotEntity robot, RobotStationBlockEntity station) {
        class_1799 batteryStack = robot.getInventory().getBattery();
        if (!batteryStack.method_7960() && batteryStack.method_7909() instanceof BatteryItem) {
            BatteryDataComponent data = (BatteryDataComponent)batteryStack.method_58694((class_9331)IRobotDataComponents.BATTERY_DATA.get());
            if (data != null && data.energy() < data.maxEnergy()) {
                double newEnergy = Math.min(data.energy() + (double)((Integer)IRobotConfig.ROBOT_STATION_CHARGE_RATE.get()).intValue(), data.maxEnergy());
                batteryStack.method_57379((class_9331)IRobotDataComponents.BATTERY_DATA.get(), (Object)data.withEnergy(newEnergy));
            } else if (data == null) {
                batteryStack.method_57379((class_9331)IRobotDataComponents.BATTERY_DATA.get(), (Object)new BatteryDataComponent(0.0, ((BatteryItem)batteryStack.method_7909()).getMaxEnergy()));
            }
        }
    }

    private static void chargeBatteryItem(class_1542 itemEntity) {
        class_1799 itemStack = itemEntity.method_6983();
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof BatteryItem) {
            BatteryItem batteryItem = (BatteryItem)class_17922;
            BatteryDataComponent data = (BatteryDataComponent)itemStack.method_58694((class_9331)IRobotDataComponents.BATTERY_DATA.get());
            if (data != null && data.energy() < data.maxEnergy()) {
                double newEnergy = Math.min(data.energy() + (double)((Integer)IRobotConfig.ROBOT_STATION_CHARGE_RATE.get()).intValue(), data.maxEnergy());
                itemStack.method_57379((class_9331)IRobotDataComponents.BATTERY_DATA.get(), (Object)data.withEnergy(newEnergy));
            } else if (data == null) {
                itemStack.method_57379((class_9331)IRobotDataComponents.BATTERY_DATA.get(), (Object)new BatteryDataComponent(0.0, batteryItem.getMaxEnergy()));
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

